/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.util.LocalMagnitude;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.ScaleCalc;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.trace.StationView;
import edu.geophys.hypoline.ui.trace.ThreeCompRenderer;
import edu.geophys.hypoline.ui.trace.TraceRenderer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class SiteModel
extends Site {
    private static final long serialVersionUID = 1L;
    private SNS sns;
    private float fl = 0.0f;
    private float fu = 0.0f;
    private StationView.RenderMode renderMode = StationView.RenderMode.TRACE;
    private double start;
    private double length;
    private boolean pOrSActive = true;
    private TraceRenderer.TraceType lastMouseClickTraceType = TraceRenderer.TraceType.TRACE_Z;
    private double pPick = Double.NaN;
    private double pPreviousPick = Double.NaN;
    private double sPick = Double.NaN;
    private double sPreviousPick = Double.NaN;
    private double pSimulPick = Double.NaN;
    private double sSimulPick = Double.NaN;
    private double pCorr = Double.NaN;
    private double pPreviousCorr = Double.NaN;
    private double pRay = Double.NaN;
    private double sCorr = Double.NaN;
    private double sPreviousCorr = Double.NaN;
    private double simulatedpCorr = Double.NaN;
    private double simulatedsCorr = Double.NaN;
    private double magnitude1Pick = Double.NaN;
    private double magnitude1PreviousPick = Double.NaN;
    private double magnitude2Pick = Double.NaN;
    private double magnitude2PreviousPick = Double.NaN;
    private String magnitudePickTrace = null;
    private String magnitudePreviousPickTrace = null;
    private double pPickUncertainty = 0.0;
    private double sPickUncertainty = 0.0;
    private double pBeamCertainty = 1.0;
    private double sBeamCertainty = 1.0;
    private double mepPick = Double.NaN;
    private double meOrigpPick = Double.NaN;
    private DefaultTrace currentZoomZTrace = new DefaultTrace();
    private DefaultTrace currentZoomNTrace = new DefaultTrace();
    private DefaultTrace currentZoomETrace = new DefaultTrace();
    private float currentMaxValue = -1.0f;
    private float currentMaxNValue = -1.0f;
    private float currentMaxEValue = -1.0f;
    private SiteModel child;
    private double pBeamAngle = Double.NaN;
    private double sBeamAngle = Double.NaN;
    private double pBeamAppVelocity = Double.NaN;
    private double sBeamAppVelocity = Double.NaN;
    private double epiDist = Double.NaN;
    private double hypoDist = Double.NaN;
    private double tstpDist = Double.NaN;
    private float magnitudeAmpMy = Float.NaN;
    private float magnitudeMl = Float.NaN;
    private float simulatedAmplitude = Float.NaN;
    private double onsetTimeSP = Double.NaN;
    private int showStacked = 0;
    private boolean polarityFlip = false;
    private ThreeCompRenderer threeComp;
    private boolean activeTrace = false;

    public SiteModel() {
    }

    public SiteModel(Site site, boolean bl, SNS sNS) {
        super(site.getId(), site.getTraceZ(), site.getXOffsetKm(), site.getYOffsetKm(), site.getZOffsetKm(), site.getStaticMs(), site.getClockMs(), site.getTraceActive(), site.getMlCorrection(), site.getpPickCorrection(), site.getsPickCorrection());
        this.sns = sNS;
        if (bl) {
            this.child = new SiteModel(site, false, sNS);
            this.child.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("firepick")) {
                        LogUtil.info(this.getClass(), (String)"child firepick");
                        SiteModel.this.pPick = SiteModel.this.child.getpPick();
                        SiteModel.this.sPick = SiteModel.this.child.getsPick();
                        SiteModel.this.pCorr = SiteModel.this.child.getpCorr();
                        SiteModel.this.sCorr = SiteModel.this.child.getsCorr();
                        SiteModel.this.magnitude1Pick = SiteModel.this.child.getMagnitude1Pick();
                        SiteModel.this.magnitude2Pick = SiteModel.this.child.getMagnitude2Pick();
                        SiteModel.this.updateRepaint();
                    } else if (propertyChangeEvent.getPropertyName().equals("fl")) {
                        LogUtil.info(this.getClass(), (String)"child fl");
                        SiteModel.this.fl = SiteModel.this.child.getFl();
                        SiteModel.this.update(SiteModel.this.start, SiteModel.this.length, SiteModel.this.renderMode);
                    } else if (propertyChangeEvent.getPropertyName().equals("fu")) {
                        LogUtil.info(this.getClass(), (String)"child fu");
                        SiteModel.this.fu = SiteModel.this.child.getFu();
                        SiteModel.this.update(SiteModel.this.start, SiteModel.this.length, SiteModel.this.renderMode);
                    } else if (propertyChangeEvent.getPropertyName().equals("flfu")) {
                        LogUtil.info(this.getClass(), (String)"child flfu");
                        SiteModel.this.fl = SiteModel.this.child.getFl();
                        SiteModel.this.fu = SiteModel.this.child.getFu();
                        SiteModel.this.update(SiteModel.this.start, SiteModel.this.length, SiteModel.this.renderMode);
                    }
                }
            });
        }
        this.setTraceEW(site.getTraceEW());
        this.setTraceNS(site.getTraceNS());
    }

    public float getFl() {
        return this.fl;
    }

    public void setFl(float f) {
        float f2 = this.fl;
        this.fl = f;
        this.update();
        this.firePropertyChange("fl", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getFu() {
        return this.fu;
    }

    public void setFu(float f) {
        float f2 = this.fu;
        this.fu = f;
        this.update();
        this.firePropertyChange("fu", Float.valueOf(f2), Float.valueOf(f));
    }

    public void setFlFu(float f, float f2) {
        this.fl = f;
        this.fu = f2;
        this.update();
        this.firePropertyChange("flfu", null, null);
    }

    public String getTraceName(TraceRenderer.TraceType traceType) {
        switch (traceType) {
            case TRACE_EW: {
                return this.getTraceEW();
            }
            case TRACE_NS: {
                return this.getTraceNS();
            }
        }
        return this.getTraceZ();
    }

    public StationView.RenderMode getRenderMode() {
        return this.renderMode;
    }

    public void setRenderMode(StationView.RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double d) {
        this.start = d;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double d) {
        this.length = d;
    }

    public double getpPick() {
        return this.pPick;
    }

    public double getPUncertainty() {
        return this.pPickUncertainty;
    }

    public double getSUncertainty() {
        return this.sPickUncertainty;
    }

    public void setPUncertainty(double d) {
        this.pPickUncertainty = d;
        this.updateRepaint();
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            HypoLineManager.INSTANCE.getEpiMapDb().updatePPick(this);
            HypoLineManager.INSTANCE.getEpiMapDb().updateSPick(this);
        }
    }

    public void setSUncertainty(double d) {
        this.sPickUncertainty = d;
        this.updateRepaint();
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            HypoLineManager.INSTANCE.getEpiMapDb().updateSPick(this);
        }
    }

    public void setpPick(double d) {
        this.pPreviousPick = this.pPick;
        this.pPick = d;
        this.firePropertyChange("firepick", this.pPreviousPick, d);
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            HypoLineManager.INSTANCE.getEpiMapDb().updatePPick(this);
            HypoLineManager.INSTANCE.getEpiMapDb().updateSPick(this);
            if (HypoLineManager.INSTANCE.getMasterEventManager().isInitialized()) {
                HypoLineManager.INSTANCE.getMasterEventManager().updatePick(this);
            }
        }
    }

    public double getsPick() {
        return this.sPick;
    }

    public void setsPick(double d) {
        this.sPreviousPick = this.sPick;
        this.sPick = d;
        this.firePropertyChange("firepick", this.sPreviousPick, d);
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            HypoLineManager.INSTANCE.getEpiMapDb().updateSPick(this);
        }
    }

    public void undoPick() {
        switch (HypoLineManager.INSTANCE.getConfig().getHypoLineMode()) {
            case NETWORK: {
                if (this.pOrSActive) {
                    this.setpPick(this.pPreviousPick);
                    break;
                }
                this.setsPick(this.sPreviousPick);
                break;
            }
            case MAGNITUDE: {
                if (this.pOrSActive) {
                    this.setMagnitude1Pick(this.magnitude1PreviousPick);
                } else {
                    this.setMagnitude2Pick(this.magnitude2PreviousPick);
                }
                this.setMagnitudePickTrace(this.magnitudePreviousPickTrace);
                break;
            }
        }
    }

    public boolean ispOrSActive() {
        return this.pOrSActive;
    }

    public void setpOrSActive(boolean bl) {
        this.pOrSActive = bl;
    }

    public boolean isActiveTrace() {
        return this.activeTrace;
    }

    public void setActiveTrace(boolean bl) {
        this.activeTrace = bl;
        if (bl && HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
            HypoLineManager.INSTANCE.getEpiMapDb().setActiveStation(this);
        }
    }

    public ThreeCompRenderer getThreeComp() {
        return this.threeComp;
    }

    public void setThreeComp(ThreeCompRenderer threeCompRenderer) {
        this.threeComp = threeCompRenderer;
    }

    public void update() {
        this.firePropertyChange("update", 0, 1);
    }

    public void update(double d, double d2, StationView.RenderMode renderMode) {
        this.start = d;
        this.length = d2;
        this.renderMode = renderMode;
        this.update();
    }

    public void resetMaxValues() {
        this.currentMaxValue = -1.0f;
        this.currentMaxEValue = -1.0f;
        this.currentMaxNValue = -1.0f;
    }

    public void triggerAutomaticCalc() {
        this.firePropertyChange("automaticCalc", 0, 1);
    }

    public void triggerAutomaticCalc2() {
        this.firePropertyChange("automaticCalc2", 0, 1);
    }

    public double getpCorr() {
        return this.pCorr;
    }

    public void setpCorr(double d) {
        this.pPreviousCorr = this.pCorr;
        this.pCorr = d;
        this.firePropertyChange("firepick", this.pPreviousCorr, d);
    }

    public double getsCorr() {
        return this.sCorr;
    }

    public void setsCorr(double d) {
        this.sPreviousCorr = this.sCorr;
        this.sCorr = d;
        this.firePropertyChange("firepick", this.sPreviousCorr, d);
    }

    public DefaultTrace getCurrentZoomZTrace() {
        return this.currentZoomZTrace;
    }

    public void setCurrentZoomZTrace(DefaultTrace defaultTrace) {
        this.currentZoomZTrace = defaultTrace;
    }

    public float getCurrentMaxValue() {
        return this.currentMaxValue;
    }

    public void setCurrentMaxValue(float f) {
        this.currentMaxValue = ScaleCalc.getRoundedScale((float)f);
    }

    public DefaultTrace getCurrentZoomNTrace() {
        return this.currentZoomNTrace;
    }

    public void setCurrentZoomNTrace(DefaultTrace defaultTrace) {
        this.currentZoomNTrace = defaultTrace;
    }

    public DefaultTrace getCurrentZoomETrace() {
        return this.currentZoomETrace;
    }

    public void setCurrentZoomETrace(DefaultTrace defaultTrace) {
        this.currentZoomETrace = defaultTrace;
    }

    public float getCurrentMaxNValue() {
        return this.currentMaxNValue;
    }

    public void setCurrentMaxNValue(float f) {
        this.currentMaxNValue = ScaleCalc.getRoundedScale((float)f);
    }

    public float getCurrentMaxEValue() {
        return this.currentMaxEValue;
    }

    public void setCurrentMaxEValue(float f) {
        this.currentMaxEValue = ScaleCalc.getRoundedScale((float)f);
    }

    public SiteModel getChild() {
        return this.child;
    }

    public void setChild(SiteModel siteModel) {
        this.child = siteModel;
    }

    public double getpBeamAngle() {
        return this.pBeamAngle;
    }

    public void setpBeamAngle(double d) {
        this.pBeamAngle = d;
        HypoLineManager.INSTANCE.getEpiMapDb().paintAllStations();
        HypoLineManager.INSTANCE.getEpiMapDb().updatePBeamPick(this);
    }

    public double getsBeamAngle() {
        return this.sBeamAngle;
    }

    public void setsBeamAngle(double d) {
        this.sBeamAngle = d;
        HypoLineManager.INSTANCE.getEpiMapDb().paintAllStations();
    }

    public void updateRepaint() {
        this.firePropertyChange("repaint", null, null);
    }

    public double getEpiDist() {
        return this.epiDist;
    }

    public void setEpiDist(double d) {
        this.epiDist = d;
        this.updateMl();
    }

    public double getTstpDist() {
        return this.tstpDist;
    }

    public void setTstpDist(double d) {
        this.tstpDist = d;
        this.updateRepaint();
    }

    public double getMagnitude1Pick() {
        return this.magnitude1Pick;
    }

    public void setMagnitude1Pick(double d) {
        this.setMagnitude1Pick(d, null);
    }

    public void setMagnitude1Pick(double d, String string) {
        if (!(string == null || this.getMagnitudePickTrace() != null && this.getMagnitudePickTrace().equals(string))) {
            this.setMagnitudePickTrace(string);
            this.setMagnitude2Pick(Double.NaN);
        }
        this.magnitude1PreviousPick = this.magnitude1Pick;
        this.magnitude1Pick = d;
        if (Double.isNaN(d)) {
            this.setMagnitudeAmpMy(Float.NaN);
        }
        this.firePropertyChange("firepick", this.magnitude1PreviousPick, d);
    }

    public double getMagnitude2Pick() {
        return this.magnitude2Pick;
    }

    public void setMagnitude2Pick(double d) {
        this.setMagnitude2Pick(d, null);
    }

    public void setMagnitude2Pick(double d, String string) {
        if (!(string == null || this.getMagnitudePickTrace() != null && this.getMagnitudePickTrace().equals(string))) {
            this.setMagnitudePickTrace(string);
            this.setMagnitude1Pick(Double.NaN);
        }
        this.magnitude2PreviousPick = this.magnitude2Pick;
        this.magnitude2Pick = d;
        if (Double.isNaN(d)) {
            this.setMagnitudeAmpMy(Float.NaN);
        }
        this.firePropertyChange("firepick", this.magnitude2PreviousPick, d);
    }

    public float getMagnitudeAmpMy() {
        return this.magnitudeAmpMy;
    }

    public void setMagnitudeAmpMy(float f) {
        this.magnitudeAmpMy = f;
        this.updateMl();
    }

    public void updateMl() {
        if (!Float.isNaN(this.magnitudeAmpMy) && !Double.isNaN(this.epiDist)) {
            float f = HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().getSimul_depth();
            this.hypoDist = (float)Math.sqrt(this.getEpiDist() * this.getEpiDist() + (double)(f * f));
            this.setMagnitudeMl(new LocalMagnitude().calcMl((float)this.hypoDist, this.magnitudeAmpMy));
        } else {
            this.setMagnitudeMl(Float.NaN);
        }
        HypoLineManager.INSTANCE.getMagnitudePanel().update();
    }

    public double getpBeamAppVelocity() {
        return this.pBeamAppVelocity;
    }

    public void setpBeamAppVelocity(double d) {
        this.pBeamAppVelocity = d;
    }

    public double getsBeamAppVelocity() {
        return this.sBeamAppVelocity;
    }

    public void setsBeamAppVelocity(double d) {
        this.sBeamAppVelocity = d;
    }

    public SNS getSns() {
        return this.sns;
    }

    public float getMagnitudeMl() {
        return this.magnitudeMl;
    }

    public void setMagnitudeMl(float f) {
        this.magnitudeMl = f;
    }

    public void reset() {
        this.fl = 0.0f;
        this.fu = 0.0f;
        this.renderMode = StationView.RenderMode.TRACE;
        this.pPick = Double.NaN;
        this.sPick = Double.NaN;
        this.pPickUncertainty = 0.0;
        this.sPickUncertainty = 0.0;
        this.pCorr = Double.NaN;
        this.sCorr = Double.NaN;
        this.pSimulPick = Double.NaN;
        this.sSimulPick = Double.NaN;
        this.simulatedpCorr = Double.NaN;
        this.simulatedsCorr = Double.NaN;
        this.pOrSActive = true;
        this.pBeamAngle = Double.NaN;
        this.sBeamAngle = Double.NaN;
        this.pBeamAppVelocity = Double.NaN;
        this.sBeamAppVelocity = Double.NaN;
        this.epiDist = Double.NaN;
        this.tstpDist = Double.NaN;
        this.magnitude1Pick = Double.NaN;
        this.magnitude2Pick = Double.NaN;
        this.magnitudeAmpMy = Float.NaN;
        this.magnitudeMl = Float.NaN;
    }

    public float getSimulatedAmplitude() {
        return this.simulatedAmplitude;
    }

    public void setSimulatedAmplitude(float f) {
        this.simulatedAmplitude = f;
    }

    public double getSimulatedpCorr() {
        return this.simulatedpCorr;
    }

    public void setSimulatedpCorr(double d) {
        this.simulatedpCorr = d;
    }

    public double getSimulatedsCorr() {
        return this.simulatedsCorr;
    }

    public void setSimulatedsCorr(double d) {
        this.simulatedsCorr = d;
    }

    public double getOnsetTimeSP() {
        return this.onsetTimeSP;
    }

    public void setOnsetTimeSP(double d) {
        this.onsetTimeSP = d;
    }

    public double getpSimulPick() {
        return this.pSimulPick;
    }

    public void setpSimulPick(double d) {
        this.pSimulPick = d;
    }

    public double getsSimulPick() {
        return this.sSimulPick;
    }

    public void setsSimulPick(double d) {
        this.sSimulPick = d;
    }

    public int getShowStacked() {
        return this.showStacked;
    }

    public void setShowStacked(int n) {
        this.showStacked = n;
    }

    public boolean isPolarityFlip() {
        return this.polarityFlip;
    }

    public void setPolarityFlip(boolean bl) {
        this.polarityFlip = bl;
    }

    public double getMepPick() {
        return this.mepPick;
    }

    public void setMepPick(double d) {
        this.mepPick = d;
    }

    public double getMeOrigpPick() {
        return this.meOrigpPick;
    }

    public void setMeOrigpPick(double d) {
        this.meOrigpPick = d;
    }

    public double getpPreviousPick() {
        return this.pPreviousPick;
    }

    public void setpPreviousPick(double d) {
        this.pPreviousPick = d;
    }

    public double getsPreviousPick() {
        return this.sPreviousPick;
    }

    public void setsPreviousPick(double d) {
        this.sPreviousPick = d;
    }

    public double getpBeamCertainty() {
        return this.pBeamCertainty;
    }

    public void setpBeamCertainty(double d) {
        this.pBeamCertainty = d;
    }

    public double getsBeamCertainty() {
        return this.sBeamCertainty;
    }

    public void setsBeamCertainty(double d) {
        this.sBeamCertainty = d;
    }

    public double getHypoDist() {
        return this.hypoDist;
    }

    public void setHypoDist(double d) {
        this.hypoDist = d;
    }

    public TraceRenderer.TraceType getLastMouseClickTraceType() {
        return this.lastMouseClickTraceType;
    }

    public void setLastMouseClickTraceType(TraceRenderer.TraceType traceType) {
        this.lastMouseClickTraceType = traceType;
    }

    public double getpRay() {
        return this.pRay;
    }

    public void setpRay(double d) {
        this.pRay = d;
    }

    public Site.SiteRole getSiteRole() {
        SNS sNS = this.getSns();
        String string = this.getId();
        if (sNS == null) {
            return Site.SiteRole.OTHER;
        }
        if (string == sNS.getCenter().getId()) {
            return Site.SiteRole.CENTER;
        }
        if (string == sNS.getNorth().getId() || string == sNS.getEast().getId() || string == sNS.getWest().getId()) {
            return Site.SiteRole.SATELLITE;
        }
        return Site.SiteRole.OTHER;
    }

    public String getMagnitudePickTrace() {
        return this.magnitudePickTrace;
    }

    private void setMagnitudePickTrace(String string) {
        this.magnitudePreviousPickTrace = this.magnitudePickTrace;
        this.magnitudePickTrace = string;
    }
}

