/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.range.RangeDataEvent;
import edu.geophys.commons.range.RangeDataListener;
import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.range.RangeMarkerModelChild;
import edu.geophys.commons.suite.EventWindowModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.ui.time.JCursorTimeAxis;
import edu.geophys.commons.ui.time.JTimeAxis;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.DebugClock;
import edu.geophys.commons.util.FileUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.protocol.ProtFileManager;
import edu.geophys.hypoline.ui.Legend;
import edu.geophys.hypoline.ui.trace.AbstractRenderer;
import edu.geophys.hypoline.ui.trace.ArrayModeTraceRenderer;
import edu.geophys.hypoline.ui.trace.LabelPanel;
import edu.geophys.hypoline.ui.trace.MouseRenderer;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.trace.ThreeCompRenderer;
import edu.geophys.hypoline.ui.trace.TraceRenderer;
import edu.geophys.sonoview.DataManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import layout.TableLayout;

public class StationView
extends ActivateableComponent
implements RangeDataListener {
    private static final long serialVersionUID = 1L;
    private BoundedLongRangeModel timeAxisModel = new DefaultBoundedLongRangeModel();
    private JCursorTimeAxis timeAxis = new JCursorTimeAxis(JTimeAxis.Alignment.SOUTH);
    private JLabel dateLabel = new JLabel("date");
    private final StationsKnowledge sk = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
    private CampaignKnowledge ck = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
    private final HypoLineConfiguration config = HypoLineManager.INSTANCE.getConfig();
    private final RangeMarkerModel<Object> markerModel;
    public final String CHILDS;
    public final String CHILDE;
    private final String MOUSE = "MOUSE";
    private RenderMode renderMode = RenderMode.TRACE;
    private StationView parent;
    private final EventWindowModel ewm = SuiteManager.INSTANCE.getGlobalEventWindowModel();
    private int innerCounter;
    private int mainCounter;
    private JPanel container;
    private double start;
    private double length;
    private List<SiteModel> sitemodels;
    private List<AbstractRenderer> plots = new ArrayList<AbstractRenderer>();
    protected MouseListener timeAxisMouseAdapter = new MouseListener(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            double d = MathUtil.convertToRelative((int)mouseEvent.getX(), (int)0, (int)StationView.this.timeAxis.getWidth());
            double d2 = StationView.this.markerModel.getMarker(StationView.this.CHILDS).getPosition();
            double d3 = StationView.this.markerModel.getMarker(StationView.this.CHILDE).getPosition();
            if (mouseEvent.getButton() == 1) {
                if (d > d3) {
                    StationView.this.markerModel.moveMarker(d - d2, new String[]{StationView.this.CHILDS, StationView.this.CHILDE});
                } else {
                    StationView.this.markerModel.setMarker(StationView.this.CHILDS, d, null);
                }
            } else if (mouseEvent.getButton() == 3) {
                if (d < d2) {
                    StationView.this.markerModel.moveMarker(d - d3, new String[]{StationView.this.CHILDS, StationView.this.CHILDE});
                } else {
                    StationView.this.markerModel.setMarker(StationView.this.CHILDE, d, null);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }
    };
    private MouseListener dateLabelMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                HypoLineManager.INSTANCE.getConfig().setActiveSNS(-2);
                HypoLineManager.INSTANCE.updateSelectedStationDisplay();
                HypoLineManager.INSTANCE.getHlApp().getMainFrame().resetSplitPane();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }
    };
    private KeyListener keyListener = new KeyListener(){

        /*
         * Unable to fully structure code
         */
        @Override
        public void keyPressed(KeyEvent var1_1) {
            block103: {
                block102: {
                    if (var1_1.getKeyCode() == 67) {
                        HypoLineManager.INSTANCE.getConfig().setCommonScaling(HypoLineManager.INSTANCE.getConfig().isCommonScaling() == false);
                        StationView.this.updateModel(false);
                    }
                    if (StationView.this.isZoomPanel()) break block102;
                    var2_2 = StationView.this.ewm.getLength() / 10L;
                    var4_4 = StationView.this.markerModel.getMarker("1b").getPosition() - StationView.this.markerModel.getMarker("1a").getPosition();
                    if (var1_1.isControlDown()) {
                        var6_11 = (double)StationView.this.ewm.getLength() / 1000.0 * (double)StationView.this.ck.getGlobalSamplerate();
                        var4_4 = 1.0 / var6_11 * 2.0;
                    }
                    switch (var1_1.getKeyCode()) {
                        case 37: {
                            if (!var1_1.isShiftDown()) ** GOTO lbl27
                            HypoLineManager.INSTANCE.getProtFileManager().load();
                            var6_12 = HypoLineManager.INSTANCE.getProtFileManager().getProtEntries();
                            Collections.sort(var6_12);
                            var7_28 = null;
                            for (var8_35 = var6_12.size() - 1; var8_35 >= 0; --var8_35) {
                                if (var6_12.get(var8_35).getDate() >= StationView.this.ewm.getStartEpochTimeMs()) continue;
                                StationView.this.ewm.setStartEpochTimeMs(var6_12.get(var8_35).getDate());
                                var7_28 = var6_12.get(var8_35);
                                break;
                            }
                            if (var7_28 != null) {
                                HypoLineManager.INSTANCE.getProtFileManager().loadFromProtFile();
                                break;
                            }
                            break block103;
lbl27:
                            // 1 sources

                            if (StationView.this.markerModel.getMarker("1a").getPosition() <= 0.1) {
                                StationView.this.ewm.setStartEpochTimeMs(StationView.this.ewm.getStartEpochTimeMs() - var2_2);
                                break;
                            }
                            StationView.this.markerModel.moveMarker(-var4_4 / 8.0, new String[]{"1a", "1b"});
                            break;
                        }
                        case 39: {
                            if (!var1_1.isShiftDown()) ** GOTO lbl48
                            HypoLineManager.INSTANCE.getProtFileManager().load();
                            var6_13 = HypoLineManager.INSTANCE.getProtFileManager().getProtEntries();
                            Collections.sort(var6_13);
                            var7_29 = null;
                            for (var8_36 = 0; var8_36 < var6_13.size(); ++var8_36) {
                                if (var6_13.get(var8_36).getDate() <= StationView.this.ewm.getStartEpochTimeMs() + StationView.this.ewm.getLength()) continue;
                                StationView.this.ewm.setStartEpochTimeMs(var6_13.get(var8_36).getDate());
                                var7_29 = var6_13.get(var8_36);
                                break;
                            }
                            if (var7_29 != null) {
                                HypoLineManager.INSTANCE.getProtFileManager().loadFromProtFile();
                                break;
                            }
                            break block103;
lbl48:
                            // 1 sources

                            if (StationView.this.markerModel.getMarker("1b").getPosition() > 0.9) {
                                StationView.this.ewm.setStartEpochTimeMs(StationView.this.ewm.getStartEpochTimeMs() + var2_2);
                                break;
                            }
                            StationView.this.markerModel.moveMarker(var4_4 / 8.0, new String[]{"1a", "1b"});
                            break;
                        }
                        case 38: {
                            StationView.this.zoomInIncremental(true);
                            break;
                        }
                        case 40: {
                            StationView.this.zoomInIncremental(false);
                            break;
                        }
                        case 33: {
                            DataManager.getInstance().setEventWindowLength(true);
                            break;
                        }
                        case 34: {
                            DataManager.getInstance().setEventWindowLength(false);
                            break;
                        }
                        case 112: {
                            if (var1_1.isShiftDown()) {
                                Legend.legendf1(Legend.WindowName.MASTEREVENT);
                                break;
                            }
                            Legend.legendf1(Legend.WindowName.SEISMOPLOT);
                            break;
                        }
                    }
                    break block103;
                }
                var2_3 = HypoLineManager.INSTANCE.getConfig().getHypoLineMode();
                switch (var1_1.getKeyCode()) {
                    case 40: {
                        if (var1_1.isAltDown()) {
                            if (!var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK) || !HypoLineManager.INSTANCE.getMasterEventManager().isInitialized()) break;
                            HypoLineManager.INSTANCE.getMasterEventManager().setMeAmpFactor(HypoLineManager.INSTANCE.getMasterEventManager().getMeAmpFactor() / 2.0);
                            StationView.this.updateModel(false);
                            break;
                        }
                        var3_38 = 0;
                        var4_5 = -1;
                        for (SiteModel var6_14 : StationView.this.sitemodels) {
                            if (var6_14.isActiveTrace()) {
                                var4_5 = var3_38;
                                break;
                            }
                            ++var3_38;
                        }
                        if (var4_5 == -1) break;
                        StationView.this.sitemodels.get(var4_5).setActiveTrace(false);
                        StationView.this.sitemodels.get((var4_5 + 1) % StationView.this.sitemodels.size()).setActiveTrace(true);
                        StationView.this.updateModel(false);
                        HypoLineManager.INSTANCE.getEpiMapDb().updateSimulation();
                        break;
                    }
                    case 38: {
                        if (var1_1.isAltDown()) {
                            if (!var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK) || !HypoLineManager.INSTANCE.getMasterEventManager().isInitialized()) break;
                            HypoLineManager.INSTANCE.getMasterEventManager().setMeAmpFactor(HypoLineManager.INSTANCE.getMasterEventManager().getMeAmpFactor() * 2.0);
                            StationView.this.updateModel(false);
                            break;
                        }
                        var3_39 = 0;
                        var4_6 = -1;
                        for (SiteModel var6_15 : StationView.this.sitemodels) {
                            if (var6_15.isActiveTrace()) {
                                var4_6 = var3_39;
                                break;
                            }
                            ++var3_39;
                        }
                        if (var4_6 == -1) break;
                        StationView.this.sitemodels.get(var4_6).setActiveTrace(false);
                        var5_43 = var4_6 - 1;
                        if (var5_43 < 0) {
                            var5_43 = StationView.this.sitemodels.size() - 1;
                        }
                        StationView.this.sitemodels.get(var5_43).setActiveTrace(true);
                        StationView.this.updateModel(false);
                        HypoLineManager.INSTANCE.getEpiMapDb().updateSimulation();
                        break;
                    }
                    case 39: {
                        var3_40 = false;
                        if (var1_1.isShiftDown()) {
                            for (SiteModel var5_44 : StationView.this.sitemodels) {
                                if (!var5_44.isActiveTrace()) continue;
                                if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                                    var6_16 = 1.0 / (double)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
                                    if (var5_44.ispOrSActive()) {
                                        if (var5_44.getPUncertainty() <= 0.0) {
                                            var5_44.setPUncertainty(var6_16);
                                            continue;
                                        }
                                        var5_44.setPUncertainty(var5_44.getPUncertainty() + var6_16);
                                        continue;
                                    }
                                    if (var5_44.getSUncertainty() <= 0.0) {
                                        var5_44.setSUncertainty(var6_16);
                                        continue;
                                    }
                                    var5_44.setSUncertainty(var5_44.getSUncertainty() + var6_16);
                                    continue;
                                }
                                if (!var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) continue;
                                if (var5_44.ispOrSActive()) {
                                    var5_44.setpCorr(var5_44.getpCorr() + 1.0);
                                    continue;
                                }
                                var5_44.setsCorr(var5_44.getsCorr() + 1.0);
                            }
                        } else if (var1_1.isAltDown()) {
                            if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK) && HypoLineManager.INSTANCE.getMasterEventManager().isInitialized()) {
                                HypoLineManager.INSTANCE.getMasterEventManager().setMeShift(HypoLineManager.INSTANCE.getMasterEventManager().getMeShift() - 1);
                                var3_40 = true;
                            }
                        } else if (var1_1.isControlDown()) {
                            var4_8 = true;
                            for (SiteModel var6_17 : StationView.this.sitemodels) {
                                if (!var6_17.isActiveTrace()) continue;
                                var4_8 = var6_17.ispOrSActive();
                            }
                            for (SiteModel var6_17 : StationView.this.sitemodels) {
                                var6_17.setpOrSActive(var4_8 == false);
                            }
                        } else {
                            for (SiteModel var5_46 : StationView.this.sitemodels) {
                                if (!var5_46.isActiveTrace()) continue;
                                if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                                    if (var5_46.ispOrSActive()) {
                                        var6_18 = new DebugClock("PPick processing");
                                        var5_46.setpPick(var5_46.getpPick() + 1.0 / (double)StationView.this.ck.getGlobalSamplerate());
                                        var6_18.tick();
                                        HypoLineManager.INSTANCE.getEpiMapDb().updateSimulation();
                                        continue;
                                    }
                                    var5_46.setsPick(var5_46.getsPick() + 1.0 / (double)StationView.this.ck.getGlobalSamplerate());
                                    continue;
                                }
                                if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                                    if (var5_46.ispOrSActive()) {
                                        var5_46.setMagnitude1Pick(var5_46.getMagnitude1Pick() + 1.0 / (double)StationView.this.ck.getGlobalSamplerate(), var5_46.getMagnitudePickTrace());
                                        continue;
                                    }
                                    var5_46.setMagnitude2Pick(var5_46.getMagnitude2Pick() + 1.0 / (double)StationView.this.ck.getGlobalSamplerate(), var5_46.getMagnitudePickTrace());
                                    continue;
                                }
                                if (!var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) continue;
                                if (var5_46.ispOrSActive()) {
                                    var5_46.setpCorr(var5_46.getpCorr() + 1.0 / (double)StationView.this.ck.getGlobalSamplerate());
                                    continue;
                                }
                                var5_46.setsCorr(var5_46.getsCorr() + 1.0 / (double)StationView.this.ck.getGlobalSamplerate());
                            }
                        }
                        StationView.this.updateModel(var3_40);
                        break;
                    }
                    case 37: {
                        var4_10 = false;
                        if (var1_1.isShiftDown()) {
                            for (SiteModel var6_19 : StationView.this.sitemodels) {
                                if (!var6_19.isActiveTrace()) continue;
                                if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                                    var7_30 = 1.0 / (double)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
                                    if (var6_19.ispOrSActive()) {
                                        if (var6_19.getPUncertainty() < 0.0) {
                                            var6_19.setPUncertainty(0.0);
                                            continue;
                                        }
                                        var6_19.setPUncertainty(var6_19.getPUncertainty() - var7_30);
                                        continue;
                                    }
                                    if (var6_19.getSUncertainty() < 0.0) {
                                        var6_19.setSUncertainty(0.0);
                                        continue;
                                    }
                                    var6_19.setSUncertainty(var6_19.getSUncertainty() - var7_30);
                                    continue;
                                }
                                if (!var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) continue;
                                if (var6_19.ispOrSActive()) {
                                    var6_19.setpCorr(var6_19.getpCorr() - 1.0);
                                    continue;
                                }
                                var6_19.setsCorr(var6_19.getsCorr() - 1.0);
                            }
                        } else if (var1_1.isAltDown()) {
                            if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK) && HypoLineManager.INSTANCE.getMasterEventManager().isInitialized()) {
                                HypoLineManager.INSTANCE.getMasterEventManager().setMeShift(HypoLineManager.INSTANCE.getMasterEventManager().getMeShift() + 1);
                                var4_10 = true;
                            }
                        } else if (var1_1.isControlDown()) {
                            var5_48 = true;
                            for (SiteModel var7_31 : StationView.this.sitemodels) {
                                if (!var7_31.isActiveTrace()) continue;
                                var5_48 = var7_31.ispOrSActive();
                            }
                            for (SiteModel var7_31 : StationView.this.sitemodels) {
                                var7_31.setpOrSActive(var5_48 == false);
                            }
                        } else {
                            for (SiteModel var6_21 : StationView.this.sitemodels) {
                                if (!var6_21.isActiveTrace()) continue;
                                if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                                    if (var6_21.ispOrSActive()) {
                                        var6_21.setpPick(var6_21.getpPick() - 1.0 / (double)StationView.this.ck.getGlobalSamplerate());
                                        HypoLineManager.INSTANCE.getEpiMapDb().updateSimulation();
                                        continue;
                                    }
                                    var6_21.setsPick(var6_21.getsPick() - 1.0 / (double)StationView.this.ck.getGlobalSamplerate());
                                    continue;
                                }
                                if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) {
                                    LogUtil.info(this.getClass(), (String)"Shifting magnitude picks with arrow keys is temporarly disabled.", (boolean)true);
                                    continue;
                                }
                                if (!var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) continue;
                                if (var6_21.ispOrSActive()) {
                                    var6_21.setpCorr(var6_21.getpCorr() - 1.0 / (double)StationView.this.ck.getGlobalSamplerate());
                                    continue;
                                }
                                var6_21.setsCorr(var6_21.getsCorr() - 1.0 / (double)StationView.this.ck.getGlobalSamplerate());
                            }
                        }
                        StationView.this.updateModel(var4_10);
                        break;
                    }
                    case 66: {
                        for (SiteModel var6_22 : StationView.this.sitemodels) {
                            if (!var1_1.isAltDown()) {
                                var6_22.triggerAutomaticCalc();
                                continue;
                            }
                            var6_22.triggerAutomaticCalc2();
                        }
                        break;
                    }
                    case 72: {
                        HypoLineManager.INSTANCE.getConfig().setExpand3Comp(HypoLineManager.INSTANCE.getConfig().isExpand3Comp() == false);
                        break;
                    }
                    case 69: {
                        HypoLineManager.INSTANCE.getConfig().setShowSatellite(HypoLineManager.INSTANCE.getConfig().isShowSatellite() == false);
                        break;
                    }
                    case 73: {
                        HypoLineManager.INSTANCE.getConfig().setSplineInterpolation(HypoLineManager.INSTANCE.getConfig().isSplineInterpolation() == false);
                        break;
                    }
                    case 65: {
                        HypoLineManager.INSTANCE.getConfig().setShowEventMarkers(HypoLineManager.INSTANCE.getConfig().isShowEventMarkers() == false);
                        break;
                    }
                    case 79: {
                        if (!var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) break;
                        for (SiteModel var6_23 : StationView.this.sitemodels) {
                            var6_23.setShowStacked((var6_23.getShowStacked() + 1) % 3);
                            var6_23.updateRepaint();
                        }
                        break;
                    }
                    case 87: {
                        if (var1_1.isAltDown()) {
                            var5_52 = false;
                            for (SiteModel var7_32 : HypoLineManager.INSTANCE.getSites()) {
                                if (Double.isNaN(var7_32.getpPick())) continue;
                                var5_52 = true;
                                break;
                            }
                            if (var5_52 && HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().isEpiCenterSet()) {
                                var6_24 = new JFileChooser(SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder());
                                var6_24.setFileSelectionMode(0);
                                var7_33 = var6_24.showSaveDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame());
                                if (var7_33 != 0) break;
                                var8_37 = var6_24.getSelectedFile();
                                if (!var8_37.exists()) {
                                    var9_56 = new ProtFileManager(var8_37.getAbsolutePath());
                                    var9_56.saveToProtFile();
                                    break;
                                }
                                LogUtil.error(this.getClass(), (String)"File exists already.", (boolean)true);
                                break;
                            }
                            LogUtil.info(this.getClass(), (String)"To save a master event, at least 1 P-pick and an epicenter must be defined.", (boolean)true);
                            break;
                        }
                        FileUtil.printComponent((JComponent)StationView.this.container, (String)(DateTimeUtil.formatDateTimeOnlynumbers((long)new Date().getTime()) + "-seiszoom.png"));
                        break;
                    }
                    case 80: {
                        for (SiteModel var6_25 : StationView.this.sitemodels) {
                            if (!var6_25.isActiveTrace()) continue;
                            var6_25.setPolarityFlip(var6_25.isPolarityFlip() == false);
                            var6_25.update();
                        }
                        break;
                    }
                    case 85: {
                        for (SiteModel var6_26 : StationView.this.sitemodels) {
                            if (!var6_26.isActiveTrace()) continue;
                            var6_26.undoPick();
                            var6_26.updateRepaint();
                        }
                        break;
                    }
                    case 77: {
                        if (var1_1.isAltDown()) {
                            if (HypoLineManager.INSTANCE.getMasterEventManager().isInitialized()) {
                                HypoLineManager.INSTANCE.getMasterEventManager().setInitialized(false);
                            } else {
                                var5_55 = new JFileChooser(SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder());
                                var5_55.setFileSelectionMode(0);
                                var6_27 = var5_55.showOpenDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame());
                                if (var6_27 == 0) {
                                    var7_34 = var5_55.getSelectedFile();
                                    HypoLineManager.INSTANCE.getMasterEventManager().init(var7_34.getAbsolutePath(), HypoLineManager.INSTANCE.getCurrentSitesDetail());
                                }
                            }
                        }
                        StationView.this.updateModel(true);
                        break;
                    }
                    case 112: {
                        if (var1_1.isShiftDown()) {
                            Legend.legendf1(Legend.WindowName.MASTEREVENT);
                            break;
                        }
                        if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.NETWORK)) {
                            Legend.legendf1(Legend.WindowName.SEISMOPLOTZOOM);
                            break;
                        }
                        if (var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
                            Legend.legendf1(Legend.WindowName.ARRAYZOOM);
                            break;
                        }
                        if (!var2_3.equals((Object)HypoLineConfiguration.HypoLineMode.MAGNITUDE)) break;
                        Legend.legendf1(Legend.WindowName.MAGZOOM);
                    }
                }
            }
            switch (var1_1.getKeyCode()) {
                case 83: {
                    StationView.this.switchRenderer();
                    StationView.this.updateModel(false);
                    break;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    final Comparator<SiteModel> siteModelComparator = new Comparator<SiteModel>(){

        @Override
        public int compare(SiteModel siteModel, SiteModel siteModel2) {
            int n = 0;
            if (Double.isNaN(siteModel.getEpiDist())) {
                return 1;
            }
            if (Double.isNaN(siteModel2.getEpiDist())) {
                return -1;
            }
            n = (int)Math.signum(siteModel.getEpiDist() - siteModel2.getEpiDist());
            return n;
        }
    };
    final Comparator<SNS> snsEpicenterComparator = new Comparator<SNS>(){

        @Override
        public int compare(SNS sNS, SNS sNS2) {
            double d = HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().getX();
            double d2 = HypoLineManager.INSTANCE.getEpiMapDb().getEpiCenter().getY();
            double d3 = sNS.getCenter().getXOffsetKm() - d;
            double d4 = sNS.getCenter().getYOffsetKm() - d2;
            double d5 = sNS2.getCenter().getXOffsetKm() - d;
            double d6 = sNS2.getCenter().getYOffsetKm() - d2;
            double d7 = d3 * d3 + d4 * d4;
            double d8 = d5 * d5 + d6 * d6;
            int n = (int)Math.signum(d7 - d8);
            return n;
        }
    };
    final Comparator<SNS> snsAlphabetComparator = new Comparator<SNS>(){

        @Override
        public int compare(SNS sNS, SNS sNS2) {
            return sNS.getID().compareTo(sNS2.getID());
        }
    };

    public StationView(RangeMarkerModel<Object> rangeMarkerModel, String string, String string2, StationView stationView) {
        this.parent = stationView;
        this.timeAxis.setModel(this.timeAxisModel);
        this.timeAxis.addMouseListener(this.timeAxisMouseAdapter);
        if (!this.isZoomPanel()) {
            this.sitemodels = HypoLineManager.INSTANCE.getCurrentSitesOverview();
            this.renderMode = RenderMode.TRACE;
        } else {
            this.sitemodels = HypoLineManager.INSTANCE.getCurrentSitesDetail();
            this.renderMode = RenderMode.TRACE;
        }
        this.config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogUtil.debug(this.getClass(), (String)("stationview update from config change: " + propertyChangeEvent.getPropertyName()));
                if (propertyChangeEvent.getPropertyName().equals("hypoLineMode")) {
                    if (propertyChangeEvent.getOldValue().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY) && !propertyChangeEvent.getNewValue().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
                        HypoLineManager.INSTANCE.getConfig().setCommonScaling(false);
                    } else if (!propertyChangeEvent.getOldValue().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY) && propertyChangeEvent.getNewValue().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
                        HypoLineManager.INSTANCE.getConfig().setCommonScaling(true);
                    }
                }
                if (propertyChangeEvent.getPropertyName().equals("activeSNS") || propertyChangeEvent.getPropertyName().equals("hypoLineMode") || propertyChangeEvent.getPropertyName().equals("expand3Comp") || propertyChangeEvent.getPropertyName().equals("showSatellite") || propertyChangeEvent.getPropertyName().equals("scrollPane")) {
                    StationView.this.update();
                    StationView.this.updateModel(true);
                } else {
                    StationView.this.updateModel(true);
                }
            }
        });
        this.CHILDS = string;
        this.CHILDE = string2;
        this.markerModel = rangeMarkerModel;
        if (this.isZoomPanel()) {
            stationView.getMarkerModel().addMarkerDataListener((RangeDataListener)this);
        } else {
            this.markerModel.addMarkerDataListener((RangeDataListener)this);
            this.markerModel.setMarker(this.CHILDS, 0.3, null);
            this.markerModel.setMarker(this.CHILDE, 0.7, null);
            this.markerModel.setMarker("MOUSE", 0.5, null);
            this.dateLabel.addMouseListener(this.dateLabelMouseListener);
        }
        this.addKeyListener(this.keyListener);
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}}));
        this.update();
    }

    private void clearPlots() {
        for (AbstractRenderer abstractRenderer : this.plots) {
            if (abstractRenderer == null) continue;
            abstractRenderer.removeChangeListener();
            if (!(abstractRenderer instanceof ThreeCompRenderer)) continue;
            ThreeCompRenderer threeCompRenderer = (ThreeCompRenderer)abstractRenderer;
            if (threeCompRenderer.getTraceZ() != null) {
                threeCompRenderer.getTraceZ().removeChangeListener();
            }
            if (threeCompRenderer.getTraceEW() != null) {
                threeCompRenderer.getTraceEW().removeChangeListener();
            }
            if (threeCompRenderer.getTraceNS() == null) continue;
            threeCompRenderer.getTraceNS().removeChangeListener();
        }
        this.plots.clear();
        this.removeAll();
        this.sitemodels.clear();
    }

    private MouseRenderer createMouseRenderer() {
        MouseRenderer mouseRenderer = !this.isZoomPanel() ? new MouseRenderer((BoundedLongRangeModel)new DefaultBoundedLongRangeModel()) : new MouseRenderer(this.timeAxisModel);
        return mouseRenderer;
    }

    private TableLayout resetContainer() {
        TableLayout tableLayout = new TableLayout();
        tableLayout.insertColumn(0, -3.0);
        tableLayout.insertColumn(1, -1.0);
        this.container = new JPanel();
        this.container.setLayout((LayoutManager)tableLayout);
        return tableLayout;
    }

    public void loadSiteModelsOverview() {
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
            if (siteModel.getSiteRole() != Site.SiteRole.CENTER) continue;
            if (this.isZoomPanel()) {
                this.sitemodels.add(siteModel.getChild());
                continue;
            }
            this.sitemodels.add(siteModel);
        }
    }

    public boolean loadSiteModelsStation(int n, boolean bl) {
        SNS sNS = this.sk.getAllActiveSNS()[n];
        for (Site site : sNS.getAllSites()) {
            if (site == null) continue;
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
                if (!siteModel.getId().equals(site.getId()) || !bl && siteModel.getSiteRole() != Site.SiteRole.CENTER) continue;
                if (this.isZoomPanel()) {
                    this.sitemodels.add(siteModel.getChild());
                    continue;
                }
                this.sitemodels.add(siteModel);
            }
        }
        return sNS.getAllSatellites().size() > 0;
    }

    private void createPlotsNetworkMode(List<SeisRow> list, MouseRenderer mouseRenderer, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        for (SiteModel siteModel : this.sitemodels) {
            AbstractRenderer abstractRenderer;
            String string = siteModel.getTraceZ();
            if (string == null || (bl || !bl3) && siteModel.getSiteRole() == Site.SiteRole.SATELLITE) continue;
            if (!this.check3c(siteModel)) {
                abstractRenderer = new TraceRenderer(siteModel, mouseRenderer, this, this.markerModel, this.CHILDS, this.CHILDE, this.parent);
                list.add(new SeisRow(new LabelPanel(string, siteModel, this, true), abstractRenderer));
                continue;
            }
            abstractRenderer = new ThreeCompRenderer(siteModel, mouseRenderer, this, this.markerModel, this.CHILDS, this.CHILDE, this.parent, bl4);
            list.add(new SeisRow(new LabelPanel(abstractRenderer.getModel().getTraceZ(), siteModel, this, !bl5), ((ThreeCompRenderer)abstractRenderer).getTraceZ()));
            if (!bl5) continue;
            if (((ThreeCompRenderer)abstractRenderer).getTraceEW() != null) {
                list.add(new SeisRow(new LabelPanel(abstractRenderer.getModel().getTraceEW(), siteModel, this, true), ((ThreeCompRenderer)abstractRenderer).getTraceEW()));
            }
            if (((ThreeCompRenderer)abstractRenderer).getTraceNS() == null) continue;
            list.add(new SeisRow(new LabelPanel(abstractRenderer.getModel().getTraceNS(), siteModel, this, false), ((ThreeCompRenderer)abstractRenderer).getTraceNS()));
        }
    }

    private void createPlotsArrayMode(List<SeisRow> list, MouseRenderer mouseRenderer, boolean bl) {
        TraceRenderer traceRenderer;
        Object object;
        for (SiteModel siteModel : this.sitemodels) {
            object = siteModel.getTraceZ();
            if (object == null) continue;
            boolean bl2 = bl && siteModel.getSiteRole() == Site.SiteRole.CENTER;
            traceRenderer = new TraceRenderer(siteModel, mouseRenderer, this, this.markerModel, this.CHILDS, this.CHILDE, this.parent, TraceRenderer.TraceType.TRACE_Z, bl2);
            list.add(new SeisRow(new LabelPanel((String)object, siteModel, this, true), traceRenderer));
        }
        if (this.config.getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY) && this.isZoomPanel()) {
            SiteModel siteModel;
            HypoLineManager.INSTANCE.getpBeamView().init();
            HypoLineManager.INSTANCE.getsBeamView().init();
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.sitemodels);
            siteModel = new SiteModel();
            object = new ArrayModeTraceRenderer(siteModel, mouseRenderer, (ActivateableComponent)this, this.markerModel, this.CHILDS, this.CHILDE, this.parent, arrayList, true);
            this.sitemodels.add(siteModel);
            list.add(new SeisRow(new LabelPanel("P", siteModel, this, true), (AbstractRenderer)((Object)object)));
            SiteModel siteModel2 = new SiteModel();
            traceRenderer = new ArrayModeTraceRenderer(siteModel2, mouseRenderer, (ActivateableComponent)this, this.markerModel, this.CHILDS, this.CHILDE, this.parent, arrayList, false);
            this.sitemodels.add(siteModel2);
            list.add(new SeisRow(new LabelPanel("S", siteModel2, this, true), traceRenderer));
        }
    }

    private void createPlotsMagnitudeMode(List<SeisRow> list, MouseRenderer mouseRenderer, boolean bl) {
        for (SiteModel siteModel : this.sitemodels) {
            String string = siteModel.getTraceZ();
            if (string == null || !this.check3c(siteModel)) continue;
            ThreeCompRenderer threeCompRenderer = new ThreeCompRenderer(siteModel, mouseRenderer, this, this.markerModel, this.CHILDS, this.CHILDE, this.parent, true);
            if (!bl) {
                list.add(new SeisRow(new LabelPanel(string, siteModel, this, false), threeCompRenderer.getTraceZ()));
                if (threeCompRenderer != null && this.isZoomPanel()) {
                    list.add(new SeisRow(new LabelPanel(siteModel.getTraceEW(), siteModel, this, TraceRenderer.TraceType.TRACE_EW, true), threeCompRenderer.getTraceEW()));
                }
                if (threeCompRenderer == null || !this.isZoomPanel()) continue;
                list.add(new SeisRow(new LabelPanel(siteModel.getTraceNS(), siteModel, this, TraceRenderer.TraceType.TRACE_NS, false), threeCompRenderer.getTraceNS()));
                continue;
            }
            list.add(new SeisRow(new LabelPanel(siteModel.getId(), siteModel, this, true), threeCompRenderer.getTraceZ()));
        }
    }

    private boolean isZoomPanel() {
        return this.parent != null;
    }

    private boolean check3c(Site site) {
        return site.getTraceEW() != null && !site.getTraceEW().isEmpty() && site.getTraceNS() != null && !site.getTraceNS().isEmpty();
    }

    public void update() {
        Object object;
        int n;
        boolean bl;
        this.clearPlots();
        MouseRenderer mouseRenderer = this.createMouseRenderer();
        TableLayout tableLayout = this.resetContainer();
        boolean bl2 = false;
        boolean bl3 = this.config.isShowSatellite() || this.config.getHypoLineMode() == HypoLineConfiguration.HypoLineMode.ARRAY;
        boolean bl4 = !this.config.isExpand3Comp();
        int n2 = this.config.getActiveSNS();
        boolean bl5 = n2 < 0;
        boolean bl6 = bl = this.parent != null && !bl5;
        if (bl5) {
            this.loadSiteModelsOverview();
        } else {
            bl2 = this.loadSiteModelsStation(n2, bl3);
        }
        LinkedList<SeisRow> linkedList = new LinkedList<SeisRow>();
        switch (this.config.getHypoLineMode()) {
            case NETWORK: {
                this.createPlotsNetworkMode(linkedList, mouseRenderer, bl5, bl2, bl3, bl4, bl);
                break;
            }
            case ARRAY: {
                this.createPlotsArrayMode(linkedList, mouseRenderer, bl4);
                break;
            }
            case MAGNITUDE: {
                this.createPlotsMagnitudeMode(linkedList, mouseRenderer, bl5);
                break;
            }
            default: {
                LogUtil.error(((Object)((Object)this)).getClass(), (String)("HypolineMode " + this.config.getHypoLineMode().name() + " not implemented."));
            }
        }
        if (linkedList.size() > 0) {
            n = tableLayout.getNumRow();
            for (SeisRow seisRow : linkedList) {
                tableLayout.insertRow(n, -1.0);
                seisRow.renderer.addKeyListener(this.keyListener);
                this.container.add((Component)seisRow.label, "0," + n);
                this.container.add((Component)((Object)seisRow.renderer), "1," + n);
                this.plots.add(seisRow.renderer);
                ++n;
            }
        }
        n = tableLayout.getNumRow();
        tableLayout.insertRow(n, -3.0);
        this.container.add((Component)this.dateLabel, "0, " + n);
        this.container.add((Component)this.timeAxis, "1, " + n);
        ++n;
        if (this.config.isScrollPane()) {
            object = new JScrollPane(this.container, 20, 31);
            ((JComponent)object).setPreferredSize(new Dimension(this._width, this._height));
            ((JScrollPane)object).getVerticalScrollBar().setUnitIncrement(16);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder());
            ((JScrollPane)object).setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)object, "0, 0");
        } else {
            this.add(this.container, "0, 0");
        }
        if (this.isZoomPanel() && n2 < 0) {
            switch (this.config.getHypoLineMode()) {
                case ARRAY: {
                    this.removeAll();
                    this.add(this.getWarningLabel(""), "0, 0");
                }
            }
        }
        if (this.isZoomPanel() && !bl5 && this.config.getHypoLineMode() == HypoLineConfiguration.HypoLineMode.ARRAY && this.sk.getAllActiveSNS()[n2].getAllSatellites().isEmpty()) {
            this.removeAll();
            this.add(this.getWarningLabel(this.sk.getAllActiveSNS()[n2].getID() + " is not an array"), "0, 0");
        }
        if (this.isZoomPanel() && !bl5 && this.config.getHypoLineMode() == HypoLineConfiguration.HypoLineMode.MAGNITUDE) {
            boolean bl7;
            object = this.sk.getAllActiveSNS()[n2].getCenter();
            boolean bl8 = bl7 = object.getTraceEW() != null || object.getTraceNS() != null;
            if (!bl7) {
                this.removeAll();
                this.add(this.getWarningLabel(this.sk.getAllActiveSNS()[n2].getID() + " has no horizontal components"), "0, 0");
            }
        }
        this.revalidate();
    }

    private JLabel getWarningLabel(String string) {
        Font font = new Font("Arial", 1, 20);
        if (string == null || string.isEmpty()) {
            string = "no station selected";
        }
        JLabel jLabel = new JLabel();
        jLabel.setForeground(ThemeManager.getInstance().getTheme().getHypolineRed());
        jLabel.setFont(font);
        jLabel.setText(string);
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }

    public void switchRenderer() {
        this.renderMode = this.renderMode == RenderMode.TRACE ? RenderMode.SONOGRAM : RenderMode.TRACE;
        for (SiteModel siteModel : this.sitemodels) {
            siteModel.setRenderMode(this.renderMode);
        }
    }

    public void updateActiveTrace(SiteModel siteModel) {
        for (SiteModel siteModel2 : this.sitemodels) {
            if (!((Object)((Object)siteModel2)).equals((Object)siteModel)) {
                siteModel2.setActiveTrace(false);
                continue;
            }
            siteModel2.setActiveTrace(true);
        }
    }

    public void markerAdded(RangeDataEvent rangeDataEvent) {
        this.updateModel(rangeDataEvent);
        this.repaint();
    }

    public void markerRemoved(RangeDataEvent rangeDataEvent) {
        this.updateModel(rangeDataEvent);
        this.repaint();
    }

    public void positionChanged(RangeDataEvent rangeDataEvent) {
        this.updateModel(rangeDataEvent);
        this.repaint();
    }

    public void valueChanged(RangeDataEvent rangeDataEvent) {
        this.updateModel(rangeDataEvent);
        this.repaint();
    }

    public void allChanged(RangeDataEvent rangeDataEvent) {
        this.updateModel(rangeDataEvent);
        this.repaint();
    }

    public void updateModel(RangeDataEvent rangeDataEvent) {
        if ((rangeDataEvent.getType().equals("ALL_CHANGED") || rangeDataEvent.getMarker() != null && (rangeDataEvent.getMarker().getID().equals("1a") || rangeDataEvent.getMarker().getID().equals("1b"))) && this.isZoomPanel()) {
            this.start = MathUtil.convertToAbsolute((double)((RangeMarkerModelChild)this.markerModel).getParent().getMarker("1a").getPosition(), (double)this.parent.getStart(), (double)(this.parent.getStart() + this.parent.getLength()));
            this.length = MathUtil.convertToAbsolute((double)((RangeMarkerModelChild)this.markerModel).getParent().getMarker("1b").getPosition(), (double)this.parent.getStart(), (double)(this.parent.getStart() + this.parent.getLength())) - this.start;
            this.updateModel(true);
        }
    }

    private void zoomInIncremental(boolean bl) {
        double d = this.markerModel.getMarker("1a").getPosition();
        double d2 = this.markerModel.getMarker("1b").getPosition();
        double d3 = d2 - d;
        if (bl) {
            double d4 = 0.5 * d3;
            if (d4 < 0.00625) {
                return;
            }
            this.markerModel.moveMarker(0.5 * d4, new String[]{"1a"});
            this.markerModel.moveMarker(-0.5 * d4, new String[]{"1b"});
        } else {
            double d5 = 0.95;
            if (d3 >= d5) {
                return;
            }
            double d6 = Math.min(2.0 * d3, d5);
            double d7 = -0.25 * d6;
            double d8 = 0.25 * d6;
            if (d + d7 < 0.025) {
                d7 = -(d - 0.025);
                d8 = 0.025 + d6 - d2;
            } else if (d2 + d8 > 0.975) {
                d8 = 0.975 - d2;
                d7 = 0.975 - d6 - d;
            }
            this.markerModel.moveMarker(d7, new String[]{"1a"});
            this.markerModel.moveMarker(d8, new String[]{"1b"});
        }
    }

    public void updateModel(boolean bl) {
        this.timeAxisModel.setMinimum((long)(this.start * 1000.0));
        this.timeAxisModel.setMaximum((long)((this.start + this.length) * 1000.0));
        this.dateLabel.setText(DateTimeUtil.formatDateISO((double)this.start));
        this.timeAxis.repaint();
        for (SiteModel object : this.sitemodels) {
            if (bl || HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
                object.update(this.start, this.length, this.renderMode);
                LogUtil.debug(((Object)((Object)this)).getClass(), (String)("inner child update: " + ++this.innerCounter));
                continue;
            }
            object.updateRepaint();
        }
        if (HypoLineManager.INSTANCE.getConfig().isCommonScaling()) {
            float f = -3.4028235E38f;
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesOverview()) {
                if (!(siteModel.getCurrentMaxValue() > f)) continue;
                f = siteModel.getCurrentMaxValue();
            }
            for (SiteModel siteModel : this.sitemodels) {
                siteModel.setCurrentMaxValue(f);
                siteModel.updateRepaint();
            }
        }
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode().equals((Object)HypoLineConfiguration.HypoLineMode.ARRAY)) {
            HypoLineManager.INSTANCE.getpBeamView().update();
            HypoLineManager.INSTANCE.getsBeamView().update();
        }
    }

    public RangeMarkerModel<Object> getMarkerModel() {
        return this.markerModel;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double d) {
        this.start = d;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double d) {
        this.length = d;
    }

    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    public static enum RenderMode {
        TRACE,
        SONOGRAM,
        TRACE_SONO;

    }

    private class SeisRow {
        public LabelPanel label = null;
        public AbstractRenderer renderer = null;

        public SeisRow(LabelPanel labelPanel, AbstractRenderer abstractRenderer) {
            this.label = labelPanel;
            this.renderer = abstractRenderer;
        }
    }
}

