/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import edu.geophys.hypoline.ui.vertical.LayerModelChooser;
import edu.geophys.hypoline.ui.vertical.LayerModelEditor;
import edu.geophys.hypoline.ui.vertical.VelocitySection;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LayerModelEditorFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final LayerModelChooser lmc;
    private final LayerModelEditor lme;
    private final VelocitySection vs;

    public LayerModelEditorFrame() {
        super("Layer Model Editor");
        this.setDefaultCloseOperation(1);
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(new Dimension(800, 600));
        this.lmc = new LayerModelChooser();
        this.lme = new LayerModelEditor();
        this.vs = new VelocitySection();
        this.initComponents();
        this.pack();
    }

    public void updateLayerModel() {
        this.vs.repaint();
        this.lmc.updateLayerModel();
        this.lme.updateLayerModel();
    }

    private void initComponents() {
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        this.getContentPane().add(jPanel);
        jPanel.setLayout(new LMELayout());
        jPanel.add(this.lmc);
        jPanel.add(this.lme);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add((Component)((Object)this.vs));
        jPanel.add(jPanel2);
    }

    private class LMELayout
    implements LayoutManager {
        private static final int HALF_MARGIN = 3;
        private static final int MIN_WIDTH = 600;
        private static final int MIN_HEIGHT = 300;

        private LMELayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = new Dimension(0, 0);
            dimension.width = 600 - (insets.left + insets.right);
            dimension.height = 300 - (insets.top + insets.bottom);
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = new Dimension(0, 0);
            dimension.width = 600 - (insets.left + insets.right);
            dimension.height = 300 - (insets.top + insets.bottom);
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = container.getSize().width - (insets.left + insets.right);
            int n3 = container.getSize().height - (insets.top + insets.bottom);
            int n4 = insets.top;
            int n5 = insets.left;
            int n6 = n3 / 2;
            int n7 = 2 * n3 / 5;
            int n8 = n3 - n7;
            int n9 = n2 - n6;
            for (int i = 0; i < n; ++i) {
                int n10;
                int n11;
                int n12;
                Component component = container.getComponent(i);
                int n13 = switch (i) {
                    case 0 -> {
                        n12 = n5;
                        n11 = n4;
                        n10 = n9 - 3;
                        yield n7 - 3;
                    }
                    case 1 -> {
                        n12 = n5;
                        n11 = n4 + n7 + 3;
                        n10 = n9 - 3;
                        yield n8 - 3;
                    }
                    case 2 -> {
                        n12 = n5 + n9 + 3;
                        n11 = n4;
                        n10 = n6 - 3;
                        yield n3;
                    }
                    default -> throw new IllegalStateException("layout manager does only handle 3 components");
                };
                if (!component.isVisible()) continue;
                component.setBounds(n12, n11, n10, n13);
            }
        }
    }
}

