/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.model.layer.LayerModel;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ui.vertical.LayerModelController;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

public class LayerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"thickness [km]", "vp [km/s]", "Pg", "Pn", "", ""};
    private final Class[] columnClass = new Class[]{Double.class, Double.class, Boolean.class, Boolean.class, JButton.class, JButton.class};

    @Override
    public Class<?> getColumnClass(int n) {
        return this.columnClass[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel().getLayers().size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Layer layer = (Layer)HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel().getLayers().get(n);
        switch (n2) {
            case 0: {
                return layer.getD();
            }
            case 1: {
                return layer.getVp();
            }
            case 2: {
                return layer.getWavetype() == Layer.WaveType.Pg;
            }
            case 3: {
                return layer.getWavetype() == Layer.WaveType.Pn;
            }
            case 4: {
                return "+";
            }
            case 5: {
                return "-";
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        LayerModel layerModel = HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel();
        Layer layer = (Layer)layerModel.getLayers().get(n);
        double d = 0.0;
        boolean bl = false;
        switch (n2) {
            case 0: {
                d = (Double)object;
                if (LayerModelController.doubleEqual(d, layer.getD())) {
                    return;
                }
                layer.setD(d);
                break;
            }
            case 1: {
                d = (Double)object;
                if (LayerModelController.doubleEqual(d, layer.getVp())) {
                    return;
                }
                layer.setVp(d);
                break;
            }
            case 2: {
                bl = layerModel.switchWavetypeToLayer(Layer.WaveType.Pg, n);
                if (bl) break;
                return;
            }
            case 3: {
                bl = layerModel.switchWavetypeToLayer(Layer.WaveType.Pn, n);
                if (bl) break;
                return;
            }
            default: {
                return;
            }
        }
        HypoLineManager.INSTANCE.getLayerModelController().onModification();
    }
}

