/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.vertical;

import edu.geophys.hypoline.ui.vertical.DepthSection;
import edu.geophys.hypoline.ui.vertical.LayerModelEditor;
import edu.geophys.hypoline.ui.vertical.VelocitySection;
import edu.geophys.hypoline.ui.vertical.VerticalOverviewLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class VerticalOverview
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JFrame frame = null;
    private final JComponent[] components = new JComponent[4];

    public VerticalOverview() {
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new VerticalOverviewLayout());
        JButton jButton = new JButton("Map Placeholder");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VerticalOverview.this.repaint();
            }
        });
        this.components[0] = this.loadTabbedPane();
        this.components[1] = jButton;
        this.components[2] = new DepthSection();
        this.components[3] = new VelocitySection();
        for (JComponent jComponent : this.components) {
            this.add(jComponent);
        }
    }

    public JComponent loadTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Layers", new LayerModelEditor());
        jTabbedPane.add("Topography", new JLabel("Geotiff loader placeholder"));
        return jTabbedPane;
    }

    public JFrame asFrame() {
        if (this.frame != null) {
            return this.frame;
        }
        this.frame = new JFrame("TopographyOverview");
        this.frame.setDefaultCloseOperation(2);
        this.frame.setMinimumSize(new Dimension(800, 600));
        this.frame.setPreferredSize(new Dimension(800, 600));
        this.frame.setLayout(new BoxLayout(this.frame.getContentPane(), 0));
        this.frame.getContentPane().add(this);
        this.frame.pack();
        return this.frame;
    }
}

