/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.util;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.headerfiles.HeaderDatabase;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.SingleTracePaint;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.JFrameHelper;
import edu.geophys.commons.util.LoadHeaderUtil;
import edu.geophys.commons.util.MathUtil;
import java.io.File;
import java.text.ParseException;
import javax.swing.JComponent;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class HilbertTransform {
    public static float[] getEnvelope(float[] fArray) {
        int n;
        int n2 = MathUtil.getNextPowerOfTwo((int)fArray.length);
        double[] dArray = new double[n2];
        for (int i = 0; i < fArray.length; ++i) {
            dArray[i] = fArray[i];
        }
        FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.UNITARY);
        Complex[] complexArray = fastFourierTransformer.transform(dArray, TransformType.FORWARD);
        int[] nArray = new int[n2];
        if (n2 % 2 == 0) {
            nArray[n2 / 2] = 1;
            nArray[0] = 1;
            for (n = 1; n < n2 / 2; ++n) {
                nArray[n] = 2;
            }
        } else {
            nArray[0] = 1;
            for (n = 1; n < (n2 + 1) / 2; ++n) {
                nArray[n] = 2;
            }
        }
        for (n = 0; n < n2; ++n) {
            complexArray[n] = complexArray[n].multiply(nArray[n]);
        }
        Complex[] complexArray2 = fastFourierTransformer.transform(complexArray, TransformType.INVERSE);
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = (float)complexArray2[i].abs();
        }
        return fArray2;
    }

    public static void main(String[] stringArray) throws ParseException {
        HeaderDatabase headerDatabase = LoadHeaderUtil.loadHeader((File)new File("/home/sick/geophys/knowbases/Heumoeser_Hang/Felssturz/header.sht"));
        double d = (double)DateTimeUtil.parseDateTime((String)"2011/05/10 14:03:46.500").getTimeInMillis() / 1000.0;
        double d2 = (double)DateTimeUtil.parseDateTime((String)"2011/05/10 14:03:47.500").getTimeInMillis() / 1000.0;
        SNS sNS = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllSNS()[1];
        Site site = sNS.getCenter();
        System.out.println(site.getTraceZ());
        DefaultTrace defaultTrace = headerDatabase.getTrace(site.getTraceZ(), d, d2, SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate());
        float f = defaultTrace.getSamplerate();
        float f2 = f / 2.0f;
        float[] fArray = defaultTrace.getSamples();
        int n = MathUtil.getNextPowerOfTwo((int)fArray.length);
        double[] dArray = new double[n];
        double d3 = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            dArray[i] = fArray[i];
            d3 += dArray[i] * dArray[i];
        }
        FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.UNITARY);
        Complex[] complexArray = fastFourierTransformer.transform(dArray, TransformType.FORWARD);
        int[] nArray = new int[n];
        if (n % 2 == 0) {
            nArray[n / 2] = 1;
            nArray[0] = 1;
            for (var19_17 = 1; var19_17 < n / 2; ++var19_17) {
                nArray[var19_17] = 2;
            }
        } else {
            nArray[0] = 1;
            for (var19_17 = 1; var19_17 < (n + 1) / 2; ++var19_17) {
                nArray[var19_17] = 2;
            }
        }
        double d4 = 0.0;
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = complexArray[i].abs();
            d4 += dArray2[i] * dArray2[i];
            complexArray[i] = complexArray[i].multiply(nArray[i]);
        }
        System.out.println(d3 + "\t" + d4 + "\t" + (d3 - d4) + "\t" + d3 / d4);
        Complex[] complexArray2 = fastFourierTransformer.transform(complexArray, TransformType.INVERSE);
        float[] fArray2 = new float[fArray.length];
        float[] fArray3 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = (float)complexArray2[i].getReal();
            fArray3[i] = (float)complexArray2[i].abs();
        }
        System.out.println();
        JFrameHelper.showInFrame((boolean)false, (JComponent[])new JComponent[]{new SingleTracePaint(fArray), new SingleTracePaint(fArray2), new SingleTracePaint(fArray3), new SingleTracePaint(HilbertTransform.getEnvelope(fArray))});
    }
}

