/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.util;

import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.ui.trace.SiteModel;

public class HypoLineUtils {
    public static long convertPickToTime(int n, double d, float f) {
        return (long)(((double)n / (double)f + d) * 1000.0);
    }

    public static int convertTimeToPick(long l, double d, float f) {
        return (int)(((double)l / 1000.0 - d) * (double)f);
    }

    public static int convertTimeToPick(double d, double d2, float f) {
        return (int)((d - d2) * (double)f);
    }

    public static float changeValueLog(float f, boolean bl) {
        if (f <= 0.0f && bl) {
            return 0.1f;
        }
        int n = (int)Math.floor(Math.log10(f));
        float f2 = (float)Math.pow(10.0, n);
        float f3 = n >= -1 ? (float)Math.pow(10.0, n - 1) : (float)Math.pow(10.0, -2.0);
        float f4 = bl ? (float)((int)Math.ceil((f + f2) / f2)) * f2 : (float)((int)Math.floor((f - f3) / f3)) * f3;
        return f4;
    }

    public static float changeValue(float f, boolean bl) {
        float f2 = bl ? (float)((double)f + 0.1) : (float)((double)f - 0.1);
        return f2;
    }

    public static double evalBeamToEpicenter(double d, double d2, SiteModel siteModel, float f) {
        double d3 = siteModel.getXOffsetKm();
        double d4 = siteModel.getYOffsetKm();
        double d5 = siteModel.getpBeamAngle();
        double d6 = Math.toDegrees(Math.atan2(d2 - d4, d - d3));
        if ((d6 = 90.0 - d6) < 0.0) {
            d6 += 360.0;
        }
        double d7 = MathUtil.compareAngles((double)d5, (double)d6);
        double d8 = d7 / 180.0;
        return d8;
    }
}

