/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.loader;

import edu.geophys.loader.LibraryClassLoader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.InvalidKeyException;
import java.util.Properties;

final class ApplicationStarter {
    private static final String DEFAULT_PROPERTIES_FILE = "./loader.properties";
    private static final String PROPERTIE_KEY_LIBDIR = "LIBDIR";
    private static final String PROPERTIE_KEY_MAINCLASS = "MAINCLASS";
    private final String _libDir;
    private final String _mainClass;
    private final String _workingDirectory;

    public static void main(String[] stringArray) {
        new ApplicationStarter().start(stringArray);
    }

    public ApplicationStarter() {
        Properties properties = new Properties();
        this._workingDirectory = System.getProperty("appdir");
        try {
            properties.load(new FileReader(DEFAULT_PROPERTIES_FILE));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._libDir = properties.getProperty(PROPERTIE_KEY_LIBDIR, null);
        this._mainClass = properties.getProperty(PROPERTIE_KEY_MAINCLASS, null);
        if (this._libDir == null || this._mainClass == null) {
            new InvalidKeyException("Invalid configuration file content").printStackTrace();
            System.exit(1);
        }
    }

    private void start(String[] stringArray) {
        try {
            ClassLoader classLoader = this.findParentClassLoader();
            File file = null;
            file = this._workingDirectory == null ? new File(this._libDir) : new File(new File(this._workingDirectory), "lib");
            LibraryClassLoader libraryClassLoader = new LibraryClassLoader(classLoader, file);
            Thread.currentThread().setContextClassLoader(libraryClassLoader);
            Class<?> clazz = libraryClassLoader.loadClass(this._mainClass);
            if (clazz == null) {
                throw new NoClassDefFoundError(String.format("class %s not found", this._mainClass));
            }
            Method method = clazz.getMethod("main", String[].class);
            if (method == null) {
                throw new NoSuchMethodException(String.format("no public static final void main() method in class %s not found", this._mainClass));
            }
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) {
                throw new NoSuchMethodException(String.format("no public static final void main() method in class %s not found", this._mainClass));
            }
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ClassLoader findParentClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null && (classLoader = this.getClass().getClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

