/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.CommentEmitter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class FunctionEmitter {
    public static final EmissionModifier STATIC = new EmissionModifier("static");
    private boolean isInterfaceVal;
    private ArrayList<EmissionModifier> modifiers = new ArrayList();
    private CommentEmitter commentEmitter = null;
    private PrintWriter defaultOutput;

    public FunctionEmitter(PrintWriter printWriter, boolean bl) {
        assert (printWriter != null);
        this.defaultOutput = printWriter;
        this.isInterfaceVal = bl;
    }

    public FunctionEmitter(FunctionEmitter functionEmitter) {
        this.modifiers = (ArrayList)functionEmitter.modifiers.clone();
        this.commentEmitter = functionEmitter.commentEmitter;
        this.defaultOutput = functionEmitter.defaultOutput;
        this.isInterfaceVal = functionEmitter.isInterfaceVal;
    }

    public boolean isInterface() {
        return this.isInterfaceVal;
    }

    public PrintWriter getDefaultOutput() {
        return this.defaultOutput;
    }

    public void addModifiers(Iterator<EmissionModifier> iterator) {
        while (iterator.hasNext()) {
            this.modifiers.add(iterator.next());
        }
    }

    public void addModifier(EmissionModifier emissionModifier) {
        this.modifiers.add(emissionModifier);
    }

    public boolean removeModifier(EmissionModifier emissionModifier) {
        return this.modifiers.remove(emissionModifier);
    }

    public void clearModifiers() {
        this.modifiers.clear();
    }

    public boolean hasModifier(EmissionModifier emissionModifier) {
        return this.modifiers.contains(emissionModifier);
    }

    public Iterator<EmissionModifier> getModifiers() {
        return this.modifiers.iterator();
    }

    public abstract String getName();

    public void emit(PrintWriter printWriter) {
        this.emitDocComment(printWriter);
        this.emitSignature(printWriter);
        this.emitBody(printWriter);
    }

    public final void emit() {
        this.emit(this.getDefaultOutput());
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter(500);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.emit(printWriter);
        return stringWriter.toString();
    }

    public void setCommentEmitter(CommentEmitter commentEmitter) {
        this.commentEmitter = commentEmitter;
    }

    public CommentEmitter getCommentEmitter() {
        return this.commentEmitter;
    }

    protected void emitDocComment(PrintWriter printWriter) {
        if (this.commentEmitter != null) {
            printWriter.print(this.getBaseIndentString());
            printWriter.print(this.getCommentStartString());
            this.commentEmitter.emit(this, printWriter);
            printWriter.print(this.getBaseIndentString());
            printWriter.println(this.getCommentEndString());
        }
    }

    protected void emitSignature(PrintWriter printWriter) {
        printWriter.print(this.getBaseIndentString());
        int n = this.emitModifiers(printWriter);
        if (n > 0) {
            printWriter.print(" ");
        }
        this.emitReturnType(printWriter);
        printWriter.print(" ");
        this.emitName(printWriter);
        printWriter.print("(");
        this.emitArguments(printWriter);
        printWriter.print(")");
    }

    protected int emitModifiers(PrintWriter printWriter) {
        PrintWriter printWriter2 = this.getDefaultOutput();
        int n = 0;
        Iterator<EmissionModifier> iterator = this.getModifiers();
        while (iterator.hasNext()) {
            printWriter.print(iterator.next());
            ++n;
            if (!iterator.hasNext()) continue;
            printWriter.print(" ");
        }
        return n;
    }

    protected String getBaseIndentString() {
        return "";
    }

    protected String getCommentStartString() {
        return "/* ";
    }

    protected String getCommentEndString() {
        return " */";
    }

    protected abstract void emitReturnType(PrintWriter var1);

    protected abstract void emitName(PrintWriter var1);

    protected abstract int emitArguments(PrintWriter var1);

    protected abstract void emitBody(PrintWriter var1);

    public static class EmissionModifier {
        private String emittedForm;

        public final String toString() {
            return this.emittedForm;
        }

        public int hashCode() {
            return this.emittedForm.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof EmissionModifier)) {
                return false;
            }
            return this.emittedForm.equals(((EmissionModifier)object).emittedForm);
        }

        protected EmissionModifier(String string) {
            this.emittedForm = string;
        }
    }
}

