/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.PaintEvent;
import java.beans.Beans;
import java.lang.reflect.Constructor;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ProxyActions;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProxyActions(value={"cut", "copy", "paste", "delete"})
public abstract class Application
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    private static Application application = null;
    private final List<ExitListener> exitListeners = new CopyOnWriteArrayList<ExitListener>();
    private final ApplicationContext context = new ApplicationContext();

    protected Application() {
    }

    public static synchronized <T extends Application> void launch(final Class<T> applicationClass, final String[] args) {
        Runnable doCreateAndShowGUI = new Runnable(){

            public void run() {
                try {
                    application = (Application)Application.create(applicationClass);
                    application.initialize(args);
                    application.startup();
                    application.waitForReady();
                }
                catch (Exception e) {
                    String msg = String.format("Application %s failed to launch", applicationClass);
                    logger.log(Level.SEVERE, msg, e);
                    throw new Error(msg, e);
                }
            }
        };
        SwingUtilities.invokeLater(doCreateAndShowGUI);
    }

    static <T extends Application> T create(Class<T> applicationClass) throws Exception {
        Constructor<T> ctor;
        if (!Beans.isDesignTime()) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (SecurityException ignoreException) {
                // empty catch block
            }
        }
        if (!(ctor = applicationClass.getDeclaredConstructor(new Class[0])).isAccessible()) {
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
        }
        Application application = (Application)ctor.newInstance(new Object[0]);
        ApplicationContext ctx = application.getContext();
        ctx.setApplicationClass(applicationClass);
        ctx.setApplication(application);
        ResourceMap appResourceMap = ctx.getResourceMap();
        appResourceMap.putResource("platform", Application.platform());
        if (!Beans.isDesignTime()) {
            String key = "Application.lookAndFeel";
            String lnfResource = appResourceMap.getString(key, new Object[0]);
            String lnf = lnfResource == null ? "system" : lnfResource;
            try {
                if (lnf.equalsIgnoreCase("system")) {
                    String name = UIManager.getSystemLookAndFeelClassName();
                    UIManager.setLookAndFeel(name);
                } else if (!lnf.equalsIgnoreCase("default")) {
                    UIManager.setLookAndFeel(lnf);
                }
            }
            catch (Exception e) {
                String s = "Couldn't set LookandFeel " + key + " = \"" + lnfResource + "\"";
                logger.log(Level.WARNING, s, e);
            }
        }
        return (T)application;
    }

    private static String platform() {
        String platform = "default";
        try {
            String osName = System.getProperty("os.name");
            if (osName != null && osName.toLowerCase().startsWith("mac os x")) {
                platform = "osx";
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return platform;
    }

    void waitForReady() {
        new DoWaitForEmptyEventQ().execute();
    }

    protected void initialize(String[] args) {
    }

    protected abstract void startup();

    protected void ready() {
    }

    protected void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEmptyEventQ() {
        boolean qEmpty = false;
        JPanel placeHolder = new JPanel();
        EventQueue q = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (!qEmpty) {
            NotifyingEvent e = new NotifyingEvent(placeHolder);
            q.postEvent(e);
            NotifyingEvent notifyingEvent = e;
            synchronized (notifyingEvent) {
                while (!e.isDispatched()) {
                    try {
                        e.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                qEmpty = e.isEventQEmpty();
            }
        }
    }

    public final void exit() {
        this.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(EventObject event) {
        for (ExitListener listener : this.exitListeners) {
            if (listener.canExit(event)) continue;
            return;
        }
        try {
            for (ExitListener listener : this.exitListeners) {
                try {
                    listener.willExit(event);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ExitListener.willExit() failed", e);
                }
            }
            this.shutdown();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "unexpected error in Application.shutdown()", e);
        }
        finally {
            this.end();
        }
    }

    protected void end() {
        Runtime.getRuntime().exit(0);
    }

    public void addExitListener(ExitListener listener) {
        this.exitListeners.add(listener);
    }

    public void removeExitListener(ExitListener listener) {
        this.exitListeners.remove(listener);
    }

    public ExitListener[] getExitListeners() {
        int size = this.exitListeners.size();
        return this.exitListeners.toArray(new ExitListener[size]);
    }

    @Action
    public void quit(ActionEvent e) {
        this.exit(e);
    }

    public final ApplicationContext getContext() {
        return this.context;
    }

    public static synchronized <T extends Application> T getInstance(Class<T> applicationClass) {
        if (application == null) {
            try {
                application = Application.create(applicationClass);
            }
            catch (Exception e) {
                String msg = String.format("Couldn't construct %s", applicationClass);
                throw new Error(msg, e);
            }
        }
        return (T)((Application)applicationClass.cast(application));
    }

    public static synchronized Application getInstance() {
        if (application == null) {
            application = new NoApplication();
        }
        return application;
    }

    public void show(View view) {
        Window window = (Window)view.getRootPane().getParent();
        if (window != null) {
            window.pack();
            window.setVisible(true);
        }
    }

    public void hide(View view) {
        view.getRootPane().getParent().setVisible(false);
    }

    private static class NoApplication
    extends Application {
        protected NoApplication() {
            ApplicationContext ctx = this.getContext();
            ctx.setApplicationClass(this.getClass());
            ctx.setApplication(this);
            ResourceMap appResourceMap = ctx.getResourceMap();
            appResourceMap.putResource("platform", Application.platform());
        }

        protected void startup() {
        }
    }

    public static interface ExitListener
    extends EventListener {
        public boolean canExit(EventObject var1);

        public void willExit(EventObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoWaitForEmptyEventQ
    extends Task<Void, Void> {
        DoWaitForEmptyEventQ() {
            super(Application.this);
        }

        protected Void doInBackground() {
            Application.this.waitForEmptyEventQ();
            return null;
        }

        @Override
        protected void finished() {
            Application.this.ready();
        }
    }

    private static class NotifyingEvent
    extends PaintEvent
    implements ActiveEvent {
        private boolean dispatched = false;
        private boolean qEmpty = false;

        NotifyingEvent(Component c) {
            super(c, 801, null);
        }

        synchronized boolean isDispatched() {
            return this.dispatched;
        }

        synchronized boolean isEventQEmpty() {
            return this.qEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            EventQueue q = Toolkit.getDefaultToolkit().getSystemEventQueue();
            NotifyingEvent notifyingEvent = this;
            synchronized (notifyingEvent) {
                this.qEmpty = q.peekEvent() == null;
                this.dispatched = true;
                this.notifyAll();
            }
        }
    }
}

