/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.HashMap;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoKeyEntry;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffConstants;
import org.geotools.coverage.grid.io.imageio.geotiff.PixelScale;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.resources.i18n.Errors;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GeoTiffIIOMetadataDecoder {
    private final IIOMetadata iioMetadata;
    private final HashMap<Integer, GeoKeyEntry> geoKeys;
    private int geoKeyDirVersion;
    private int geoKeyRevision;
    private int geoKeyMinorRevision;
    private int geoKeyDirTagsNum;
    private final PixelScale pixelScale;
    private final TiePoint[] tiePoints;
    private final double noData;
    private final AffineTransform modelTransformation;

    public GeoTiffIIOMetadataDecoder(IIOMetadata imageMetadata) {
        if (imageMetadata == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"imageMetadata"));
        }
        this.iioMetadata = imageMetadata;
        IIOMetadataNode rootNode = this.getRootNode();
        if (rootNode == null) {
            throw new NullPointerException("Unable to retrieve metadata");
        }
        IIOMetadataNode geoKeyDir = this.getTiffField(rootNode, 34735);
        this.geoKeys = new HashMap();
        if (geoKeyDir != null) {
            NodeList geoKeyDirEntries = geoKeyDir.getFirstChild().getChildNodes();
            for (int i = 4; i < geoKeyDirEntries.getLength(); i += 4) {
                int keyID = this.getIntValueAttribute(geoKeyDirEntries.item(i));
                GeoKeyEntry key = new GeoKeyEntry(keyID, this.getIntValueAttribute(geoKeyDirEntries.item(i + 1)), this.getIntValueAttribute(geoKeyDirEntries.item(i + 2)), this.getIntValueAttribute(geoKeyDirEntries.item(i + 3)));
                if (this.geoKeys.containsKey(keyID)) continue;
                this.geoKeys.put(keyID, key);
            }
            this.geoKeyDirVersion = this.getTiffShort(geoKeyDir, 0);
            this.geoKeyRevision = this.getTiffShort(geoKeyDir, 1);
            if (this.geoKeyRevision != 1) {
                this.geoKeyRevision = 1;
            }
            this.geoKeyMinorRevision = this.getTiffShort(geoKeyDir, 2);
            this.geoKeyDirTagsNum = this.getTiffShort(geoKeyDir, 3);
        }
        this.pixelScale = this.calculateModelPixelScales(rootNode);
        this.tiePoints = this.calculateTiePoints(rootNode);
        this.noData = this.calculateNoData(rootNode);
        this.modelTransformation = this.calculateModelTransformation(rootNode);
    }

    public int getGeoKeyDirectoryVersion() {
        return this.geoKeyDirVersion;
    }

    public int getGeoKeyRevision() {
        return this.geoKeyRevision;
    }

    public int getGeoKeyMinorRevision() {
        return this.geoKeyMinorRevision;
    }

    public int getNumGeoKeys() {
        return this.geoKeyDirTagsNum;
    }

    public String getGeoKey(int keyID) {
        GeoKeyEntry rec = this.getGeoKeyRecord(keyID);
        if (rec == null) {
            return null;
        }
        if (rec.getTiffTagLocation() == 0) {
            return String.valueOf(rec.getValueOffset());
        }
        IIOMetadataNode field = this.getTiffField(this.getRootNode(), rec.getTiffTagLocation());
        if (field == null) {
            return null;
        }
        Node sequence = field.getFirstChild();
        if (sequence == null) {
            return null;
        }
        return sequence.getNodeName().equals(GeoTiffConstants.GEOTIFF_ASCIIS_TAG) ? this.getTiffAscii((IIOMetadataNode)sequence, rec.getValueOffset(), rec.getCount()) : this.getValueAttribute(sequence.getChildNodes().item(rec.getValueOffset()));
    }

    public GeoKeyEntry getGeoKeyRecord(int keyID) {
        return this.geoKeys.get(keyID);
    }

    public Collection<GeoKeyEntry> getGeoKeys() {
        return this.geoKeys.values();
    }

    private PixelScale calculateModelPixelScales(Node rootNode) {
        double[] pixScales = this.getTiffDoubles(this.getTiffField(rootNode, 33550));
        if (pixScales == null) {
            return null;
        }
        PixelScale retVal = new PixelScale();
        block5: for (int i = 0; i < pixScales.length; ++i) {
            switch (i) {
                case 0: {
                    retVal.setScaleX(pixScales[i]);
                    continue block5;
                }
                case 1: {
                    retVal.setScaleY(pixScales[i]);
                    continue block5;
                }
                case 2: {
                    retVal.setScaleZ(pixScales[i]);
                }
            }
        }
        return retVal;
    }

    public PixelScale getModelPixelScales() {
        return this.pixelScale;
    }

    public TiePoint[] getModelTiePoints() {
        return this.tiePoints;
    }

    private TiePoint[] calculateTiePoints(Node rootNode) {
        IIOMetadataNode node = this.getTiffField(rootNode, 33922);
        if (node == null) {
            return null;
        }
        double[] tiePoints = this.getTiffDoubles(node);
        if (tiePoints == null || tiePoints.length <= 0) {
            return null;
        }
        int numTiePoints = tiePoints.length / 6;
        TiePoint[] retVal = new TiePoint[numTiePoints];
        int initialIndex = 0;
        for (int i = 0; i < numTiePoints; ++i) {
            initialIndex = i * 6;
            retVal[i] = new TiePoint(tiePoints[initialIndex], tiePoints[initialIndex + 1], tiePoints[initialIndex + 2], tiePoints[initialIndex + 3], tiePoints[initialIndex + 4], tiePoints[initialIndex + 5]);
        }
        return retVal;
    }

    public double getNoData() {
        return this.noData;
    }

    private double calculateNoData(Node rootNode) {
        IIOMetadataNode noDataNode = this.getTiffField(rootNode, 42113);
        if (noDataNode == null) {
            return Double.NaN;
        }
        String noData = this.getTiffAscii(noDataNode);
        if (noData == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(noData);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public boolean hasTiePoints() {
        return this.tiePoints != null && this.tiePoints.length > 0;
    }

    public boolean hasPixelScales() {
        if (this.pixelScale == null) {
            return false;
        }
        double[] values = this.pixelScale.getValues();
        for (int i = 0; i < values.length; ++i) {
            if (!Double.isInfinite(values[i]) && !Double.isNaN(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean hasNoData() {
        return !Double.isNaN(this.noData);
    }

    public AffineTransform getModelTransformation() {
        return this.modelTransformation;
    }

    private AffineTransform calculateModelTransformation(Node rootNode) {
        IIOMetadataNode node = this.getTiffField(rootNode, 34264);
        if (node == null) {
            return null;
        }
        double[] modelTransformation = this.getTiffDoubles(node);
        if (modelTransformation == null) {
            return null;
        }
        AffineTransform transform = null;
        if (modelTransformation.length == 9) {
            transform = new AffineTransform(modelTransformation[0], modelTransformation[4], modelTransformation[1], modelTransformation[5], modelTransformation[6], modelTransformation[7]);
        } else if (modelTransformation.length == 16) {
            transform = new AffineTransform(modelTransformation[0], modelTransformation[4], modelTransformation[1], modelTransformation[5], modelTransformation[3], modelTransformation[7]);
        }
        return transform;
    }

    public boolean hasModelTrasformation() {
        return this.modelTransformation != null;
    }

    private String getValueAttribute(Node node) {
        return node.getAttributes().getNamedItem(GeoTiffConstants.VALUE_ATTRIBUTE).getNodeValue();
    }

    private int getIntValueAttribute(Node node) {
        return Integer.parseInt(this.getValueAttribute(node));
    }

    private IIOMetadataNode getTiffField(Node rootNode, int tag) {
        Node node = rootNode.getFirstChild();
        if (node != null) {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node number = node.getAttributes().getNamedItem(GeoTiffConstants.NUMBER_ATTRIBUTE);
                if (number == null || tag != Integer.parseInt(number.getNodeValue())) continue;
                return (IIOMetadataNode)node;
            }
        }
        return null;
    }

    private int getTiffShort(IIOMetadataNode tiffField, int index) {
        return this.getIntValueAttribute(((IIOMetadataNode)tiffField.getFirstChild()).getElementsByTagName(GeoTiffConstants.GEOTIFF_SHORT_TAG).item(index));
    }

    private double[] getTiffDoubles(IIOMetadataNode tiffField) {
        if (tiffField == null) {
            return null;
        }
        NodeList doubles = ((IIOMetadataNode)tiffField.getFirstChild()).getElementsByTagName(GeoTiffConstants.GEOTIFF_DOUBLE_TAG);
        int length = doubles.getLength();
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Double.parseDouble(this.getValueAttribute(doubles.item(i)));
        }
        return result;
    }

    private String getTiffAscii(IIOMetadataNode tiffField, int start, int length) {
        String valueAttribute = this.getValueAttribute(((IIOMetadataNode)tiffField.getFirstChild()).getElementsByTagName(GeoTiffConstants.GEOTIFF_ASCII_TAG).item(0));
        if (start == -1) {
            start = 0;
        }
        if (length == -1) {
            length = valueAttribute.length() + 1;
        }
        return valueAttribute.substring(start, start + length - 1);
    }

    private String getTiffAscii(IIOMetadataNode tiffField) {
        return this.getTiffAscii(tiffField, -1, -1);
    }

    public IIOMetadataNode getRootNode() {
        return (IIOMetadataNode)this.iioMetadata.getAsTree(this.iioMetadata.getNativeMetadataFormatName());
    }

    public boolean hasGeoKey() {
        return !this.geoKeys.isEmpty();
    }

    public String getAsciiTIFFTag(String tagID) {
        IIOMetadataNode metadataNode;
        if (GeoTiffConstants.isNumeric(tagID) && (metadataNode = this.getTiffField(this.getRootNode(), Integer.valueOf(tagID))) != null) {
            return this.getTiffAscii(metadataNode);
        }
        return null;
    }
}

