/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.image.crop.GTCropDescriptor;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.resources.coverage.IntersectUtils;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Crop
extends Operation2D {
    private static final long serialVersionUID = 4466072819239413456L;
    public static final double EPS = 0.001;
    private static final GeometryFactory GFACTORY;
    public static final String PARAMNAME_ENVELOPE = "Envelope";
    public static final String PARAMNAME_ROI = "ROI";
    public static final String PARAMNAME_ROITOLERANCE = "ROITolerance";
    public static final ParameterDescriptor<Envelope> CROP_ENVELOPE;
    public static final ParameterDescriptor<Geometry> CROP_ROI;
    public static final ParameterDescriptor<Double> ROI_OPTIMISATION_TOLERANCE;

    public Crop() {
        super((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(Citations.GEOTOOLS, "CoverageCrop", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, CROP_ENVELOPE, CROP_ROI, ROI_OPTIMISATION_TOLERANCE}));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        Geometry jis;
        Geometry cropRoi;
        GeneralEnvelope cropEnvelope = null;
        double roiTolerance = parameters.parameter(PARAMNAME_ROITOLERANCE).doubleValue();
        ParameterValue sourceParameter = parameters.parameter("Source");
        if (sourceParameter == null || !(sourceParameter.getValue() instanceof GridCoverage2D)) {
            throw new CannotCropException(Errors.format((int)146, (Object)"Source", (Object)GridCoverage2D.class.toString()));
        }
        GridCoverage2D source = (GridCoverage2D)((Object)sourceParameter.getValue());
        ParameterValue envelopeParameter = parameters.parameter(PARAMNAME_ENVELOPE);
        ParameterValue roiParameter = parameters.parameter(PARAMNAME_ROI);
        if (!(envelopeParameter != null && envelopeParameter.getValue() != null || roiParameter != null && roiParameter.getValue() != null)) {
            throw new CannotCropException(Errors.format((int)146, (Object)PARAMNAME_ENVELOPE, (Object)GeneralEnvelope.class.toString()));
        }
        Object envelope = envelopeParameter.getValue();
        if (envelope != null) {
            if (envelope instanceof GeneralEnvelope) {
                cropEnvelope = (GeneralEnvelope)envelope;
            } else if (envelope instanceof Envelope) {
                cropEnvelope = new GeneralEnvelope((Envelope)envelope);
            }
        }
        try {
            cropRoi = IntersectUtils.unrollGeometries((Geometry)roiParameter.getValue());
        }
        catch (IllegalArgumentException ex) {
            throw new CannotCropException(Errors.format((int)58, (Object)PARAMNAME_ROI, (Object)ex.getMessage()), ex);
        }
        if (cropRoi != null && cropEnvelope == null) {
            Envelope2D e2d = JTS.getEnvelope2D(cropRoi.getEnvelopeInternal(), source.getCoordinateReferenceSystem());
            cropEnvelope = new GeneralEnvelope((Envelope)e2d);
        }
        Envelope2D sourceEnvelope = source.getEnvelope2D();
        Envelope2D destinationEnvelope = new Envelope2D((Envelope)cropEnvelope);
        CoordinateReferenceSystem sourceCRS = sourceEnvelope.getCoordinateReferenceSystem();
        CoordinateReferenceSystem destinationCRS = destinationEnvelope.getCoordinateReferenceSystem();
        if (destinationCRS == null) {
            Envelope2D ge = new Envelope2D((Envelope)destinationEnvelope);
            destinationCRS = source.getCoordinateReferenceSystem2D();
            ge.setCoordinateReferenceSystem(destinationCRS);
            destinationEnvelope = ge;
        }
        if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)destinationCRS)) {
            throw new CannotCropException(Errors.format((int)95, (Object)sourceCRS.getName().getCode(), (Object)destinationCRS.getName().getCode()));
        }
        if (cropRoi != null) {
            // empty if block
        }
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((Envelope)destinationEnvelope);
        intersectionEnvelope.setCoordinateReferenceSystem(source.getCoordinateReferenceSystem());
        intersectionEnvelope.intersect((Envelope)sourceEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            throw new CannotCropException(Errors.format((int)25));
        }
        if (cropRoi != null && !IntersectUtils.intersects(cropRoi, jis = JTS.shapeToGeometry(intersectionEnvelope.toRectangle2D(), cropRoi.getFactory()))) {
            throw new CannotCropException(Errors.format((int)25));
        }
        AffineTransform sourceCornerGridToWorld = (AffineTransform)source.getGridGeometry().getGridToCRS(PixelInCell.CELL_CORNER);
        double tolerance = XAffineTransform.getScale((AffineTransform)sourceCornerGridToWorld);
        if (cropRoi != null || !intersectionEnvelope.equals((Envelope)sourceEnvelope, tolerance / 2.0, false)) {
            cropEnvelope = intersectionEnvelope.clone();
            return Crop.buildResult(cropEnvelope, cropRoi, roiTolerance, hints instanceof Hints ? hints : new Hints((RenderingHints)hints), source, sourceCornerGridToWorld);
        }
        return source;
    }

    private static GridCoverage2D buildResult(GeneralEnvelope cropEnvelope, Geometry cropROI, double roiTolerance, Hints hints, GridCoverage2D sourceCoverage, AffineTransform sourceGridToWorldTransform) {
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        GridGeometry2D sourceGridGeometry = sourceCoverage.getGridGeometry();
        GridEnvelope2D sourceGridRange = sourceGridGeometry.getGridRange2D();
        boolean isSimpleTransform = CoverageUtilities.isSimpleGridToWorldTransform(sourceGridToWorldTransform, 0.001);
        boolean actionTaken = false;
        RenderingHints targetHints = new RenderingHints(null);
        if (hints != null) {
            targetHints.add((RenderingHints)hints);
        }
        ImageLayout layout = Crop.initLayout(sourceImage, targetHints);
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        JAI processor = OperationJAI.getJAI(targetHints);
        boolean useProvidedProcessor = !processor.equals(JAI.getDefaultInstance());
        try {
            if (cropROI != null) {
                Polygon modelSpaceROI = FeatureUtilities.getPolygon(cropEnvelope, GFACTORY);
                Geometry intersection = IntersectUtils.intersection(cropROI, (Geometry)modelSpaceROI);
                Envelope2D e2d = JTS.getEnvelope2D(intersection.getEnvelopeInternal(), cropEnvelope.getCoordinateReferenceSystem());
                GeneralEnvelope ge = new GeneralEnvelope((Envelope)e2d);
                cropEnvelope.setEnvelope(ge);
            }
            AffineTransform sourceWorldToGridTransform = sourceGridToWorldTransform.createInverse();
            Rectangle2D finalRasterAreaDouble = XAffineTransform.transform((AffineTransform)sourceWorldToGridTransform, (Rectangle2D)cropEnvelope.toRectangle2D(), null);
            Rectangle finalRasterArea = finalRasterAreaDouble.getBounds();
            Rectangle.intersect(finalRasterArea, sourceGridRange, finalRasterArea);
            if (finalRasterArea.isEmpty()) {
                throw new CannotCropException(Errors.format((int)25));
            }
            if (finalRasterArea.equals(sourceGridRange) && isSimpleTransform && cropROI == null) {
                return sourceCoverage;
            }
            double minX = finalRasterArea.getMinX();
            double minY = finalRasterArea.getMinY();
            double width = finalRasterArea.getWidth();
            double height = finalRasterArea.getHeight();
            ParameterBlock pbj = new ParameterBlock();
            pbj.addSource(sourceImage);
            java.awt.Polygon rasterSpaceROI = null;
            String operatioName = null;
            if (!isSimpleTransform || cropROI != null) {
                Polygon modelSpaceROI = FeatureUtilities.getPolygon(cropEnvelope, GFACTORY);
                ArrayList<Point2D> points = new ArrayList<Point2D>(5);
                rasterSpaceROI = FeatureUtilities.convertPolygonToPointArray(modelSpaceROI, (MathTransform)ProjectiveTransform.create((AffineTransform)sourceWorldToGridTransform), points);
                if ((rasterSpaceROI == null || rasterSpaceROI.getBounds().isEmpty()) && finalRasterArea.isEmpty()) {
                    throw new CannotCropException(Errors.format((int)25));
                }
                boolean doMosaic = Crop.decideJAIOperation(roiTolerance, rasterSpaceROI.getBounds2D(), points);
                if (doMosaic || cropROI != null) {
                    ROI[] roiarr;
                    try {
                        if (cropROI != null) {
                            LiteShape2 cropRoiLS2 = new LiteShape2(cropROI, (MathTransform)ProjectiveTransform.create((AffineTransform)sourceWorldToGridTransform), null, false);
                            ROIShape cropRS = new ROIShape((Shape)cropRoiLS2);
                            roiarr = new ROI[]{cropRS};
                        } else {
                            ROIShape roi = new ROIShape((Shape)rasterSpaceROI);
                            roiarr = new ROI[]{roi};
                        }
                    }
                    catch (FactoryException ex) {
                        throw new CannotCropException(Errors.format((int)25), ex);
                    }
                    pbj.add(MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
                    pbj.add(null);
                    pbj.add(roiarr);
                    pbj.add(null);
                    pbj.add(CoverageUtilities.getBackgroundValues(sourceCoverage));
                    Rectangle bounds = rasterSpaceROI.getBounds2D().getBounds();
                    Rectangle.intersect(bounds, sourceGridRange, bounds);
                    if (bounds.isEmpty()) {
                        throw new CannotCropException(Errors.format((int)25));
                    }
                    if (bounds.getBounds().equals(sourceGridRange) && isSimpleTransform) {
                        return sourceCoverage;
                    }
                    Rectangle boundsInt = bounds.getBounds();
                    layout.setMinX(boundsInt.x);
                    layout.setWidth(boundsInt.width);
                    layout.setMinY(boundsInt.y);
                    layout.setHeight(boundsInt.height);
                    operatioName = "Mosaic";
                }
            }
            if (operatioName == null) {
                pbj.add((float)minX);
                pbj.add((float)minY);
                pbj.add((float)width);
                pbj.add((float)height);
                operatioName = "GTCrop";
            }
            RenderedOp croppedImage = !useProvidedProcessor ? JAI.create(operatioName, (ParameterBlock)pbj, (RenderingHints)targetHints) : processor.createNS(operatioName, pbj, targetHints);
            return new GridCoverageFactory(hints).create((CharSequence)sourceCoverage.getName(), (RenderedImage)croppedImage, new GridGeometry2D(new GridEnvelope2D(croppedImage.getBounds()), (MathTransform)sourceGridGeometry.getGridToCRS2D(PixelOrientation.CENTER), sourceCoverage.getCoordinateReferenceSystem()), actionTaken ? null : (GridSampleDimension[])sourceCoverage.getSampleDimensions().clone(), new GridCoverage[]{sourceCoverage}, rasterSpaceROI != null ? Collections.singletonMap("GC_ROI", rasterSpaceROI) : null);
        }
        catch (TransformException e) {
            throw new CannotCropException(Errors.format((int)25), e);
        }
        catch (NoninvertibleTransformException e) {
            throw new CannotCropException(Errors.format((int)25), e);
        }
    }

    private static ImageLayout initLayout(RenderedImage sourceImage, RenderingHints hints) {
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        return layout;
    }

    private static boolean decideJAIOperation(double roiTolerance, Rectangle2D finalGridRange, List<Point2D> points) throws InvalidParameterTypeException, ParameterNotFoundException {
        double roiArea;
        double cropArea = finalGridRange.getWidth() * finalGridRange.getHeight();
        boolean doMosaic = roiTolerance * cropArea > (roiArea = Math.abs(FeatureUtilities.area(points.toArray(new Point2D[0]))));
        return doMosaic;
    }

    static {
        Hints defaultHints = GeoTools.getDefaultHints();
        Object o = defaultHints.get((Object)Hints.JTS_PRECISION_MODEL);
        PrecisionModel pm = o != null ? (PrecisionModel)o : new PrecisionModel();
        GFACTORY = new GeometryFactory(pm, 0);
        GTCropDescriptor.register();
        CROP_ENVELOPE = new DefaultParameterDescriptor(Citations.GEOTOOLS, PARAMNAME_ENVELOPE, Envelope.class, null, null, null, null, null, true);
        CROP_ROI = new DefaultParameterDescriptor(Citations.JAI, PARAMNAME_ROI, Geometry.class, null, null, null, null, null, true);
        ROI_OPTIMISATION_TOLERANCE = new DefaultParameterDescriptor(Citations.GEOTOOLS, PARAMNAME_ROITOLERANCE, Double.class, null, (Object)0.6, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0), null, true);
    }
}

