/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.AbstractStatisticsOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class Extrema
extends AbstractStatisticsOperationJAI {
    private static final long serialVersionUID = 7731039381590398047L;
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverage.processing.operation");
    public static final String GT_SYNTHETIC_PROPERTY_MINIMUM = "minimum";
    public static final String GT_SYNTHETIC_PROPERTY_MAXIMUM = "maximum";
    public static final String GT_SYNTHETIC_PROPERTY_MIN_LOCATIONS = "minLocations";
    public static final String GT_SYNTHETIC_PROPERTY_MAX_LOCATIONS = "maxLocations";

    public Extrema() throws OperationNotFoundException {
        super(Extrema.getOperationDescriptor("Extrema"));
    }

    @Override
    protected boolean computeOnGeophysicsValues(ParameterValueGroup parameters) {
        return true;
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform toCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        if (data instanceof RenderedOp) {
            RenderedOp result = (RenderedOp)data;
            HashMap<String, Object[]> synthProp = new HashMap<String, Object[]>();
            double[] maximums = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_MAXIMUM);
            double[] minimums = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_MINIMUM);
            Object property = result.getProperty(GT_SYNTHETIC_PROPERTY_MIN_LOCATIONS);
            if (property instanceof List[]) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_MIN_LOCATIONS, (List[])property);
            }
            if ((property = result.getProperty(GT_SYNTHETIC_PROPERTY_MAX_LOCATIONS)) instanceof List[]) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_MAX_LOCATIONS, (List[])property);
            }
            synthProp.put(GT_SYNTHETIC_PROPERTY_MINIMUM, minimums);
            synthProp.put(GT_SYNTHETIC_PROPERTY_MAXIMUM, maximums);
            return Collections.unmodifiableMap(synthProp);
        }
        return super.getProperties(data, crs, name, toCRS, sources, parameters);
    }
}

