/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.TemporalPosition;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultTemporalPosition
implements TemporalPosition {
    private TemporalReferenceSystem frame;
    private IndeterminateValue indeterminatePosition;

    public DefaultTemporalPosition(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition) {
        this.frame = frame;
        this.indeterminatePosition = indeterminatePosition;
    }

    public IndeterminateValue getIndeterminatePosition() {
        return this.indeterminatePosition;
    }

    public TemporalReferenceSystem getFrame() {
        if (this.frame == null) {
            this.frame = new DefaultTemporalReferenceSystem((ReferenceIdentifier)new NamedIdentifier(Citations.CRS, (InternationalString)new SimpleInternationalString("Gregorian calendar")), null);
        }
        return this.frame;
    }

    public void setFrame(TemporalReferenceSystem frame) {
        this.frame = frame;
    }

    public void setIndeterminatePosition(IndeterminateValue indeterminatePosition) {
        this.indeterminatePosition = indeterminatePosition;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultTemporalPosition) {
            DefaultTemporalPosition that = (DefaultTemporalPosition)object;
            return Utilities.equals((Object)this.frame, (Object)that.frame) && Utilities.equals((Object)this.indeterminatePosition, (Object)that.indeterminatePosition);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.frame != null ? this.frame.hashCode() : 0);
        hash = 37 * hash + (this.indeterminatePosition != null ? this.indeterminatePosition.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("TemporalPosition:").append('\n');
        if (this.frame != null) {
            s.append("frame:").append(this.frame).append('\n');
        }
        if (this.indeterminatePosition != null) {
            s.append("indeterminatePosition:").append(this.indeterminatePosition).append('\n');
        }
        return s.toString();
    }
}

