/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import javaxt.io.Directory;
import javaxt.io.Image;
import javaxt.io.Jar;
import javaxt.io.Shell;
import javaxt.utils.Date;
import javaxt.xml.DOM;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
implements Comparable {
    private java.io.File file;
    private String name = "";
    private String path = "";
    private FileAttributes attr;
    public final String PathSeparator = System.getProperty("file.separator");
    public final String LineSeperator = System.getProperty("line.separator");
    private static final boolean isWindows = Directory.isWindows;
    private int bufferSize = 0x100000;
    private static final boolean isOSX = System.getProperty("os.name").toLowerCase().contains("os x");
    private static final boolean isSolaris = System.getProperty("os.name").toLowerCase().contains("sunos");
    private static Boolean dllLoaded;

    public File(String Path2) {
        if (Path2.startsWith("\"") && Path2.endsWith("\"")) {
            Path2 = Path2.substring(1, Path2.length() - 1);
        }
        int idx = Path2.replace("\\", "/").lastIndexOf("/") + 1;
        this.path = Path2.substring(0, idx);
        this.name = Path2.substring(idx);
    }

    public File(java.io.File File2) {
        if (File2.isDirectory()) {
            // empty if block
        }
        this.file = File2;
        if (this.file != null) {
            this.name = this.file.getName();
            this.path = this.file.getParentFile().toString();
            if (!this.path.endsWith(this.PathSeparator)) {
                this.path = this.path + this.PathSeparator;
            }
        }
    }

    public File(java.io.File Parent, String Child) {
        this(new java.io.File(Parent, Child));
    }

    public File(Directory Parent, String Child) {
        this(new java.io.File(Parent.toFile(), Child));
    }

    public File(String Parent, String Child) {
        this(new java.io.File(new Directory(Parent).toFile(), Child));
    }

    public String getName() {
        return this.name;
    }

    public String getName(boolean IncludeFileExtension) {
        String FileExt;
        String FileName = this.getName();
        if (!IncludeFileExtension && (FileExt = this.getExtension()).length() > 0) {
            FileName = FileName.substring(0, FileName.length() - (FileExt.length() + 1));
        }
        return FileName;
    }

    public String getPath() {
        return this.path;
    }

    public Directory getDirectory() {
        return this.getParentDirectory();
    }

    public Directory getParentDirectory() {
        if (this.path.length() > 0) {
            return new Directory(this.path);
        }
        return null;
    }

    public java.io.File toFile() {
        return this.getFile();
    }

    private java.io.File getFile() {
        this.attr = null;
        if (this.file == null) {
            this.file = new java.io.File(this.path + this.name);
        }
        return this.file;
    }

    public String getExtension() {
        if (this.name.contains(".")) {
            return this.name.substring(this.name.lastIndexOf(".") + 1);
        }
        return "";
    }

    public long getSize() {
        if (this.file != null) {
            return this.file.length();
        }
        FileAttributes attr = this.getFileAttributes();
        if (attr != null) {
            return attr.getSize();
        }
        return 0L;
    }

    public java.util.Date getDate() {
        if (this.file != null) {
            return new java.util.Date(this.file.lastModified());
        }
        FileAttributes attr = this.getFileAttributes();
        if (attr != null) {
            return attr.getLastWriteTime();
        }
        return new java.util.Date(0L);
    }

    public void setDate(java.util.Date lastModified) {
        java.io.File File2 = this.getFile();
        if (File2 != null) {
            long t = lastModified.getTime();
            if (File2.lastModified() != t) {
                File2.setLastModified(t);
            }
        }
    }

    public boolean exists() {
        if (this.file != null) {
            return this.file.isFile() && this.file.exists();
        }
        FileAttributes attr = this.getFileAttributes();
        if (attr != null) {
            return !attr.isDirectory();
        }
        return false;
    }

    public boolean isHidden() {
        if (this.file != null) {
            return this.file.isHidden();
        }
        FileAttributes attr = this.getFileAttributes();
        if (attr != null) {
            return attr.isHidden();
        }
        return false;
    }

    public boolean isReadOnly() {
        if (this.file != null) {
            return !this.file.canWrite();
        }
        FileAttributes attr = this.getFileAttributes();
        if (attr != null) {
            return attr.isReadOnly();
        }
        return true;
    }

    public boolean isExecutable() {
        java.io.File File2 = this.getFile();
        if (File2 != null) {
            String[] arr = System.getProperty("java.version").split("\\.");
            if (Integer.valueOf(arr[0]) == 1 && Integer.valueOf(arr[1]) < 6) {
                return false;
            }
            try {
                return (Boolean)File2.getClass().getMethod("canExecute", new Class[0]).invoke((Object)File2, null);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isLink() {
        return this.getLink() != null;
    }

    public java.io.File getLink() {
        try {
            return this.getFileAttributes().getLink();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean delete() {
        java.io.File File2 = this.getFile();
        if (File2 != null) {
            return File2.delete();
        }
        return false;
    }

    public void setBufferSize(int numBytes) {
        this.bufferSize = numBytes;
    }

    public File moveTo(Directory Destination) {
        java.io.File File2 = this.getFile();
        java.io.File Dir = Destination.toFile();
        Dir.mkdirs();
        java.io.File newFile = new java.io.File(Dir, File2.getName());
        File2.renameTo(newFile);
        this.file = newFile;
        return this;
    }

    public boolean copyTo(Directory Destination, boolean Overwrite) {
        return this.copyTo(new File(Destination, this.getName()), Overwrite);
    }

    public boolean copyTo(File Destination, boolean Overwrite) {
        java.io.File File2 = this.getFile();
        if (!File2.exists()) {
            return false;
        }
        if (Destination.exists() && !Overwrite) {
            return false;
        }
        if (File2.equals(Destination.toFile())) {
            return false;
        }
        Destination.getParentDirectory().create();
        Channel inputChannel = null;
        Channel outputChannel = null;
        try {
            FileInputStream input = new FileInputStream(File2);
            FileOutputStream output = new FileOutputStream(Destination.toFile());
            inputChannel = Channels.newChannel(input);
            outputChannel = Channels.newChannel(output);
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.bufferSize);
            while (inputChannel.read(buffer) != -1) {
                buffer.flip();
                outputChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                outputChannel.write(buffer);
            }
            inputChannel.close();
            outputChannel.close();
            Destination.toFile().setLastModified(File2.lastModified());
            return true;
        }
        catch (Exception e) {
            try {
                inputChannel.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                outputChannel.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }
    }

    public File rename(String FileName) {
        java.io.File File2;
        if (FileName != null && (FileName = FileName.trim()).length() > 0 && (File2 = this.getFile()) != null) {
            java.io.File newFile = new java.io.File(this.getPath() + FileName);
            File2.renameTo(newFile);
            this.file = newFile;
        }
        return this;
    }

    public BufferedWriter getBufferedWriter(String charsetName) {
        try {
            java.io.File File2 = this.getFile();
            File2.getParentFile().mkdirs();
            if (charsetName == null) {
                return new BufferedWriter(new FileWriter(File2));
            }
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(File2), charsetName));
        }
        catch (Exception e) {
            return null;
        }
    }

    public BufferedReader getBufferedReader() {
        java.io.File File2 = this.getFile();
        if (File2.exists()) {
            try {
                return new BufferedReader(new FileReader(File2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public BufferedReader getBufferedReader(String charsetName) {
        java.io.File File2 = this.getFile();
        if (File2.exists()) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), charsetName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public BufferedImage getBufferedImage() {
        Image img = this.getImage();
        if (img != null) {
            return img.getBufferedImage();
        }
        return null;
    }

    public Image getImage() {
        java.io.File File2 = this.getFile();
        if (File2.exists()) {
            return new Image(File2);
        }
        return null;
    }

    public String getText() {
        try {
            return this.getText("UTF-8");
        }
        catch (Exception e) {
            try {
                return this.getBytes().toString();
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    public String getText(String charsetName) {
        try {
            return this.getBytes().toString(charsetName);
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXML() {
        FileInputStream is = null;
        try {
            is = this.getInputStream();
            Document xml = DOM.createDocument(is);
            is.close();
            Document document = xml;
            return document;
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    public ByteArrayOutputStream getBytes() {
        return File.getBytes(this.getFile(), this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayOutputStream getBytes(java.io.File File2, int bufferSize) {
        if (File2.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(File2);
                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                byte[] b = new byte[bufferSize];
                int x = 0;
                while ((x = is.read(b, 0, bufferSize)) > -1) {
                    bas.write(b, 0, x);
                }
                bas.close();
                is.close();
                ByteArrayOutputStream byteArrayOutputStream = bas;
                return byteArrayOutputStream;
            }
            catch (Exception e) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return null;
    }

    public long checksum() {
        try {
            CRC32 crc = new CRC32();
            crc.update(this.getBytes().toByteArray());
            return crc.getValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public void write(ByteArrayOutputStream bas) {
        this.write(bas.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) {
        java.io.File File2 = this.getFile();
        if (File2 != null) {
            FileOutputStream output = null;
            try {
                File2.getParentFile().mkdirs();
                output = new FileOutputStream(File2);
                output.write(bytes);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream input) {
        java.io.File File2 = this.getFile();
        if (File2 != null) {
            FileOutputStream output = null;
            try {
                File2.getParentFile().mkdirs();
                output = new FileOutputStream(File2);
                byte[] buf = new byte[this.bufferSize];
                int i = 0;
                while ((i = input.read(buf)) != -1) {
                    output.write(buf, 0, i);
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(String Text2) {
        this.write(Text2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String Text2, String charsetName) {
        java.io.File File2 = this.getFile();
        if (File2 != null) {
            Writer output = null;
            try {
                File2.getParentFile().mkdirs();
                output = charsetName == null ? new BufferedWriter(new FileWriter(File2)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(File2), charsetName));
                output.write(Text2);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(Document xml) {
        this.write(DOM.getText(xml), xml.getXmlEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String[] Content) {
        java.io.File File2 = this.getFile();
        if (File2 != null) {
            Writer output = null;
            try {
                File2.getParentFile().mkdirs();
                output = new BufferedWriter(new FileWriter(File2));
                for (int i = 0; i < Content.length - 1; ++i) {
                    output.write(Content[i] + this.LineSeperator);
                }
                output.write(Content[Content.length - 1]);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(BufferedImage Image2) {
        java.io.File File2 = this.getFile();
        if (File2 != null) {
            try {
                File2.getParentFile().mkdirs();
                BufferedImage rendImage = Image2;
                ImageIO.write((RenderedImage)rendImage, this.getExtension(), File2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String MapPath(String RelPath) {
        String currDir = this.getPath();
        if (!(currDir = currDir.replace("\\", "/")).endsWith("/")) {
            currDir = currDir + "/";
        }
        RelPath = RelPath.replace("\\", "/");
        String[] arrRelPath = RelPath.split("/");
        String[] arrAbsPath = currDir.split("/");
        int x = -1;
        RelPath = "";
        String Dir = "";
        for (int i = 0; i < arrRelPath.length; ++i) {
            Dir = arrRelPath[i];
            if (Dir.equals("..")) {
                ++x;
                continue;
            }
            if (Dir.equals(".")) continue;
            RelPath = RelPath + "\\" + arrRelPath[i];
        }
        Dir = "";
        boolean ubound = false;
        for (int i = 0; i < arrAbsPath.length - (x + 1); ++i) {
            Dir = Dir + arrAbsPath[i] + "\\";
        }
        Dir = Dir.substring(0, Dir.length() - 1);
        Dir = Dir + RelPath.replace("/", "\\");
        Dir = Dir.replace("\\", this.PathSeparator);
        return Dir;
    }

    public FileInputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    public FileOutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.getFile());
    }

    public String toString() {
        if (this.file != null) {
            return this.file.toString();
        }
        return this.path + this.name;
    }

    public int hashCode() {
        if (isWindows) {
            return this.toString().toLowerCase(Locale.ENGLISH).hashCode() ^ 0x12D591;
        }
        return this.toString().hashCode() ^ 0x12D591;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        return -obj.toString().compareTo(this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj instanceof File || obj instanceof java.io.File) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    private boolean isValidPath(String PathToFile) {
        if (PathToFile == null) {
            return false;
        }
        if (PathToFile.length() < 1) {
            return false;
        }
        String FileName = this.getName();
        if (FileName.length() < 1) {
            return false;
        }
        if (FileName.length() > 260) {
            return false;
        }
        PathToFile = this.toString();
        PathToFile = PathToFile.replace("\\", "/");
        String[] Path2 = PathToFile.split("/");
        String[] arr = new String[]{"/", "?", "<", ">", "\\", ":", "*", "|", "\""};
        for (int i = 0; i < Path2.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (arr[j].equals(":") && i == 0 & Path2[i].length() == 2 || !Path2[i].contains(arr[j])) continue;
                return false;
            }
        }
        return true;
    }

    public String getContentType() {
        if (this.extensionEquals("css")) {
            return "text/css";
        }
        if (this.extensionEquals("dtd")) {
            return "text/plain";
        }
        if (this.extensionEquals("htm,html")) {
            return "text/html";
        }
        if (this.extensionEquals("java")) {
            return "text/plain";
        }
        if (this.extensionEquals("js")) {
            return "text/javascript";
        }
        if (this.extensionEquals("txt")) {
            return "text/plain";
        }
        if (this.extensionEquals("bmp")) {
            return "image/bmp";
        }
        if (this.extensionEquals("gif")) {
            return "image/gif";
        }
        if (this.extensionEquals("jp2,j2c,j2k,jpx")) {
            return "image/jp2";
        }
        if (this.extensionEquals("jpg,jpe,jpeg,jfif,pjpeg,pjp")) {
            return "image/jpeg";
        }
        if (this.extensionEquals("png")) {
            return "image/png";
        }
        if (this.extensionEquals("psd")) {
            return "image/x-photoshop";
        }
        if (this.extensionEquals("rgb")) {
            return "image/x-rgb";
        }
        if (this.extensionEquals("tif,tiff")) {
            return "image/tiff";
        }
        if (this.extensionEquals("xbm")) {
            return "image/x-xbitmap";
        }
        if (this.extensionEquals("xpm")) {
            return "image/x-xpixmap";
        }
        if (this.extensionEquals("ico")) {
            return "image/vnd.microsoft.icon";
        }
        if (this.extensionEquals("doc,dot")) {
            return "application/msword";
        }
        if (this.extensionEquals("xls,xlw,xla,xlc,xlm,xlt,xll")) {
            return "application/vnd.ms-excel";
        }
        if (this.extensionEquals("ppt,pps,pot")) {
            return "application/vnd.ms-powerpoint";
        }
        if (this.extensionEquals("mdb")) {
            return "application/x-msaccess";
        }
        if (this.extensionEquals("mpp")) {
            return "application/vnd.ms-project";
        }
        if (this.extensionEquals("pub")) {
            return "application/x-mspublisher";
        }
        if (this.extensionEquals("wmz")) {
            return "application/x-ms-wmz";
        }
        if (this.extensionEquals("wmd")) {
            return "application/x-ms-wmd";
        }
        if (this.extensionEquals("one,onetoc2,onetmp,onepkg")) {
            return "application/msonenote";
        }
        if (this.extensionEquals("docx")) {
            return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        }
        if (this.extensionEquals("dotx")) {
            return "application/vnd.openxmlformats-officedocument.wordprocessingml.template";
        }
        if (this.extensionEquals("xlsx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (this.extensionEquals("xltx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.template";
        }
        if (this.extensionEquals("pptx")) {
            return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        }
        if (this.extensionEquals("ppsx")) {
            return "application/vnd.openxmlformats-officedocument.presentationml.slideshow";
        }
        if (this.extensionEquals("potx")) {
            return "application/vnd.openxmlformats-officedocument.presentationml.template";
        }
        if (this.extensionEquals("sldx")) {
            return "application/vnd.openxmlformats-officedocument.presentationml.slide";
        }
        if (this.extensionEquals("ai,eps,ps")) {
            return "application/postscript";
        }
        if (this.extensionEquals("gz")) {
            return "application/x-gzip";
        }
        if (this.extensionEquals("pdf")) {
            return "application/pdf";
        }
        if (this.extensionEquals("xml")) {
            return "application/xml";
        }
        if (this.extensionEquals("z")) {
            return "application/x-compress";
        }
        if (this.extensionEquals("zip")) {
            return "application/zip";
        }
        if (this.extensionEquals("mid,midi")) {
            return "audio/x-midi";
        }
        if (this.extensionEquals("mp1,mp2,mp3,mpa,mpega")) {
            return "audio/x-mpeg";
        }
        if (this.extensionEquals("ra,ram")) {
            return "audio/x-pn-realaudio";
        }
        if (this.extensionEquals("wav")) {
            return "audio/x-wav";
        }
        if (this.extensionEquals("wma")) {
            return "audio/x-ms-wma";
        }
        if (this.extensionEquals("wax")) {
            return "audio/x-ms-wax";
        }
        if (this.extensionEquals("wmv")) {
            return "audio/x-ms-wmv";
        }
        if (this.extensionEquals("asf,asx")) {
            return "video/x-ms-asf";
        }
        if (this.extensionEquals("avi")) {
            return "video/msvideo";
        }
        if (this.extensionEquals("mov")) {
            return "video/quicktime";
        }
        if (this.extensionEquals("mpe,mpeg,mpg")) {
            return "video/mpeg";
        }
        if (this.extensionEquals("mpv2")) {
            return "video/mpeg2";
        }
        if (this.extensionEquals("qt,mov,moov")) {
            return "video/quicktime";
        }
        if (this.extensionEquals("wvx")) {
            return "video/x-ms-wvx";
        }
        if (this.extensionEquals("wm")) {
            return "video/x-ms-wm";
        }
        if (this.extensionEquals("wmx")) {
            return "video/x-ms-wmx";
        }
        return "application/octet-stream";
    }

    private boolean extensionEquals(String FileExtension) {
        String ext = this.getExtension();
        String[] arr = FileExtension.split(",");
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i].trim();
            if (!str.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    public void setLastModifiedTime(java.util.Date date) {
        this.setDate(date);
    }

    public java.util.Date getLastModifiedTime() {
        return this.getDate();
    }

    public java.util.Date getCreationTime() {
        try {
            return this.getFileAttributes().getCreationTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public java.util.Date getLastAccessTime() {
        try {
            return this.getFileAttributes().getLastAccessTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public HashSet<String> getFlags() {
        try {
            return this.getFileAttributes().getFlags();
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    public FileAttributes getFileAttributes() {
        if (this.attr == null || new java.util.Date().getTime() - this.attr.lastUpdate > 1000L) {
            try {
                this.attr = new FileAttributes(this.toString());
            }
            catch (Exception e) {
                this.attr = null;
            }
        }
        return this.attr;
    }

    protected static synchronized boolean loadDLL() {
        if (isWindows) {
            if (dllLoaded == null) {
                String jvmPlatform = System.getProperty("os.arch");
                String dllName = null;
                if (jvmPlatform.equalsIgnoreCase("x86")) {
                    dllName = "javaxt-core.dll";
                } else if (jvmPlatform.equalsIgnoreCase("amd64")) {
                    dllName = "javaxt-core64.dll";
                } else {
                    dllLoaded = false;
                    return dllLoaded;
                }
                Jar jar = new Jar(Jar.class);
                Jar.Entry entry = jar.getEntry(null, dllName);
                long checksum = entry.checksum();
                ArrayList<java.io.File> files = new ArrayList<java.io.File>();
                files.add(new java.io.File(jar.getFile().getParentFile(), dllName));
                Directory dir = new Directory(System.getProperty("user.home"));
                for (String appDir : new String[]{"AppData\\Local", "Application Data"}) {
                    Directory d = new Directory(dir + appDir);
                    if (!d.exists() || !d.toFile().canWrite()) continue;
                    dir = d;
                    break;
                }
                files.add(new java.io.File(dir + "JavaXT\\" + dllName));
                for (java.io.File dll : files) {
                    if (dll.exists()) {
                        byte[] b = new byte[(int)dll.length()];
                        FilterInputStream is = null;
                        try {
                            is = new DataInputStream(new FileInputStream(dll));
                            ((DataInputStream)is).readFully(b, 0, b.length);
                            is.close();
                            CRC32 crc = new CRC32();
                            crc.update(b);
                            if (checksum != crc.getValue()) {
                                dll.delete();
                                entry.extractFile(dll);
                            }
                        }
                        catch (Exception e) {
                            try {
                                is.close();
                            }
                            catch (Exception ex) {}
                        }
                    } else {
                        entry.extractFile(dll);
                    }
                    if (!dll.exists()) continue;
                    try {
                        System.load(dll.toString());
                        dllLoaded = true;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return dllLoaded;
        }
        return false;
    }

    private static native long[] GetFileAttributesEx(String var0) throws Exception;

    private static native String GetTarget(String var0) throws Exception;

    protected static native String GetSharedDrives(String var0) throws Exception;

    protected static native String GetNetworkDrives() throws Exception;

    protected static native String GetFiles(String var0) throws Exception;

    public static class LnkParser {
        private boolean isDirectory;
        private boolean isLocal;
        private String real_file;

        public LnkParser(String lnk) {
            this(new java.io.File(lnk));
        }

        public LnkParser(java.io.File lnk) {
            byte[] link = File.getBytes(lnk, 1024).toByteArray();
            byte flags = link[20];
            int file_atts_offset = 24;
            byte file_atts = link[24];
            int is_dir_mask = 16;
            this.isDirectory = (file_atts & is_dir_mask) > 0;
            int shell_offset = 76;
            boolean has_shell_mask = true;
            int shell_len = 0;
            if ((flags & 1) > 0) {
                shell_len = LnkParser.bytes2short(link, 76) + 2;
            }
            int file_start = 76 + shell_len;
            int file_location_info_flag_offset_offset = 8;
            byte file_location_info_flag = link[file_start + 8];
            this.isLocal = (file_location_info_flag & 2) == 0;
            int basename_offset_offset = 16;
            int networkVolumeTable_offset_offset = 20;
            int finalname_offset_offset = 24;
            int finalname_offset = link[file_start + 24] + file_start;
            String finalname = LnkParser.getNullDelimitedString(link, finalname_offset);
            if (this.isLocal) {
                int basename_offset = link[file_start + 16] + file_start;
                String basename = LnkParser.getNullDelimitedString(link, basename_offset);
                this.real_file = basename + finalname;
            } else {
                int networkVolumeTable_offset = link[file_start + 20] + file_start;
                int shareName_offset_offset = 8;
                int shareName_offset = link[networkVolumeTable_offset + shareName_offset_offset] + networkVolumeTable_offset;
                String shareName = LnkParser.getNullDelimitedString(link, shareName_offset);
                this.real_file = shareName + "\\" + finalname;
            }
        }

        private static String getNullDelimitedString(byte[] bytes, int off) {
            int len = 0;
            while (bytes[off + len] != 0) {
                ++len;
            }
            return new String(bytes, off, len);
        }

        private static int bytes2short(byte[] bytes, int off) {
            return (bytes[off + 1] & 0xFF) << 8 | bytes[off] & 0xFF;
        }

        public java.io.File getFile() {
            return new java.io.File(this.real_file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileAttributes {
        private java.util.Date ftCreationTime;
        private java.util.Date ftLastAccessTime;
        private java.util.Date ftLastWriteTime;
        private long size;
        private HashSet<String> flags = new HashSet();
        private java.io.File link;
        protected long lastUpdate;
        private static final int FILE_ATTRIBUTE_READONLY = 1;
        private static final int FILE_ATTRIBUTE_HIDDEN = 2;
        private static final int FILE_ATTRIBUTE_SYSTEM = 4;
        private static final int FILE_ATTRIBUTE_DIRECTORY = 16;
        private static final int FILE_ATTRIBUTE_ARCHIVE = 32;
        private static final int FILE_ATTRIBUTE_DEVICE = 64;
        private static final int FILE_ATTRIBUTE_NORMAL = 128;
        private static final int FILE_ATTRIBUTE_TEMPORARY = 256;
        private static final int FILE_ATTRIBUTE_SPARSE_FILE = 512;
        private static final int FILE_ATTRIBUTE_REPARSE_POINT = 1024;
        private static final int FILE_ATTRIBUTE_COMPRESSED = 2048;
        private static final int FILE_ATTRIBUTE_OFFLINE = 4096;
        private static final int FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 8192;
        private static final int FILE_ATTRIBUTE_ENCRYPTED = 16384;
        private static final int FILE_ATTRIBUTE_VIRTUAL = 65536;

        public FileAttributes(String path) throws Exception {
            if (isWindows) {
                if (File.loadDLL()) {
                    long[] attributes = File.GetFileAttributesEx(path);
                    SimpleDateFormat ftFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                    this.ftCreationTime = ftFormatter.parse(attributes[1] + "");
                    this.ftLastAccessTime = ftFormatter.parse(attributes[2] + "");
                    this.ftLastWriteTime = ftFormatter.parse(attributes[3] + "");
                    long MAXDWORD = 0x100000000L;
                    long nFileSizeHigh = attributes[4];
                    long nFileSizeLow = attributes[5];
                    this.size = nFileSizeHigh * MAXDWORD + nFileSizeLow;
                    long dwFileAttributes = attributes[0];
                    if (this.bitand(dwFileAttributes, 1L) == 1L) {
                        this.flags.add("READONLY");
                    }
                    if (this.bitand(dwFileAttributes, 2L) == 2L) {
                        this.flags.add("HIDDEN");
                    }
                    if (this.bitand(dwFileAttributes, 4L) == 4L) {
                        this.flags.add("SYSTEM");
                    }
                    if (this.bitand(dwFileAttributes, 16L) == 16L) {
                        this.flags.add("DIRECTORY");
                    }
                    if (this.bitand(dwFileAttributes, 32L) == 32L) {
                        this.flags.add("ARCHIVE");
                    }
                    if (this.bitand(dwFileAttributes, 64L) == 64L) {
                        this.flags.add("DEVICE");
                    }
                    if (this.bitand(dwFileAttributes, 128L) == 128L) {
                        this.flags.add("NORMAL");
                    }
                    if (this.bitand(dwFileAttributes, 256L) == 256L) {
                        this.flags.add("TEMPORARY");
                    }
                    if (this.bitand(dwFileAttributes, 512L) == 512L) {
                        this.flags.add("SPARSE_FILE");
                    }
                    if (this.bitand(dwFileAttributes, 1024L) == 1024L) {
                        this.flags.add("REPARSE_POINT");
                    }
                    if (this.bitand(dwFileAttributes, 2048L) == 2048L) {
                        this.flags.add("COMPRESSED");
                    }
                    if (this.bitand(dwFileAttributes, 4096L) == 4096L) {
                        this.flags.add("OFFLINE");
                    }
                    if (this.bitand(dwFileAttributes, 8192L) == 8192L) {
                        this.flags.add("NOT_CONTENT_INDEXED");
                    }
                    if (this.bitand(dwFileAttributes, 16384L) == 16384L) {
                        this.flags.add("ENCRYPTED");
                    }
                    if (this.bitand(dwFileAttributes, 65536L) == 65536L) {
                        this.flags.add("VIRTUAL");
                    }
                    if (this.flags.contains("REPARSE_POINT")) {
                        this.link = new java.io.File(File.GetTarget(path));
                    }
                } else {
                    java.io.File f = new java.io.File(path);
                    this.ftLastWriteTime = new java.util.Date(f.lastModified());
                    if (!f.canWrite()) {
                        this.flags.add("READONLY");
                    }
                    if (f.isHidden()) {
                        this.flags.add("HIDDEN");
                    }
                    if (f.isDirectory()) {
                        this.flags.add("DIRECTORY");
                    }
                }
            } else {
                String[] params;
                if (isOSX) {
                    params = new String[]{"ls", "-lauT", path};
                    Shell cmd = new Shell(params);
                    cmd.run();
                    Iterator<String> it = cmd.getOutput().iterator();
                    this.ftLastAccessTime = this.parseOSXDate(it);
                    params = new String[]{"ls", "-laUT", path};
                    cmd = new Shell(params);
                    cmd.run();
                    it = cmd.getOutput().iterator();
                    this.ftCreationTime = this.parseOSXDate(it);
                } else if (isSolaris) {
                    params = new String[]{"ls", "-lauE", path};
                    Shell cmd = new Shell(params);
                    cmd.run();
                    Iterator<String> it = cmd.getOutput().iterator();
                    this.ftLastAccessTime = this.parseFullDate(it);
                } else {
                    params = new String[]{"ls", "-lau", "--full-time", path};
                    Shell cmd = new Shell(params);
                    cmd.run();
                    Iterator<String> it = cmd.getOutput().iterator();
                    this.ftLastAccessTime = this.parseFullDate(it);
                    params = new String[]{"ls", "-laU", "--full-time", path};
                    cmd = new Shell(params);
                    cmd.run();
                    it = cmd.getOutput().iterator();
                    this.ftCreationTime = this.parseFullDate(it);
                }
                java.io.File f = new java.io.File(path);
                this.ftLastWriteTime = new java.util.Date(f.lastModified());
                if (!f.canWrite()) {
                    this.flags.add("READONLY");
                }
                if (f.isHidden()) {
                    this.flags.add("HIDDEN");
                }
                if (f.isDirectory()) {
                    this.flags.add("DIRECTORY");
                }
                try {
                    if (!f.getCanonicalFile().equals(f.getAbsoluteFile())) {
                        this.flags.add("REPARSE_POINT");
                        this.link = f.getCanonicalFile();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.isDirectory() && this.link == null && path.toLowerCase().endsWith(".lnk")) {
                try {
                    this.link = new LnkParser(path).getFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.lastUpdate = new java.util.Date().getTime();
        }

        private java.util.Date parseFullDate(Iterator<String> it) {
            while (it.hasNext()) {
                String line = it.next();
                if (line == null) continue;
                while (line.contains("  ")) {
                    line = line.replace("  ", " ");
                }
                String[] arr = line.split(" ");
                if (arr.length <= 7) continue;
                try {
                    if (arr[6].length() > 8) {
                        arr[6] = arr[6].substring(0, 8);
                    }
                    String date = arr[5] + " " + arr[6] + " " + arr[7];
                    return new Date(date, "yyyy-MM-dd HH:mm:ss z").getDate();
                }
                catch (Exception e) {
                }
            }
            return null;
        }

        private java.util.Date parseOSXDate(Iterator<String> it) {
            while (it.hasNext()) {
                String line = it.next();
                if (line == null) continue;
                while (line.contains("  ")) {
                    line = line.replace("  ", " ");
                }
                String[] arr = line.split(" ");
                if (arr.length <= 10) continue;
                try {
                    String date = arr[5] + " " + arr[6] + " " + arr[7] + " " + arr[8];
                    return new Date(date, "MMM dd hh:mm:ss yyyy").getDate();
                }
                catch (Exception e) {
                }
            }
            return null;
        }

        public long getSize() {
            return this.size;
        }

        public java.util.Date getCreationTime() {
            return this.ftCreationTime;
        }

        public java.util.Date getLastAccessTime() {
            return this.ftLastAccessTime;
        }

        public java.util.Date getLastWriteTime() {
            return this.ftLastWriteTime;
        }

        public boolean isDirectory() {
            return this.flags.contains("DIRECTORY");
        }

        public boolean isHidden() {
            return this.flags.contains("HIDDEN");
        }

        public boolean isReadOnly() {
            return this.flags.contains("READONLY");
        }

        public HashSet<String> getFlags() {
            return this.flags;
        }

        public java.io.File getLink() {
            return this.link;
        }

        private long bitand(long Number1, long Number2) {
            try {
                return Number1 & Number2;
            }
            catch (Exception e) {
                return -1L;
            }
        }
    }
}

