/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javaxt.utils.Base64;
import javaxt.utils.Date;
import javaxt.utils.string;
import javaxt.webservices.Option;
import javaxt.xml.DOM;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parameter {
    private String Name;
    private String Type;
    private String Value;
    private String minOccurs = "0";
    private String maxOccurs = "1";
    protected boolean IsNillable;
    protected boolean IsAttribute;
    protected Node ParentNode;
    private NodeList ChildNodes;
    protected Parameter[] Children = null;
    private Option[] Options = null;

    protected Parameter(Node ParameterNode) {
        NamedNodeMap attr = ParameterNode.getAttributes();
        this.Name = DOM.getAttributeValue(attr, "name");
        this.Type = DOM.getAttributeValue(attr, "type");
        this.IsAttribute = this.bool(DOM.getAttributeValue(attr, "isattribute"));
        this.IsNillable = this.bool(DOM.getAttributeValue(attr, "isnillable"));
        this.minOccurs = DOM.getAttributeValue(attr, "minOccurs");
        this.ChildNodes = ParameterNode.getChildNodes();
        this.ParentNode = ParameterNode.getParentNode();
        this.Options = this.getOptions(ParameterNode.getChildNodes());
    }

    private Option[] getOptions(NodeList optionNodes) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (Node optionNode : DOM.getNodes(optionNodes)) {
            if (!optionNode.getNodeName().equalsIgnoreCase("options")) continue;
            for (Node childNode : DOM.getNodes(optionNode.getChildNodes())) {
                options.add(this.getOption(childNode));
            }
        }
        if (options.isEmpty()) {
            return null;
        }
        return options.toArray(new Option[options.size()]);
    }

    private Option getOption(Node node) {
        String value;
        NamedNodeMap attr = node.getAttributes();
        String name = value = DOM.getAttributeValue(attr, "value");
        return new Option(name, value);
    }

    public String getName() {
        return this.Name;
    }

    public String getType() {
        return this.Type;
    }

    public String getValue() {
        return this.Value;
    }

    public void setValue(int value) {
        this.setValue(value + "");
    }

    public void setValue(double value) {
        this.setValue(value + "");
    }

    public void setValue(boolean value) {
        this.setValue(value + "");
    }

    public void setValue(String Value2) {
        if (Value2 == null) {
            Value2 = "";
        }
        if (Value2.equalsIgnoreCase("null")) {
            Value2 = "";
        }
        if (!this.isComplex() && Value2.trim().length() > 0) {
            if (this.Type.equalsIgnoreCase("datetime")) {
                try {
                    Date d = new Date(Value2);
                    this.setValue(d.getDate());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                Value2 = this.Value;
            }
            if (this.Type.equalsIgnoreCase("boolean")) {
                Value2 = Value2.equalsIgnoreCase("true") ? "true" : "false";
            }
        }
        this.Value = Value2;
    }

    public void setValue(byte[] bytes) {
        this.setValue(Base64.encodeBytes(bytes));
    }

    public void setValue(java.util.Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSZ");
        String d = formatter.format(date).replace(" ", "T");
        String d1 = d.substring(0, d.length() - 2);
        String d2 = d.substring(d.length() - 2);
        this.Value = d = d1 + ":" + d2;
    }

    public int getMaxOccurs() {
        if (this.maxOccurs == null) {
            return 1;
        }
        this.maxOccurs = this.maxOccurs.trim();
        if (this.maxOccurs.equalsIgnoreCase("unbounded")) {
            return Short.MAX_VALUE;
        }
        if (this.maxOccurs.equals("")) {
            return 1;
        }
        try {
            int i = this.cint(this.maxOccurs);
            if (i < 0) {
                return 0;
            }
            return i;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int getMinOccurs() {
        if (this.minOccurs == null) {
            return 0;
        }
        this.minOccurs = this.minOccurs.trim();
        try {
            int i = this.cint(this.minOccurs);
            if (i < 0) {
                return 0;
            }
            return i;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean isRequired() {
        return this.getMinOccurs() != 0;
    }

    public boolean isComplex() {
        if (this.getChildren() != null && this.getChildren().length > 0) {
            return true;
        }
        if (this.Options != null) {
            return false;
        }
        return false;
    }

    public Parameter[] getChildren() {
        return this.Children;
    }

    protected NodeList getChildNodes() {
        return this.ChildNodes;
    }

    public Option[] getOptions() {
        return this.Options;
    }

    public String toString() {
        if (this.isComplex()) {
            return this.Name;
        }
        return this.Name + "=" + this.Value;
    }

    private int cint(String str) {
        return string.cint(str);
    }

    private boolean bool(String str) {
        return str.equalsIgnoreCase("true");
    }
}

