/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javaxt.http.Request;
import javaxt.http.Response;
import javaxt.utils.string;
import javaxt.webservices.Method;
import javaxt.webservices.Service;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL {
    private Document wsdl;
    private Document ssd;
    private String vbCrLf = "\r\n";
    private String ElementNameSpace = "";
    private HashMap<String, String> NameSpaces;
    private NodeList Schema;
    private HashMap<String, Element> knownTypes = new HashMap();

    public WSDL(URL url) {
        this(new Request(url).getResponse().getXML(), null, true);
    }

    public WSDL(String url) {
        this(new Request(url).getResponse().getXML(), null, true);
    }

    public WSDL(URL url, String HttpProxyServer) {
        this(new Request(url).getResponse().getXML(), null, false);
    }

    public WSDL(File xml) {
        this(new javaxt.io.File(xml).getXML(), null, true);
    }

    public WSDL(File xml, boolean followImports) {
        this(new javaxt.io.File(xml).getXML(), null, followImports);
    }

    public WSDL(Document wsdl) {
        this(wsdl, null, true);
    }

    public WSDL(Document wsdl, boolean followImports) {
        this(wsdl, null, followImports);
    }

    public WSDL(Document wsdl, Document xsd) {
        this(wsdl, new Document[]{xsd});
    }

    public WSDL(Document wsdl, Document[] xsd) {
        this(wsdl, xsd, false);
    }

    public WSDL(Document wsdl, Document[] xsd, boolean followImports) {
        this.wsdl = wsdl;
        this.NameSpaces = DOM.getNameSpaces(wsdl);
        this.ElementNameSpace = this.getElementNameSpace();
        if (xsd == null) {
            xsd = new Document[]{wsdl};
        } else {
            Document[] arr = new Document[xsd.length + 1];
            arr[0] = wsdl;
            for (int i = 1; i < arr.length; ++i) {
                arr[i] = xsd[i - 1];
            }
            xsd = arr;
        }
        this.addSchema(xsd, followImports, false);
        this.parseWSDL();
    }

    public Document getSSD() {
        return this.ssd;
    }

    public String toString() {
        return DOM.getText(this.ssd);
    }

    private NamedNodeMap getDefinitionAttributes() {
        NodeList Definitions = this.wsdl.getChildNodes();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            if (Definitions.item(i).getNodeType() != 1 || !this.contains(Definitions.item(i).getNodeName(), "definitions")) continue;
            return Definitions.item(i).getAttributes();
        }
        return null;
    }

    private String getTargetNameSpace() {
        NamedNodeMap attr = this.getDefinitionAttributes();
        return DOM.getAttributeValue(attr, "targetNamespace");
    }

    private String getElementNameSpace() {
        String elementNameSpace = "http://www.w3.org/2001/XMLSchema";
        NamedNodeMap attr = this.getDefinitionAttributes();
        if (attr != null) {
            for (int i = 0; i < attr.getLength(); ++i) {
                Node node = attr.item(i);
                String nodeName = node.getNodeName().toLowerCase();
                String nodeValue = node.getNodeValue();
                if (!nodeValue.toLowerCase().equals(elementNameSpace.toLowerCase())) continue;
                return this.stripNameSpace(nodeName);
            }
        }
        return "";
    }

    private boolean isElementComplex(String elementType) {
        String elementNameSpace = "";
        if (elementType.contains(":")) {
            elementNameSpace = elementType.substring(0, elementType.indexOf(":"));
        }
        return !elementNameSpace.equalsIgnoreCase(this.ElementNameSpace);
    }

    private boolean isElementNillable(String isnillable) {
        return isnillable.toLowerCase().equals("true");
    }

    private void parseWSDL() {
        String SSD = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + this.vbCrLf + "<ssd>" + this.vbCrLf;
        String ServiceName = "";
        String ServiceDescription = "";
        Port Port2 = null;
        Binding Binding2 = null;
        ArrayList<Binding> arrBindings = null;
        Element Element2 = null;
        ArrayList<Element> arrElements = null;
        NodeList Definitions = this.getDefinitions();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            int j;
            if (!this.contains(Definitions.item(i).getNodeName(), "service")) continue;
            NamedNodeMap attr = Definitions.item(i).getAttributes();
            ServiceName = DOM.getAttributeValue(attr, "name");
            NodeList ChildNodes = Definitions.item(i).getChildNodes();
            for (j = 0; j < ChildNodes.getLength(); ++j) {
                if (!this.contains(ChildNodes.item(j).getNodeName(), "documentation")) continue;
                ServiceDescription = ChildNodes.item(j).getTextContent();
            }
            Port2 = this.getPort(ChildNodes);
            if (Port2 == null) continue;
            SSD = SSD + " <service name=\"" + ServiceName + "\" url=\"" + Port2.Address + "\" namespace=\"" + this.getTargetNameSpace() + "\">" + this.vbCrLf;
            if (ServiceDescription != null) {
                SSD = SSD + "  <description>" + ServiceDescription + "</description>" + this.vbCrLf;
            }
            SSD = SSD + "  <methods>" + this.vbCrLf;
            arrBindings = this.getBindings(Port2.Binding);
            for (j = 0; j < arrBindings.size(); ++j) {
                int k;
                Binding2 = arrBindings.get(j);
                String SoapAction = Binding2.SoapAction;
                if (SoapAction != null) {
                    SoapAction = " soapAction=\"" + SoapAction + "\"";
                }
                Message Message2 = this.getMessages(Binding2.Type, Binding2.Operation);
                String ResultsNode = "";
                try {
                    arrElements = this.getElements(Message2.Output);
                    for (k = 0; k < arrBindings.size(); ++k) {
                        Element2 = arrElements.get(k);
                        ResultsNode = Element2.Name;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                SSD = SSD + "  <method name=\"" + Binding2.Operation + "\"" + SoapAction + " resultsNode=\"" + ResultsNode + "\">" + this.vbCrLf;
                if (Message2.Documentation != null) {
                    SSD = SSD + "  <description>" + Message2.Documentation + "</description>" + this.vbCrLf;
                }
                SSD = SSD + "  <parameters>" + this.vbCrLf;
                arrElements = this.getElements(Message2.Input);
                try {
                    for (k = 0; k < arrElements.size(); ++k) {
                        Element2 = arrElements.get(k);
                        SSD = SSD + Element2.toString();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                SSD = SSD + "  </parameters>" + this.vbCrLf;
                SSD = SSD + "  </method>" + this.vbCrLf;
            }
            SSD = SSD + "  </methods>" + this.vbCrLf;
            SSD = SSD + " </service>" + this.vbCrLf;
        }
        SSD = SSD + this.vbCrLf + "</ssd>";
        this.ssd = DOM.createDocument(SSD);
        this.knownTypes.clear();
    }

    private Port getPort(NodeList Ports) {
        Port Port2 = null;
        boolean foundSoapPort = false;
        for (int j = 0; j < Ports.getLength(); ++j) {
            if (!this.contains(Ports.item(j).getNodeName(), "port")) continue;
            NamedNodeMap attr = Ports.item(j).getAttributes();
            String PortName = DOM.getAttributeValue(attr, "name");
            String PortBinding = this.stripNameSpace(DOM.getAttributeValue(attr, "binding"));
            String PortAddress = "";
            NodeList Addresses2 = Ports.item(j).getChildNodes();
            for (int k = 0; k < Addresses2.getLength(); ++k) {
                String Address = Addresses2.item(k).getNodeName();
                if (!this.contains(Address, "address") || this.contains(Address, "http:")) continue;
                attr = Addresses2.item(k).getAttributes();
                PortAddress = DOM.getAttributeValue(attr, "location");
                foundSoapPort = true;
            }
            if (!foundSoapPort) continue;
            Port2 = new Port();
            Port2.Name = PortName;
            Port2.Binding = PortBinding;
            Port2.Address = PortAddress;
            return Port2;
        }
        return Port2;
    }

    private ArrayList<Binding> getBindings(String PortBinding) {
        Binding Binding2 = null;
        ArrayList<Binding> arrBindings = null;
        int BindingCount = -1;
        NodeList Definitions = this.getDefinitions();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            int j;
            if (!this.contains(Definitions.item(i).getNodeName(), "binding")) continue;
            NamedNodeMap attr = Definitions.item(i).getAttributes();
            String BindingName = DOM.getAttributeValue(attr, "name");
            String BindingType = DOM.getAttributeValue(attr, "type");
            if (!BindingName.equals(PortBinding)) continue;
            arrBindings = new ArrayList<Binding>();
            String BindingTransport = "";
            String BindingStyle = "";
            NodeList ChildNodes = Definitions.item(i).getChildNodes();
            for (j = 0; j < ChildNodes.getLength(); ++j) {
                if (!this.contains(ChildNodes.item(j).getNodeName(), "binding")) continue;
                attr = ChildNodes.item(j).getAttributes();
                BindingStyle = DOM.getAttributeValue(attr, "style");
                BindingTransport = DOM.getAttributeValue(attr, "transport");
            }
            for (j = 0; j < ChildNodes.getLength(); ++j) {
                if (!this.contains(ChildNodes.item(j).getNodeName(), "operation")) continue;
                Binding2 = new Binding();
                ++BindingCount;
                attr = ChildNodes.item(j).getAttributes();
                Binding2.Operation = DOM.getAttributeValue(attr, "name");
                NodeList Operations = ChildNodes.item(j).getChildNodes();
                for (int k = 0; k < Operations.getLength(); ++k) {
                    if (!this.contains(Operations.item(k).getNodeName(), "operation")) continue;
                    attr = Operations.item(k).getAttributes();
                    Binding2.SoapAction = DOM.getAttributeValue(attr, "soapaction");
                    Binding2.Style = BindingStyle;
                    Binding2.Name = BindingName;
                    Binding2.Type = this.stripNameSpace(BindingType);
                }
                arrBindings.add(Binding2);
            }
            return arrBindings;
        }
        return null;
    }

    private Message getMessages(String PortTypeName, String OperationName) {
        Message Message2 = null;
        NodeList Definitions = this.getDefinitions();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            NamedNodeMap attr;
            String portTypeName;
            if (!this.contains(Definitions.item(i).getNodeName(), "porttype") || !(portTypeName = DOM.getAttributeValue(attr = Definitions.item(i).getAttributes(), "name")).equals(PortTypeName)) continue;
            String Documentation = "";
            NodeList PortTypes = Definitions.item(i).getChildNodes();
            for (int j = 0; j < PortTypes.getLength(); ++j) {
                String operationName;
                String NodeName = PortTypes.item(j).getNodeName();
                if (NodeName.endsWith("documentation")) {
                    Documentation = DOM.getNodeValue(PortTypes.item(j));
                }
                if (!NodeName.endsWith("operation") || !(operationName = DOM.getAttributeValue(attr = PortTypes.item(j).getAttributes(), "name")).equals(OperationName)) continue;
                Message2 = new Message();
                Message2.Documentation = Documentation;
                NodeList Messages = PortTypes.item(j).getChildNodes();
                for (int k = 0; k < Messages.getLength(); ++k) {
                    if (Messages.item(k).getNodeType() != 1) continue;
                    attr = Messages.item(k).getAttributes();
                    String messageName = this.stripNameSpace(DOM.getAttributeValue(attr, "message"));
                    if (this.contains(Messages.item(k).getNodeName(), "input")) {
                        Message2.Input = messageName;
                    }
                    if (this.contains(Messages.item(k).getNodeName(), "output")) {
                        Message2.Output = messageName;
                    }
                    if (!this.contains(Messages.item(k).getNodeName(), "documentation") || (Documentation = DOM.getNodeValue(Messages.item(k))).length() <= 0) continue;
                    Message2.Documentation = Documentation;
                }
                return Message2;
            }
        }
        return Message2;
    }

    private ArrayList<Element> getElements(String MessageName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList Definitions = this.getDefinitions();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            NamedNodeMap attr;
            String messageName;
            if (!this.contains(Definitions.item(i).getNodeName(), "message") || !(messageName = DOM.getAttributeValue(attr = Definitions.item(i).getAttributes(), "name")).equals(MessageName)) continue;
            NodeList Messages = Definitions.item(i).getChildNodes();
            for (int j = 0; j < Messages.getLength(); ++j) {
                if (!this.contains(Messages.item(j).getNodeName(), "part")) continue;
                attr = Messages.item(j).getAttributes();
                String type = DOM.getAttributeValue(attr, "type");
                String element = this.stripNameSpace(DOM.getAttributeValue(attr, "element"));
                elements = this.getElement(element);
            }
            return elements;
        }
        return null;
    }

    private NodeList getDefinitions() {
        NodeList Definitions = this.wsdl.getChildNodes();
        if (Definitions != null) {
            for (int i = 0; i < Definitions.getLength(); ++i) {
                Node node = Definitions.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().endsWith("definitions")) continue;
                return Definitions.item(i).getChildNodes();
            }
        }
        return null;
    }

    private NodeList getTypes() {
        NodeList Definitions = this.getDefinitions();
        if (Definitions != null) {
            for (int i = 0; i < Definitions.getLength(); ++i) {
                Node node = Definitions.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().endsWith("types")) continue;
                return node.getChildNodes();
            }
        }
        return null;
    }

    private NodeList getSchema() {
        return this.Schema;
    }

    public void addSchema(Document xsd, boolean followImports) {
        this.addSchema(new Document[]{xsd}, followImports);
    }

    public void addSchema(Document[] xsd, boolean followImports) {
        this.addSchema(xsd, followImports, true);
    }

    private void addSchema(Document[] XSDs, boolean followImports, boolean parseWSDL) {
        if (XSDs == null) {
            return;
        }
        if (XSDs.length == 0) {
            return;
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\"?>");
        xml.append("<schemas");
        for (String ns : this.NameSpaces.keySet()) {
            String url = this.NameSpaces.get(ns);
            xml.append(" xmlns:");
            xml.append(ns);
            xml.append("=\"");
            xml.append(url);
            xml.append("\"");
        }
        xml.append(">");
        if (this.Schema != null) {
            xml.append(DOM.getText(this.Schema));
        }
        for (Document xsd : XSDs) {
            Node schemaNode;
            int i;
            if (xsd == null) continue;
            Node outerNode = DOM.getOuterNode(xsd);
            String outerNodeName = this.stripNameSpace(outerNode.getNodeName());
            ArrayList<Node> schemaNodes = new ArrayList<Node>();
            if (outerNodeName.equalsIgnoreCase("definitions")) {
                NodeList childNodes = outerNode.getChildNodes();
                for (i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (!this.stripNameSpace(node.getNodeName()).equalsIgnoreCase("types")) continue;
                    NodeList types = node.getChildNodes();
                    for (int j = 0; j < types.getLength(); ++j) {
                        Node typeNode = types.item(j);
                        if (!this.stripNameSpace(typeNode.getNodeName()).equalsIgnoreCase("schema")) continue;
                        NodeList nodes = typeNode.getChildNodes();
                        for (int k = 0; k < nodes.getLength(); ++k) {
                            schemaNodes.add(nodes.item(k));
                        }
                    }
                }
            } else if (outerNodeName.equalsIgnoreCase("schema")) {
                NodeList nodes = outerNode.getChildNodes();
                for (int k = 0; k < nodes.getLength(); ++k) {
                    schemaNodes.add(nodes.item(k));
                }
            } else {
                return;
            }
            this.NameSpaces.putAll(DOM.getNameSpaces(xsd));
            StringBuffer auxSchemas = new StringBuffer();
            for (i = 0; i < schemaNodes.size(); ++i) {
                NamedNodeMap attr;
                String schemaLocation;
                schemaNode = (Node)schemaNodes.get(i);
                Node importNode = this.getNode(schemaNode, "import");
                if (importNode == null) continue;
                if (followImports && (schemaLocation = DOM.getAttributeValue(attr = importNode.getAttributes(), "schemaLocation")).length() > 0) {
                    this.importSchemas(schemaLocation, auxSchemas);
                }
                Node iSchema = importNode.getParentNode();
                iSchema.removeChild(importNode);
            }
            for (i = 0; i < schemaNodes.size(); ++i) {
                schemaNode = (Node)schemaNodes.get(i);
                xml.append(DOM.getText(schemaNode));
            }
            xml.append(auxSchemas);
        }
        xml.append("</schemas>");
        this.Schema = DOM.getOuterNode(DOM.createDocument(xml.toString())).getChildNodes();
        if (parseWSDL) {
            this.parseWSDL();
        }
    }

    private void importSchemas(String schemaLocation, StringBuffer auxSchemas) {
        if (schemaLocation == null || schemaLocation.length() == 0) {
            return;
        }
        Response response = new Request(schemaLocation).getResponse();
        String txt = response.getText();
        Document doc = DOM.createDocument(txt);
        if (doc != null) {
            this.NameSpaces.putAll(DOM.getNameSpaces(doc));
            NodeList Schema = doc.getChildNodes();
            Schema = this.getChildNodes(Schema, "schema");
            for (int i = 0; i < Schema.getLength(); ++i) {
                Node node = this.getNode(Schema.item(i), "import");
                if (node == null) continue;
                NamedNodeMap attr = node.getAttributes();
                schemaLocation = DOM.getAttributeValue(attr, "schemaLocation");
                if (schemaLocation.length() > 0) {
                    this.importSchemas(schemaLocation, auxSchemas);
                }
                Node iSchema = node.getParentNode();
                iSchema.removeChild(node);
            }
            auxSchemas.append(DOM.getText(Schema));
        }
    }

    private ArrayList<Element> getElement(String ElementName) {
        NodeList schemas = this.getSchema();
        for (int i = 0; i < schemas.getLength(); ++i) {
            Node elementNode = schemas.item(i);
            String elementName = DOM.getAttributeValue(elementNode, "name");
            String elementType = this.stripNameSpace(elementNode.getNodeName());
            if (!elementName.equals(ElementName) || !elementType.equalsIgnoreCase("element")) continue;
            ArrayList<Element> elements = new ArrayList<Element>();
            if (!DOM.hasChildren(elementNode)) {
                Element element = new Element(elementNode);
                this.decomposeComplexType(this.stripNameSpace(element.Name), element);
                elements.add(element);
            } else {
                Element element = new Element(elementNode);
                this.decomposeComplexType(this.stripNameSpace(element.Name), element);
                for (Object obj : element.children) {
                    if (!(obj instanceof Element)) continue;
                    elements.add((Element)obj);
                }
            }
            return elements;
        }
        return null;
    }

    private void decomposeComplexType(String ElementName, Element parentElement) {
        if (this.knownTypes.containsKey(ElementName)) {
            parentElement.addElement(this.knownTypes.get(ElementName));
            return;
        }
        NodeList Schemas = this.getSchema();
        for (int i = 0; i < Schemas.getLength(); ++i) {
            Node node = Schemas.item(i);
            String typeName = DOM.getAttributeValue(node, "name");
            if (!typeName.equals(ElementName)) continue;
            this.parseComplexNode(node, ElementName, parentElement);
        }
    }

    private void parseComplexNode(Node node, String ElementName, Element parentElement) {
        String nodeName = this.stripNameSpace(node.getNodeName().toLowerCase());
        if (nodeName.equals("element")) {
            if (!DOM.hasChildren(node)) {
                Element Element2 = new Element(node);
                if (Element2.IsComplex) {
                    this.decomposeComplexType(this.stripNameSpace(Element2.Type), parentElement);
                }
            } else {
                NodeList complexTypes = node.getChildNodes();
                for (Node complexNode : DOM.getNodes(complexTypes)) {
                    this.parseComplexNode(complexNode, ElementName, parentElement);
                }
            }
        } else if (nodeName.equals("complextype")) {
            NodeList complexTypes = node.getChildNodes();
            for (Node complexNode : DOM.getNodes(complexTypes)) {
                Element Element3;
                String complexType = this.stripNameSpace(complexNode.getNodeName());
                if (complexType.equalsIgnoreCase("sequence")) {
                    NodeList sequenceNodes = complexNode.getChildNodes();
                    for (Node sequenceNode : DOM.getNodes(sequenceNodes)) {
                        if (!this.stripNameSpace(sequenceNode.getNodeName()).equals("element")) continue;
                        Element3 = new Element(sequenceNode);
                        parentElement.addElement(Element3);
                        if (Element3.IsComplex) {
                            this.decomposeComplexType(this.stripNameSpace(Element3.Type), Element3);
                            continue;
                        }
                        this.knownTypes.put(ElementName, Element3);
                    }
                    continue;
                }
                if (complexType.equalsIgnoreCase("attribute")) {
                    Element Element4 = new Element(complexNode);
                    parentElement.addElement(Element4);
                    if (Element4.IsComplex) {
                        this.decomposeComplexType(this.stripNameSpace(Element4.Type), Element4);
                        continue;
                    }
                    this.knownTypes.put(ElementName, Element4);
                    continue;
                }
                if (complexType.equalsIgnoreCase("attributeGroup")) {
                    for (Element Element5 : this.getAttributes(complexNode)) {
                        parentElement.addElement(Element5);
                    }
                    continue;
                }
                if (complexType.equalsIgnoreCase("simpleContent") || complexType.equalsIgnoreCase("complexContent")) {
                    NodeList childNodes = complexNode.getChildNodes();
                    for (Node childNode : DOM.getNodes(childNodes)) {
                        if (!this.stripNameSpace(childNode.getNodeName()).equalsIgnoreCase("extension")) continue;
                        Element3 = new Element(ElementName, DOM.getAttributeValue(childNode, "base"));
                        if (Element3.IsComplex) {
                            // empty if block
                        }
                        this.knownTypes.put(ElementName, Element3);
                        Iterator<Element> it = this.getAttributes(childNode).iterator();
                        while (it.hasNext()) {
                            Element3.addElement(it.next());
                        }
                        parentElement.addElement(Element3);
                    }
                    continue;
                }
                if (complexType.equalsIgnoreCase("choice")) {
                    Choices choices = new Choices();
                    NodeList choiceNodes = complexNode.getChildNodes();
                    for (int k = 0; k < choiceNodes.getLength(); ++k) {
                        Node choiceNode = choiceNodes.item(k);
                        if (!this.stripNameSpace(choiceNode.getNodeName()).equalsIgnoreCase("element")) continue;
                        Element Element6 = new Element(choiceNode);
                        choices.addChoice(Element6);
                        if (Element6.IsComplex) {
                            this.decomposeComplexType(this.stripNameSpace(Element6.Type), Element6);
                            continue;
                        }
                        this.knownTypes.put(ElementName, Element6);
                    }
                    parentElement.addChoices(choices);
                    continue;
                }
                if (!complexType.equalsIgnoreCase("annotation")) continue;
            }
        } else if (nodeName.equals("simpletype")) {
            for (Node restriction : DOM.getElementsByTagName("restriction", node)) {
                Node[] enumeration;
                String base = DOM.getAttributeValue(restriction, "base");
                if (!this.isElementComplex(base)) {
                    parentElement.Type = this.stripNameSpace(base);
                    parentElement.IsComplex = false;
                }
                if ((enumeration = DOM.getElementsByTagName("enumeration", restriction)).length <= 0) continue;
                Options options = new Options();
                for (Node valueNode : enumeration) {
                    String value = DOM.getAttributeValue(valueNode, "value");
                    if (value.length() <= 0) continue;
                    options.addOption(value);
                }
                parentElement.addOptions(options);
            }
        } else if (nodeName.equals("attributegroup")) {
            for (Element Element7 : this.getAttributes(node)) {
                parentElement.addElement(Element7);
            }
        } else {
            System.out.println("Unsupported element type: " + nodeName);
        }
    }

    private ArrayList<Element> getAttributes(Node attributeGroup) {
        ArrayList<Element> elements;
        block5: {
            String ref;
            String name;
            block4: {
                elements = new ArrayList<Element>();
                name = DOM.getAttributeValue(attributeGroup, "name");
                ref = DOM.getAttributeValue(attributeGroup, "ref");
                if (name.length() <= 0) break block4;
                NodeList attributes = attributeGroup.getChildNodes();
                for (Node attribute : DOM.getNodes(attributes)) {
                    String attributeNodeName = this.stripNameSpace(attribute.getNodeName());
                    if (attributeNodeName.equalsIgnoreCase("attribute")) {
                        Element element = new Element(attribute);
                        elements.add(element);
                        if (!element.IsComplex) continue;
                        this.decomposeComplexType(this.stripNameSpace(element.Type), element);
                        continue;
                    }
                    if (!attributeNodeName.equalsIgnoreCase("attributeGroup")) continue;
                    Iterator<Element> it = this.getAttributes(attribute).iterator();
                    while (it.hasNext()) {
                        elements.add(it.next());
                    }
                }
                break block5;
            }
            if (ref.length() <= 0) break block5;
            Element temp = new Element("", name);
            this.decomposeComplexType(this.stripNameSpace(ref), temp);
            for (Object obj : temp.children) {
                if (!(obj instanceof Element)) continue;
                elements.add((Element)obj);
            }
        }
        return elements;
    }

    private ArrayList<Element> findImplementations(String base) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList Schemas = this.getSchema();
        for (int i = 0; i < Schemas.getLength(); ++i) {
            boolean isAbstract;
            Node node = Schemas.item(i);
            String typeName = DOM.getAttributeValue(node, "name");
            String nodeName = this.stripNameSpace(node.getNodeName().toLowerCase());
            if (!nodeName.equals("complextype") || (isAbstract = DOM.getAttributeValue(node, "abstract").equalsIgnoreCase("true"))) continue;
            NodeList complexTypes = node.getChildNodes();
            for (Node complexNode : DOM.getNodes(complexTypes)) {
                String complexType = this.stripNameSpace(complexNode.getNodeName());
                if (!complexType.equalsIgnoreCase("simpleContent") && !complexType.equalsIgnoreCase("complexContent")) continue;
                NodeList childNodes = complexNode.getChildNodes();
                for (Node childNode : DOM.getNodes(childNodes)) {
                    if (!this.stripNameSpace(childNode.getNodeName()).equalsIgnoreCase("extension") || !DOM.getAttributeValue(childNode, "base").equals(base)) continue;
                    System.out.println("\t" + typeName);
                    elements.add(new Element(node));
                }
            }
        }
        return elements;
    }

    public Service[] getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Node serviceNode : DOM.getNodes(this.ssd.getElementsByTagName("service"))) {
            services.add(new Service(serviceNode));
        }
        if (services.isEmpty()) {
            return null;
        }
        return services.toArray(new Service[services.size()]);
    }

    public String[] getListOfServices() {
        Service[] services = this.getServices();
        if (services == null) {
            return null;
        }
        String[] arr = new String[services.length];
        for (int i = 0; i < services.length; ++i) {
            arr[i] = services[i].getName();
        }
        return arr;
    }

    public Service getService(String ServiceName) {
        if (ServiceName == null) {
            ServiceName = "";
        }
        if ((ServiceName = ServiceName.trim()).equals("")) {
            return this.getService(0);
        }
        Service[] arrServices = this.getServices();
        if (arrServices != null) {
            for (int i = 0; i < arrServices.length; ++i) {
                if (!arrServices[i].equals(ServiceName)) continue;
                return arrServices[i];
            }
        }
        return null;
    }

    public Service getService(int i) {
        Service[] arrServices = this.getServices();
        if (arrServices != null && i < arrServices.length) {
            return arrServices[i];
        }
        return null;
    }

    public Method getMethod(String ServiceName, String MethodName) {
        Service service = this.getService(ServiceName);
        if (service != null) {
            return service.getMethod(MethodName);
        }
        return null;
    }

    public Method getMethod(String MethodName) {
        Service Service2 = this.getService(0);
        if (Service2 != null) {
            return Service2.getMethod(MethodName);
        }
        return null;
    }

    public String[] getListOfMethods(String ServiceName) {
        Method[] methods;
        Service service = this.getService(ServiceName);
        if (service != null && (methods = service.getMethods()) != null) {
            String[] arr = new String[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                arr[i] = methods[i].getName();
            }
            return arr;
        }
        return null;
    }

    private NodeList getChildNodes(NodeList ParentNodes, String NodeName) {
        for (int i = 0; i < ParentNodes.getLength(); ++i) {
            Node node = ParentNodes.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().endsWith(NodeName)) continue;
            return node.getChildNodes();
        }
        return null;
    }

    private Node getNode(Node node, String NodeName) {
        if (node.getNodeType() == 1 && node.getNodeName().endsWith(NodeName)) {
            return node;
        }
        return null;
    }

    private String stripNameSpace(String str) {
        if (str.contains(":")) {
            str = str.substring(str.lastIndexOf(":") + 1);
        }
        return str;
    }

    private boolean contains(String str, String ch) {
        return string.contains(str, ch, true);
    }

    private class Choices {
        private ArrayList<Element> choices = new ArrayList();

        public void addChoice(Element choice) {
            this.choices.add(choice);
        }

        public String toString() {
            StringBuffer xml = new StringBuffer();
            if (!this.choices.isEmpty()) {
                xml.append("<options>");
                Iterator<Element> it = this.choices.iterator();
                while (it.hasNext()) {
                    xml.append("<option>");
                    xml.append(it.next().toString());
                    xml.append("</option>");
                }
                xml.append("</options>");
            }
            return xml.toString();
        }
    }

    private class Options {
        private ArrayList<String> options = new ArrayList();

        public void addOption(String option) {
            this.options.add(option);
        }

        public String toString() {
            StringBuffer xml = new StringBuffer();
            if (!this.options.isEmpty()) {
                xml.append("<options>");
                for (String option : this.options) {
                    xml.append("    <option value=\"" + option + "\">" + option + "</option>" + WSDL.this.vbCrLf);
                }
                xml.append("</options>");
            }
            return xml.toString();
        }
    }

    private class Element {
        public String Name;
        public String Type;
        public boolean IsNillable = false;
        public boolean IsComplex = false;
        public String minOccurs = "0";
        public String maxOccurs = "1";
        public boolean IsAttribute = false;
        private ArrayList<Object> children = new ArrayList();

        public Element(String Name2, String Type2) {
            this.Name = Name2;
            this.Type = WSDL.this.stripNameSpace(Type2);
            this.IsComplex = WSDL.this.isElementComplex(Type2);
        }

        public Element(Node node) {
            String nodeName = WSDL.this.stripNameSpace(node.getNodeName());
            NamedNodeMap attr = node.getAttributes();
            this.Name = DOM.getAttributeValue(attr, "name");
            this.Type = DOM.getAttributeValue(attr, "type");
            this.IsNillable = WSDL.this.isElementNillable(DOM.getAttributeValue(attr, "nillable"));
            this.IsComplex = WSDL.this.isElementComplex(this.Type);
            this.minOccurs = DOM.getAttributeValue(attr, "minOccurs");
            this.maxOccurs = DOM.getAttributeValue(attr, "maxOccurs");
            if (this.minOccurs.length() == 0) {
                this.minOccurs = "0";
            }
            if (this.maxOccurs.length() == 0) {
                this.maxOccurs = "1";
            }
            this.Type = WSDL.this.stripNameSpace(this.Type);
            String elementRef = DOM.getAttributeValue(attr, "ref");
            if (elementRef.length() > 0) {
                this.Name = elementRef;
            }
            if (nodeName.equalsIgnoreCase("attribute")) {
                this.IsAttribute = true;
                this.IsNillable = DOM.getAttributeValue(attr, "use").equalsIgnoreCase("optional");
            }
        }

        public void addElement(Element element) {
            boolean addElement = true;
            for (Object child : this.children) {
                if (!(child instanceof Element)) continue;
                Element e = (Element)child;
                if (!e.Name.equals(element.Name) || !e.Type.equals(element.Type)) continue;
                addElement = false;
            }
            if (addElement) {
                this.children.add(element);
            }
        }

        public void addChoices(Choices choices) {
            this.children.add(choices);
        }

        public void addOptions(Options options) {
            this.children.add(options);
        }

        public String toString() {
            StringBuffer xml = new StringBuffer();
            xml.append("   <parameter name=\"" + this.Name + "\" " + "type=\"" + this.Type + "\" " + "minOccurs=\"" + this.minOccurs + "\" " + "maxOccurs=\"" + this.maxOccurs + "\" " + "isattribute=\"" + this.IsAttribute + "\" " + "iscomplex=\"" + this.IsComplex + "\" " + "isnillable=\"" + this.IsNillable + "\">" + WSDL.this.vbCrLf);
            Iterator<Object> it = this.children.iterator();
            while (it.hasNext()) {
                xml.append(it.next().toString());
            }
            xml.append("   </parameter>" + WSDL.this.vbCrLf);
            return xml.toString();
        }
    }

    private class Message {
        public String Input;
        public String Output;
        public String Documentation = null;

        private Message() {
        }
    }

    private class Binding {
        public String Operation;
        public String SoapAction;
        public String Style;
        public String Name;
        public String Type;

        private Binding() {
        }
    }

    private class Port {
        public String Name;
        public String Binding;
        public String Address;

        private Port() {
        }
    }
}

