/*
 * Decompiled with CFR 0.152.
 */
package javaxt.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javaxt.http.Request;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOM {
    private DOM() {
    }

    public static Document createDocument(URL url) {
        return new Request(url).getResponse().getXML();
    }

    public static Document createDocument(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return DOM.createDocument(new FileInputStream(file));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Document createDocument(String xml) {
        xml = xml.trim();
        String encoding = "UTF-8";
        try {
            String xmlHeader = xml.substring(xml.indexOf("<?"), xml.indexOf("?>"));
            if (xmlHeader.contains(" encoding")) {
                encoding = xmlHeader.substring(xmlHeader.indexOf(" encoding") + " encoding".length());
                encoding = encoding.substring(encoding.indexOf("=") + 1);
                while (encoding.substring(0, 1).equals(" ")) {
                    encoding = encoding.substring(1);
                }
                if (encoding.substring(0, 1).equals("\"")) {
                    encoding = encoding.substring(1);
                    encoding = encoding.substring(0, encoding.indexOf("\"")).trim();
                } else {
                    encoding = encoding.substring(0, encoding.indexOf(" ")).trim();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DOM.createDocument(xml, encoding);
    }

    public static Document createDocument(String xml, String charsetName) {
        xml = xml.trim();
        try {
            return DOM.createDocument(new ByteArrayInputStream(xml.getBytes(charsetName)));
        }
        catch (Exception e) {
            return DOM.createDocument(new ByteArrayInputStream(xml.getBytes()));
        }
    }

    public static Document createDocument(InputStream is) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Node getOuterNode(Document xml) {
        if (xml == null) {
            return null;
        }
        NodeList OuterNodes = xml.getChildNodes();
        for (int i = 0; i < OuterNodes.getLength(); ++i) {
            if (OuterNodes.item(i).getNodeType() != 1) continue;
            return OuterNodes.item(i);
        }
        return null;
    }

    public static boolean equals(Document xml, Document xml2) {
        if (xml == null && xml2 == null) {
            return true;
        }
        if (xml != null && xml2 == null) {
            return false;
        }
        if (xml == null && xml2 != null) {
            return false;
        }
        return DOM.getText(xml).equals(DOM.getText(xml2));
    }

    public static String getText(Document xml) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            DOMSource source = new DOMSource(xml);
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bas);
            transformer.transform(source, result);
            String encoding = xml.getXmlEncoding();
            if (encoding != null) {
                return bas.toString(encoding);
            }
            return bas.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getText(NodeList nodeList) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ret.append(DOM.getText(nodeList.item(i)));
        }
        return ret.toString();
    }

    public static String getText(Node node) {
        StringBuffer ret = new StringBuffer();
        if (node.getNodeType() == 1) {
            if (DOM.hasChildren(node)) {
                ret.append(DOM.getNodeValue(node));
            } else {
                ret.append("<" + node.getNodeName() + DOM.getAttributes(node) + ">");
                ret.append(DOM.getNodeValue(node));
                ret.append("</" + node.getNodeName() + ">");
            }
        }
        return ret.toString();
    }

    private static String getAttributes(Node node) {
        if (node == null) {
            return "";
        }
        NamedNodeMap attr = node.getAttributes();
        String Attributes2 = "";
        if (attr != null) {
            for (int j = 0; j < attr.getLength(); ++j) {
                String name = attr.item(j).getNodeName();
                String value = attr.item(j).getTextContent();
                if (value == null) {
                    value = attr.item(j).getNodeValue();
                }
                if (value == null) {
                    value = "";
                }
                Attributes2 = Attributes2 + " " + name + "=\"" + value + "\"";
            }
        }
        return Attributes2;
    }

    public static boolean hasChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static String getAttributeValue(NamedNodeMap attrCollection, String attrName) {
        if (attrCollection != null) {
            for (int i = 0; i < attrCollection.getLength(); ++i) {
                Node node = attrCollection.item(i);
                if (!node.getNodeName().equalsIgnoreCase(attrName)) continue;
                return node.getNodeValue();
            }
        }
        return "";
    }

    public static String getAttributeValue(Node Node2, String AttributeName) {
        return DOM.getAttributeValue(Node2.getAttributes(), AttributeName);
    }

    public static String getNodeValue(Node node) {
        String nodeValue = "";
        if (DOM.hasChildren(node)) {
            StringBuffer xmlTree = new StringBuffer();
            DOM.traverse(node, xmlTree);
            nodeValue = xmlTree.toString();
        } else {
            nodeValue = node.getTextContent();
        }
        if (nodeValue == null) {
            return "";
        }
        return nodeValue;
    }

    private static void traverse(Node tree, StringBuffer xmlTree) {
        if (tree.getNodeType() == 1) {
            String Attributes2 = DOM.getAttributes(tree);
            xmlTree.append("<" + tree.getNodeName() + Attributes2 + ">");
            if (DOM.hasChildren(tree)) {
                NodeList xmlNodeList = tree.getChildNodes();
                for (int i = 0; i < xmlNodeList.getLength(); ++i) {
                    DOM.traverse(xmlNodeList.item(i), xmlTree);
                }
            } else {
                String nodeValue = tree.getTextContent();
                if (nodeValue == null) {
                    nodeValue = "";
                }
                xmlTree.append(nodeValue);
            }
            xmlTree.append("</" + tree.getNodeName() + ">");
        }
    }

    public static NamedNodeMap getDocumentAttributes(Document xml) {
        NodeList Definitions = xml.getChildNodes();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            if (Definitions.item(i).getNodeType() != 1) continue;
            return Definitions.item(i).getAttributes();
        }
        return null;
    }

    public static String getTargetNameSpace(Document xml) {
        NamedNodeMap attr = DOM.getDocumentAttributes(xml);
        return DOM.getAttributeValue(attr, "targetNamespace");
    }

    public static HashMap<String, String> getNameSpaces(Document xml) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        DOM.getNameSpaces(DOM.getOuterNode(xml), namespaces);
        return namespaces;
    }

    private static void getNameSpaces(Node node, HashMap<String, String> namespaces) {
        if (node.getNodeType() == 1) {
            NamedNodeMap attr = node.getAttributes();
            if (attr != null) {
                for (int j = 0; j < attr.getLength(); ++j) {
                    String name = attr.item(j).getNodeName();
                    String value = attr.item(j).getTextContent();
                    if (!name.startsWith("xmlns:")) continue;
                    name = name.substring(6);
                    namespaces.put(name, value);
                }
            }
            if (DOM.hasChildren(node)) {
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    DOM.getNameSpaces(childNodes.item(i), namespaces);
                }
            }
        }
    }

    public static Node[] getElementsByTagName(String tagName, Document xml) {
        return DOM.getElementsByTagName(tagName, DOM.getOuterNode(xml));
    }

    public static Node[] getElementsByTagName(String tagName, Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        DOM.getElementsByTagName(tagName, node, nodes);
        return nodes.toArray(new Node[nodes.size()]);
    }

    private static void getElementsByTagName(String tagName, Node node, ArrayList<Node> nodes) {
        if (node != null && node.getNodeType() == 1) {
            String nodeName = node.getNodeName().trim();
            if (nodeName.contains(":") && !tagName.contains(":")) {
                nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
            }
            if (nodeName.equalsIgnoreCase(tagName)) {
                nodes.add(node);
            }
            if (DOM.hasChildren(node)) {
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    DOM.getElementsByTagName(tagName, childNodes.item(i), nodes);
                }
            }
        }
    }

    public static Node[] getNodes(NodeList nodeList) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            nodes.add(node);
        }
        return nodes.toArray(new Node[nodes.size()]);
    }
}

