/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.detection;

import edu.geophys.commons.detection.SonoViewPick;
import edu.geophys.commons.util.DateTimeUtil;
import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.Color;
import java.io.File;

public abstract class AbstractDetection
implements Comparable<AbstractDetection> {
    private File source = null;

    public SonoViewPick getPick() {
        return null;
    }

    public abstract long getIndexTimeMs();

    public abstract long getStartTimeMs();

    public abstract long getDurationMs();

    public abstract long getEndTimeMs();

    @Override
    public int compareTo(AbstractDetection abstractDetection) {
        long l;
        long l2 = this.getIndexTimeMs();
        if (l2 > (l = abstractDetection.getIndexTimeMs())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    public abstract String getLabel();

    public String toString() {
        return this.getClass().getSimpleName() + " at " + DateTimeUtil.formatDateTimeISO(this.getIndexTimeMs());
    }

    @XmlTransient
    public File getSource() {
        return this.source;
    }

    public void setSource(File file) {
        this.source = file;
    }

    @XmlTransient
    public boolean isBulletinEntry() {
        return this.source != null;
    }

    public abstract Color getColor();

    public abstract String getComment();
}

