/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.detection;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.interfaces.HasOnsetMarkers;
import edu.geophys.commons.detection.interfaces.HasOrigin;
import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.commons.util.CsvReader;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LocalMagnitude;
import edu.geophys.commons.util.LogUtil;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BulletinDetection
extends AbstractDetection
implements HasOrigin,
HasOnsetMarkers {
    private static final float MAGNITUDE_THRESHOLD = -1.0f;
    private static final float DISTANCE_THRESHOLD = 50.0f;
    private static final double AMPLITUDE_THRESHOLD;
    private static final TauP_Time TIMETOOL;
    private static final String TAUP_MODEL = "iasp91";
    static final String[] PHASES;
    private static final Color COLOR;
    private boolean initialized = false;
    private double distanceNearestStationDeg = -1.0;
    private Map<String, Long> markers;
    private long firstMarkerMs = 0L;
    private long lastMarkerMs = 0L;
    private String nearestStation = "";
    private final long sourceTime;
    private final double lat;
    private final double lon;
    private final double depthKm;
    private final double magnitude;
    private final String region;

    public BulletinDetection(long l, double d, double d2, double d3, double d4, String string) {
        this.sourceTime = l;
        this.lat = d;
        this.lon = d2;
        this.depthKm = d3;
        this.magnitude = d4;
        this.region = string;
    }

    @Override
    public long getIndexTimeMs() {
        if (!this.initialized) {
            this.init();
        }
        return this.firstMarkerMs;
    }

    @Override
    public long getStartTimeMs() {
        if (!this.initialized) {
            this.init();
        }
        return this.firstMarkerMs;
    }

    @Override
    public long getDurationMs() {
        return this.lastMarkerMs - this.firstMarkerMs;
    }

    @Override
    public long getEndTimeMs() {
        if (!this.initialized) {
            this.init();
        }
        return this.lastMarkerMs;
    }

    @Override
    public String getLabel() {
        if (!this.initialized) {
            this.init();
        }
        return String.format("M%1$3.1f ", this.magnitude) + this.region;
    }

    @Override
    public Color getColor() {
        return COLOR;
    }

    @Override
    public String getComment() {
        return this.region;
    }

    public void init() {
        double d;
        TIMETOOL.clearPhases();
        this.markers = new HashMap<String, Long>();
        this.firstMarkerMs = this.sourceTime;
        this.lastMarkerMs = this.sourceTime;
        this.initialized = true;
        double d2 = d = this.depthKm > 0.0 ? this.depthKm : 0.0;
        if (d != TIMETOOL.getSourceDepth()) {
            TIMETOOL.setSourceDepth(d);
        }
        CampaignKnowledge.MapPoint mapPoint = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getReferencePoint();
        boolean bl = false;
        for (SNS sNS : SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS()) {
            List list;
            Site site = sNS.getAllSitesCenterFirst().get(0);
            double d3 = site.getXOffsetKm();
            double d4 = site.getYOffsetKm();
            CoordinateUtil.AbsoluteResult absoluteResult = CoordinateUtil.convertRelativeToAbsolute(mapPoint.getLatitude(), mapPoint.getLongitude(), d3, d4);
            double d5 = CoordinateUtil.kmToLat(CoordinateUtil.getKmHaversine(this.lat, this.lon, absoluteResult.latitude, absoluteResult.longitude));
            try {
                TIMETOOL.calculate(d5);
            }
            catch (TauModelException tauModelException) {
                LogUtil.error(BulletinDetection.class, "Could not calculate onset for " + sNS.getID() + ":" + DateTimeUtil.formatDateTimeISO(this.sourceTime) + " " + this.region);
                continue;
            }
            if (this.distanceNearestStationDeg < 0.0 || d5 < this.distanceNearestStationDeg) {
                this.distanceNearestStationDeg = d5;
            }
            if ((list = TIMETOOL.getArrivals()).isEmpty()) {
                LogUtil.error(BulletinDetection.class, "Could find valid onset for " + sNS.getID() + ":" + DateTimeUtil.formatDateTimeISO(this.sourceTime) + " " + this.region);
                continue;
            }
            double d6 = -1.0;
            for (Arrival arrival : TIMETOOL.getArrivals()) {
                if (!(d6 < 0.0) && !(arrival.getTime() < d6)) continue;
                d6 = arrival.getTime();
            }
            long l = this.sourceTime + (long)(d6 * 1000.0);
            this.markers.put(sNS.getID(), l);
            if (!bl) {
                this.firstMarkerMs = l;
                this.lastMarkerMs = l;
                this.nearestStation = sNS.getID();
                bl = true;
                continue;
            }
            if (l < this.firstMarkerMs) {
                this.firstMarkerMs = l;
                this.nearestStation = sNS.getID();
            }
            if (l <= this.lastMarkerMs) continue;
            this.lastMarkerMs = l;
        }
    }

    public static ArrayList<BulletinDetection> readFromFdsnFile(File file) {
        ArrayList<BulletinDetection> arrayList = new ArrayList<BulletinDetection>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            CsvReader csvReader = new CsvReader();
            csvReader.setSeparator("\\|");
            csvReader.setQuote("");
            csvReader.setComment("#");
            while ((string = bufferedReader.readLine()) != null) {
                ++n;
                String[] stringArray = csvReader.parse(string);
                if (stringArray.length != 13) continue;
                try {
                    BulletinDetection bulletinDetection = new BulletinDetection(DateTimeUtil.parseDateTime(stringArray[1]).getTimeInMillis(), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Double.parseDouble(stringArray[4]), Double.parseDouble(stringArray[10]), stringArray[12]);
                    bulletinDetection.setSource(file);
                    bulletinDetection.init();
                    if (bulletinDetection.isAboveMagnitudeThreshold()) {
                        arrayList.add(bulletinDetection);
                        continue;
                    }
                    LogUtil.info(BulletinDetection.class, "Event below magnitude/distance threshold: " + String.format("M%1$3.1f ", bulletinDetection.magnitude) + bulletinDetection.region + " @ " + String.format("%1$.0fkm", CoordinateUtil.degToKm(bulletinDetection.distanceNearestStationDeg)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    LogUtil.error(BulletinDetection.class, "Invalid bulletin entry in " + file.getAbsolutePath() + ":" + n);
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            LogUtil.error(BulletinDetection.class, exception.toString());
            return null;
        }
        return arrayList;
    }

    private boolean isAboveMagnitudeThreshold() {
        LocalMagnitude localMagnitude = new LocalMagnitude();
        double d = CoordinateUtil.degToKm(this.distanceNearestStationDeg);
        float f = localMagnitude.calcAmplitude((float)d, (float)this.magnitude);
        return (double)f > AMPLITUDE_THRESHOLD;
    }

    @Override
    public Long getMarker(String string) {
        return this.markers.get(string);
    }

    @Override
    public double getLatitude() {
        return this.lat;
    }

    @Override
    public double getLongitude() {
        return this.lon;
    }

    @Override
    public double getMagnitude() {
        return this.magnitude;
    }

    @Override
    public double getDepthKm() {
        return this.depthKm;
    }

    @Override
    public long getSourceTimeMs() {
        return this.sourceTime;
    }

    @Override
    public String getNearestStation() {
        return this.nearestStation;
    }

    static {
        TauP_Time tauP_Time;
        PHASES = new String[]{"p", "P", "Pdiff", "PKP"};
        LocalMagnitude localMagnitude = new LocalMagnitude();
        AMPLITUDE_THRESHOLD = localMagnitude.calcAmplitude(50.0f, -1.0f);
        try {
            tauP_Time = new TauP_Time(TAUP_MODEL);
        }
        catch (TauModelException tauModelException) {
            tauP_Time = new TauP_Time();
            LogUtil.error(BulletinDetection.class, "Could not load \"iasp91\" model, using " + tauP_Time.getTauModelName());
        }
        TIMETOOL = tauP_Time;
        try {
            TIMETOOL.setPhaseNames(PHASES);
        }
        catch (TauModelException tauModelException) {
            LogUtil.error(BulletinDetection.class, "Could not load set phases for " + tauP_Time.getTauModelName());
        }
        COLOR = Color.decode("#ef18fe");
    }
}

