/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.detection;

import edu.geophys.commons.detection.SonoViewDetection;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.JAXBSerializable;
import edu.geophys.commons.util.JAXBUtil;
import edu.geophys.commons.util.LogUtil;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.util.ArrayList;

@XmlRootElement(name="detectionXml")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DetectionXmlFile
implements JAXBSerializable {
    private static final long serialVersionUID = -4195357604282294894L;
    public String DEFAULT_CONFIGFILE = SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getAbsolutePath() + File.separator + "detection.xml";
    private static String DEFAULT_VERSION = "1.0";
    private String detectionXmlVersion = DEFAULT_VERSION;
    private ArrayList<SonoViewDetection> detections = new ArrayList();

    @XmlElement
    public String getDetectionXmlVersion() {
        return this.detectionXmlVersion;
    }

    public void setDetectionXmlVersion(String string) {
        this.detectionXmlVersion = string;
    }

    @XmlElementWrapper(name="detections")
    @XmlElement(name="detection")
    public ArrayList<SonoViewDetection> getDetections() {
        return this.detections;
    }

    public void setDetections(ArrayList<SonoViewDetection> arrayList) {
        this.detections = arrayList;
    }

    private final void shallowCopyFrom(DetectionXmlFile detectionXmlFile) {
        this.detectionXmlVersion = detectionXmlFile.detectionXmlVersion;
        this.detections = detectionXmlFile.detections;
    }

    public void load() {
        try {
            DetectionXmlFile detectionXmlFile = (DetectionXmlFile)JAXBUtil.readXML(new File(this.DEFAULT_CONFIGFILE), this.getClass());
            this.shallowCopyFrom(detectionXmlFile);
        }
        catch (Exception exception) {
            LogUtil.info(this.getClass(), "Failed to load detection.xml file. Creating new file.", false);
        }
    }

    public void store() {
        try {
            JAXBUtil.writeXML(this, new File(this.DEFAULT_CONFIGFILE));
        }
        catch (Exception exception) {
            LogUtil.fatal(this.getClass(), "Failed to store detection.xml file", exception);
        }
    }
}

