/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.detection;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EventClass
implements Comparable<EventClass> {
    private static Map<String, EventClass> map;
    private static final Color COLOR1;
    public final String NAME;
    public final String SHORT_NAME;
    public final Color COLOR;
    public final int NUMBER;

    private EventClass(String string, String string2, Color color, int n) {
        this.NAME = string;
        this.SHORT_NAME = string2;
        this.COLOR = color;
        this.NUMBER = n;
    }

    private static void addToMap(Map<String, EventClass> map, String string, String string2, Color color, int n) {
        map.put(string2, new EventClass(string, string2, color, n));
    }

    public static EventClass get(String string) {
        EventClass eventClass = map.get(string);
        return eventClass != null ? eventClass : EventClass.get("");
    }

    public static List<EventClass> getEventClassesSorted() {
        LinkedList<EventClass> linkedList = new LinkedList<EventClass>();
        for (EventClass eventClass : map.values()) {
            linkedList.add(eventClass);
        }
        Collections.sort(linkedList);
        return linkedList;
    }

    @Override
    public int compareTo(EventClass eventClass) {
        if (this.NUMBER < eventClass.NUMBER) {
            return -1;
        }
        if (this.NUMBER > eventClass.NUMBER) {
            return 1;
        }
        return 0;
    }

    static {
        COLOR1 = Color.decode("#ef18fe");
        HashMap<String, EventClass> hashMap = new HashMap<String, EventClass>();
        EventClass.addToMap(hashMap, "undefined", "", Color.decode("#000000"), 0);
        EventClass.addToMap(hashMap, "geotechnical fracture", "fracture", COLOR1, 1);
        EventClass.addToMap(hashMap, "close range earthquake", "close", COLOR1, 2);
        EventClass.addToMap(hashMap, "local earthquake", "local", COLOR1, 3);
        EventClass.addToMap(hashMap, "regional Pn/Pg", "regional", COLOR1, 4);
        EventClass.addToMap(hashMap, "teleseismic P/PKP", "teleseismic", COLOR1, 5);
        EventClass.addToMap(hashMap, "unspecified noise burst", "noise", Color.decode("#686868"), 6);
        EventClass.addToMap(hashMap, "explosion/quarry blast", "blast", Color.decode("#686868"), 7);
        EventClass.addToMap(hashMap, "acoustic", "acoustic", Color.decode("#686868"), 8);
        map = Collections.unmodifiableMap(hashMap);
    }
}

