/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.detection;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.EventClass;
import edu.geophys.commons.detection.SonoViewPick;
import edu.geophys.commons.detection.TraceViewState;
import edu.geophys.commons.detection.interfaces.HasBoxMarker;
import edu.geophys.commons.detection.interfaces.HasOnsetMarkers;
import edu.geophys.commons.util.JAXBSerializable;
import edu.geophys.commons.util.TimeMsXmlAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@XmlType(name="SonoViewDetection")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SonoViewDetection
extends AbstractDetection
implements JAXBSerializable,
HasBoxMarker,
HasOnsetMarkers {
    private SonoViewPick pick = null;
    private TraceViewState traceViewState = null;
    private long startTimeMs = 0L;
    private long durationMs = 0L;
    private String comment = "";
    private String userID = "";
    private long timeModified = 0L;
    private EventClass eventClass = EventClass.get("");
    public static final int VALID = 0;
    public static final int PICK_NOT_IN_WINDOW = 1;
    public static final int PICK_IS_NULL = 2;
    public static final Map<Integer, String> VALIDITY_MESSAGES;

    public SonoViewDetection() {
    }

    public SonoViewDetection(long l, long l2, SonoViewPick sonoViewPick, String string, long l3, EventClass eventClass, TraceViewState traceViewState) {
        this.pick = sonoViewPick;
        this.startTimeMs = l;
        this.durationMs = l2;
        this.userID = string;
        this.timeModified = l3;
        this.eventClass = eventClass;
        this.traceViewState = traceViewState;
    }

    public SonoViewDetection deepclone() {
        SonoViewDetection sonoViewDetection = new SonoViewDetection();
        sonoViewDetection.pick = this.pick.copy();
        sonoViewDetection.startTimeMs = this.startTimeMs;
        sonoViewDetection.durationMs = this.durationMs;
        sonoViewDetection.comment = this.comment;
        sonoViewDetection.userID = this.userID;
        sonoViewDetection.timeModified = this.timeModified;
        sonoViewDetection.eventClass = this.eventClass;
        sonoViewDetection.setSource(this.getSource());
        sonoViewDetection.setTraceViewState(this.getTraceViewState());
        return sonoViewDetection;
    }

    @Override
    @XmlElement(name="pick", required=true)
    public SonoViewPick getPick() {
        return this.pick;
    }

    public void setPick(SonoViewPick sonoViewPick) {
        this.pick = sonoViewPick;
    }

    @Override
    @XmlElement(name="startTime", required=true)
    @XmlJavaTypeAdapter(type=long.class, value=TimeMsXmlAdapter.class)
    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public void setStartTimeMs(long l) {
        this.startTimeMs = l;
    }

    @Override
    @XmlElement(required=true)
    public long getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(long l) {
        this.durationMs = l;
    }

    @Override
    public long getEndTimeMs() {
        return this.startTimeMs + this.durationMs;
    }

    @XmlElement(required=true)
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    @Override
    @XmlElement(required=true)
    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    @XmlElement(name="timeModified", required=true)
    @XmlJavaTypeAdapter(type=long.class, value=TimeMsXmlAdapter.class)
    public long getTimeModifiedMs() {
        return this.timeModified;
    }

    public void setTimeModifiedMs(long l) {
        this.timeModified = l;
    }

    public EventClass getEventClass() {
        return this.eventClass;
    }

    public void setEventClass(EventClass eventClass) {
        this.eventClass = eventClass;
    }

    @XmlElement(name="eventClass", required=true)
    private String getEventClassJAXB() {
        return this.eventClass.SHORT_NAME;
    }

    private void setEventClassJAXB(String string) {
        this.eventClass = EventClass.get(string);
    }

    @Override
    public String getLabel() {
        Object object = this.eventClass.NAME;
        if (!this.comment.isEmpty()) {
            object = (String)object + "*";
        }
        return object;
    }

    @XmlTransient
    public int isValid() {
        if (this.getPick() == null) {
            return 2;
        }
        if (this.getPick().getTimeMs() < this.getIndexTimeMs() || this.getPick().getTimeMs() > this.getEndTimeMs()) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getIndexTimeMs() {
        if (this.pick != null) {
            return this.pick.getTimeMs();
        }
        return this.getStartTimeMs();
    }

    @Override
    public Color getColor() {
        return this.getEventClass().COLOR;
    }

    @Override
    public Long getMarker(String string) {
        if (this.pick != null) {
            for (String string2 : this.pick.getTraceIDs()) {
                if (!string2.equals(string)) continue;
                return this.pick.getTimeMs();
            }
        }
        return null;
    }

    @XmlElement(name="traceViewState", required=true, nillable=true)
    public TraceViewState getTraceViewState() {
        return this.traceViewState;
    }

    public void setTraceViewState(TraceViewState traceViewState) {
        this.traceViewState = traceViewState;
    }

    static {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "All data is valid");
        hashMap.put(1, "Pick time must be in event window!");
        hashMap.put(2, "No valid pick defined!");
        VALIDITY_MESSAGES = Collections.unmodifiableMap(hashMap);
    }
}

