/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model;

import com.laszlosystems.libresample4j.Resampler;
import edu.geophys.commons.model.AbstractTrace;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import java.io.Serializable;
import java.util.Arrays;

public final class ResamplingTrace
extends AbstractTrace
implements Serializable {
    private static final long serialVersionUID = 9028047736298228516L;
    private final AbstractTrace underlyingTrace;
    private float[] _resampledData = null;

    public ResamplingTrace(AbstractTrace abstractTrace) {
        super(abstractTrace);
        this.underlyingTrace = abstractTrace;
    }

    @Override
    protected final float _getSample(int n) {
        return this._resampledData != null ? this._resampledData[n] : this.underlyingTrace._getSample(n);
    }

    @Override
    protected final float[] _getSamples() {
        return this._resampledData != null ? this._resampledData : this.underlyingTrace._getSamples();
    }

    @Override
    protected final float[] _getSamples(int n, int n2) {
        float[] fArray = this._resampledData != null ? Arrays.copyOfRange(this._resampledData, n, n + n2) : this.underlyingTrace._getSamples(n, n2);
        return fArray;
    }

    public final void resample(float f) {
        if (StrictMath.abs(this.underlyingTrace.getSamplerate() - f) < 0.001f) {
            this._resampledData = null;
            this.setSamplerate(this.underlyingTrace.getSamplerate());
            this.setLength(this.underlyingTrace.getLength());
        } else {
            this._resampledData = this.doResample(f);
            this.setSamplerate(f);
            this.setLength(this._resampledData.length);
        }
    }

    private float[] doResample(float f) {
        float f2 = this.underlyingTrace.getSamplerate();
        LogUtil.debug(this.getClass(), "Resampling trace " + this.getStationID() + " from " + f2 + " to " + f);
        int n = (int)Math.ceil((double)this.underlyingTrace.getLength() * ((double)f / (double)f2));
        float[] fArray = new float[n];
        double d = (double)f / (double)f2;
        Resampler resampler = new Resampler(false, d, d);
        float[] fArray2 = MathUtil.subMeanZeroNaN(this.underlyingTrace.getSamples());
        resampler.process(d, fArray2, 0, this.underlyingTrace.getLength(), true, fArray, 0, fArray.length);
        return fArray;
    }

    private float[] doOldResample(float f) {
        int n = (int)Math.floor((double)this.underlyingTrace.getLength() * ((double)f / (double)this.underlyingTrace.getSamplerate()));
        float[] fArray = new float[n];
        double d = (double)this.underlyingTrace.getSamplerate() / (double)f;
        float f2 = (float)(d - (double)((int)d));
        for (int i = 0; i < n; ++i) {
            int n2 = (int)((double)i * d);
            if (n2 + 1 < this.underlyingTrace.getLength()) {
                float f3 = (float)Math.IEEEremainder(i, f);
                if (f3 < 0.0f) {
                    f3 += f;
                }
                float f4 = f2 * f3 - (float)((int)(f2 * f3));
                fArray[i] = (1.0f - f4) * this.underlyingTrace.getSample(n2) + f4 * this.underlyingTrace.getSample(n2 + 1);
                continue;
            }
            fArray[i] = this.underlyingTrace.getSample(n2);
        }
        return fArray;
    }
}

