/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model;

import edu.geophys.commons.model.Site;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

@XmlType(name="tSNS", propOrder={"north", "west", "east", "center", "aux1", "aux2", "aux3", "aux4", "aux5", "aux6", "enabled", "layermodel", "hypolinePositionJAXB"})
public class SNS
implements Cloneable {
    private Site west = null;
    private Site center = null;
    private Site north = null;
    private Site east = null;
    private Site aux1 = null;
    private Site aux2 = null;
    private Site aux3 = null;
    private Site aux4 = null;
    private Site aux5 = null;
    private Site aux6 = null;
    private boolean enabled = true;
    private String layermodel = "";
    private String id = "";
    private HypolinePosition hypolinePosition = HypolinePosition.UNDEFINED;
    private float fl = 0.0f;
    private float fu = 0.0f;
    private boolean healthy = true;

    public List<Site> getAllSites() {
        ArrayList<Site> arrayList = new ArrayList<Site>();
        for (Site site : new Site[]{this.getNorth(), this.getWest(), this.getEast(), this.getCenter(), this.getAux1(), this.getAux2(), this.getAux3(), this.getAux4(), this.getAux5(), this.getAux6()}) {
            if (site == null) continue;
            arrayList.add(site);
        }
        return arrayList;
    }

    public List<Site> getAllSitesCenterFirst() {
        ArrayList<Site> arrayList = new ArrayList<Site>();
        for (Site site : new Site[]{this.getCenter(), this.getNorth(), this.getWest(), this.getEast(), this.getAux1(), this.getAux2(), this.getAux3(), this.getAux4(), this.getAux5(), this.getAux6()}) {
            if (site == null) continue;
            arrayList.add(site);
        }
        return arrayList;
    }

    public List<Site> getAllSatellites() {
        ArrayList<Site> arrayList = new ArrayList<Site>();
        for (Site site : new Site[]{this.getNorth(), this.getWest(), this.getEast(), this.getAux1(), this.getAux2(), this.getAux3(), this.getAux4(), this.getAux5(), this.getAux6()}) {
            if (site == null) continue;
            arrayList.add(site);
        }
        return arrayList;
    }

    public Site getSite(SNSSiteType sNSSiteType) {
        Site site = null;
        switch (sNSSiteType) {
            case CENTER: {
                site = this.getCenter();
                break;
            }
            case NORTH: {
                site = this.getNorth();
                break;
            }
            case EAST: {
                site = this.getEast();
                break;
            }
            case WEST: {
                site = this.getWest();
                break;
            }
            case AUX1: {
                site = this.getAux1();
                break;
            }
            case AUX2: {
                site = this.getAux2();
                break;
            }
            case AUX3: {
                site = this.getAux3();
                break;
            }
            case AUX4: {
                site = this.getAux4();
                break;
            }
            case AUX5: {
                site = this.getAux5();
                break;
            }
            case AUX6: {
                site = this.getAux6();
                break;
            }
            default: {
                throw new NoSuchElementException();
            }
        }
        return site;
    }

    public void setSite(SNSSiteType sNSSiteType, Site site) {
        switch (sNSSiteType) {
            case CENTER: {
                this.setCenter(site);
                break;
            }
            case NORTH: {
                this.setNorth(site);
                break;
            }
            case EAST: {
                this.setEast(site);
                break;
            }
            case WEST: {
                this.setWest(site);
                break;
            }
            case AUX1: {
                this.setAux1(site);
                break;
            }
            case AUX2: {
                this.setAux2(site);
                break;
            }
            case AUX3: {
                this.setAux3(site);
                break;
            }
            case AUX4: {
                this.setAux4(site);
                break;
            }
            case AUX5: {
                this.setAux5(site);
                break;
            }
            case AUX6: {
                this.setAux6(site);
                break;
            }
            default: {
                throw new NoSuchElementException();
            }
        }
    }

    @XmlAttribute(name="id", required=true)
    public final String getID() {
        return this.id;
    }

    public final void setID(String string) {
        this.id = string;
    }

    @XmlElement(name="west", required=true, nillable=false)
    public final Site getWest() {
        return this.west;
    }

    public final void setWest(Site site) {
        this.west = site;
    }

    @XmlElement(name="north", required=true, nillable=false)
    public final Site getNorth() {
        return this.north;
    }

    public final void setNorth(Site site) {
        this.north = site;
    }

    @XmlElement(name="center", required=true, nillable=false)
    public final Site getCenter() {
        return this.center;
    }

    public final void setCenter(Site site) {
        this.center = site;
    }

    @XmlElement(name="east", required=true, nillable=false)
    public final Site getEast() {
        return this.east;
    }

    public final void setEast(Site site) {
        this.east = site;
    }

    @XmlElement(name="aux1", required=false, nillable=false)
    public Site getAux1() {
        return this.aux1;
    }

    public void setAux1(Site site) {
        this.aux1 = site;
    }

    @XmlElement(name="aux2", required=false, nillable=false)
    public Site getAux2() {
        return this.aux2;
    }

    public void setAux2(Site site) {
        this.aux2 = site;
    }

    @XmlElement(name="aux3", required=false, nillable=false)
    public Site getAux3() {
        return this.aux3;
    }

    public void setAux3(Site site) {
        this.aux3 = site;
    }

    @XmlElement(name="aux4", required=false, nillable=false)
    public Site getAux4() {
        return this.aux4;
    }

    public void setAux4(Site site) {
        this.aux4 = site;
    }

    @XmlElement(name="aux5", required=false, nillable=false)
    public Site getAux5() {
        return this.aux5;
    }

    public void setAux5(Site site) {
        this.aux5 = site;
    }

    @XmlElement(name="aux6", required=false, nillable=false)
    public Site getAux6() {
        return this.aux6;
    }

    public void setAux6(Site site) {
        this.aux6 = site;
    }

    @XmlTransient
    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean bl) {
        this.healthy = bl;
    }

    public String toString() {
        String string = this.id + " " + this.layermodel;
        string = this.enabled ? string + " (enabled)" : string + " (disabled)";
        if (this.hypolinePosition != HypolinePosition.UNDEFINED) {
            string = string + " " + this.hypolinePosition;
        }
        return string;
    }

    public SNS clone() {
        SNS sNS = new SNS();
        sNS.setHealthy(this.isHealthy());
        sNS.setFl(this.getFl());
        sNS.setFu(this.getFu());
        sNS.setEnabled(this.isEnabled());
        sNS.setLayermodel(this.getLayermodel());
        sNS.setID(this.getID());
        sNS.setCenter(this.getCenter() != null ? this.getCenter().clone() : null);
        sNS.setEast(this.getEast() != null ? this.getEast().clone() : null);
        sNS.setNorth(this.getNorth() != null ? this.getNorth().clone() : null);
        sNS.setWest(this.getWest() != null ? this.getWest().clone() : null);
        sNS.setAux1(this.getAux1() != null ? this.getAux1().clone() : null);
        sNS.setAux2(this.getAux2() != null ? this.getAux2().clone() : null);
        sNS.setAux3(this.getAux3() != null ? this.getAux3().clone() : null);
        sNS.setAux4(this.getAux4() != null ? this.getAux4().clone() : null);
        sNS.setAux5(this.getAux5() != null ? this.getAux5().clone() : null);
        sNS.setAux6(this.getAux6() != null ? this.getAux6().clone() : null);
        sNS.setHypolinePosition(this.getHypolinePosition());
        return sNS;
    }

    @XmlElement(name="active", required=false, defaultValue="true", nillable=false)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @XmlTransient
    public float getFl() {
        return this.fl;
    }

    public void setFl(float f) {
        this.fl = f;
    }

    @XmlTransient
    public float getFu() {
        return this.fu;
    }

    public void setFu(float f) {
        this.fu = f;
    }

    @XmlElement(name="layermodel", required=false, defaultValue="", nillable=false)
    public String getLayermodel() {
        return this.layermodel;
    }

    public void setLayermodel(String string) {
        this.layermodel = string;
    }

    @XmlElement(name="hypolinePosition", required=false, defaultValue="UNDEFINED", nillable=false)
    public String getHypolinePositionJAXB() {
        return this.hypolinePosition.name();
    }

    public void setHypolinePositionJAXB(String string) {
        this.hypolinePosition = HypolinePosition.valueOf(string);
    }

    @XmlTransient
    public HypolinePosition getHypolinePosition() {
        return this.hypolinePosition;
    }

    public void setHypolinePosition(HypolinePosition hypolinePosition) {
        this.hypolinePosition = hypolinePosition;
    }

    public static enum HypolinePosition {
        UNDEFINED,
        CENTER,
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST;

    }

    public static enum SNSSiteType {
        NORTH,
        WEST,
        EAST,
        CENTER,
        AUX1,
        AUX2,
        AUX3,
        AUX4,
        AUX5,
        AUX6;

    }
}

