/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.headerfiles;

import edu.geophys.commons.model.headerfiles.HardcodedHeaderRepository;
import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class HeaderImportHelper {
    private HeaderImportHelper() {
    }

    public static List<AbstractTraceFile> importHeader(File file) {
        List<AbstractTraceFile> list = null;
        if (file.exists() && file.canRead()) {
            try {
                if (file.getName().toLowerCase().endsWith(".fhd")) {
                    list = HeaderImportHelper.importFHD(file);
                } else {
                    LogUtil.error(HeaderImportHelper.class, "This demo version only works with the demo datasets provided on sonicona.com", true);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (list != null && list.size() <= 0) {
            list = null;
        }
        return list;
    }

    private static List<AbstractTraceFile> importFHD(File file) throws IOException {
        return HardcodedHeaderRepository.loadHeader(file);
    }
}

