/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.knowledgebase;

import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.LayerKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.ProjectDirectories;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class Knowledgebase {
    private static final String KNOWLEDGE_FOLDER_NAME = "knowbase";
    private static final String KNOWLEDGE_FOLDER_NAME_ALT = "Knowbase";
    private static final String TMP_FOLDER_NAME = "tmp";
    private static final String TMP_FOLDER_NAME_ALT = "Tmp";
    private final File knowledgeFolder;
    private final File tmpFolder;
    private final StationsKnowledge stationsKnowledge;
    private final CampaignKnowledge campaignKnowledge;
    private final LayerKnowledge layerKnowledge;

    public Knowledgebase(ProjectDirectories projectDirectories) {
        File file = projectDirectories.getWorkingDirectory();
        File file2 = new File(file, KNOWLEDGE_FOLDER_NAME);
        File file3 = new File(file, KNOWLEDGE_FOLDER_NAME_ALT);
        File file4 = new File(file, TMP_FOLDER_NAME);
        File file5 = new File(file, TMP_FOLDER_NAME_ALT);
        if (file2.exists()) {
            this.knowledgeFolder = new File(file, KNOWLEDGE_FOLDER_NAME);
        } else if (file3.exists()) {
            this.knowledgeFolder = new File(file, KNOWLEDGE_FOLDER_NAME_ALT);
        } else if (projectDirectories.getMode() == ProjectDirectories.ProjectMode.RO && Knowledgebase.tryPullingKnowbaseFromReadOnlyDataset(projectDirectories)) {
            this.knowledgeFolder = new File(file, KNOWLEDGE_FOLDER_NAME);
        } else {
            this.knowledgeFolder = new File(file, KNOWLEDGE_FOLDER_NAME);
            this.knowledgeFolder.mkdir();
        }
        if (file4.exists()) {
            this.tmpFolder = new File(file, TMP_FOLDER_NAME);
        } else if (file5.exists()) {
            this.tmpFolder = new File(file, TMP_FOLDER_NAME_ALT);
        } else {
            this.tmpFolder = new File(file, TMP_FOLDER_NAME);
            this.tmpFolder.mkdir();
        }
        String string = new CampaignKnowledge().getRelativeFilename();
        File file6 = new File(this.getKnowledgeFolder().getAbsolutePath(), string);
        this.campaignKnowledge = new CampaignKnowledge(file6);
        if (!this.campaignKnowledge.load()) {
            this.campaignKnowledge.createDefault();
            this.campaignKnowledge.store();
        }
        File file7 = new File(this.getKnowledgeFolder(), new StationsKnowledge().getRelativeFilename());
        this.stationsKnowledge = new StationsKnowledge(file7);
        if (!this.stationsKnowledge.load()) {
            this.stationsKnowledge.createDefault();
            this.stationsKnowledge.store();
        }
        this.layerKnowledge = new LayerKnowledge(this.getKnowledgeFolder());
        if (!this.layerKnowledge.getPath().exists()) {
            this.layerKnowledge.getPath().mkdir();
        }
        if (!this.layerKnowledge.load()) {
            this.layerKnowledge.createDefault();
            this.layerKnowledge.store(true);
        }
    }

    private static boolean tryPullingKnowbaseFromReadOnlyDataset(ProjectDirectories projectDirectories) {
        File file = null;
        File file2 = projectDirectories.getHeaderDirectory();
        for (String string : file2.list()) {
            if (!string.toLowerCase().equals(KNOWLEDGE_FOLDER_NAME.toLowerCase())) continue;
            file = new File(file2, string);
            break;
        }
        if (file != null) {
            File file3 = new File(file.getAbsolutePath());
            File file4 = new File(projectDirectories.getWorkingDirectory(), KNOWLEDGE_FOLDER_NAME);
            try {
                FileUtils.copyDirectory((File)file3, (File)file4);
                return true;
            }
            catch (IOException iOException) {
                LogUtil.warn(Knowledgebase.class, "Could not pull " + file3.getName() + " from " + projectDirectories.getHeaderDirectory().getAbsolutePath());
            }
        }
        return false;
    }

    public CampaignKnowledge getCampaignKnowledge() {
        return this.campaignKnowledge;
    }

    public StationsKnowledge getStationsKnowledge() {
        return this.stationsKnowledge;
    }

    public LayerKnowledge getLayerKnowledge() {
        return this.layerKnowledge;
    }

    public void store() {
        this.campaignKnowledge.store();
        this.stationsKnowledge.store();
    }

    public File getKnowledgeFolder() {
        return this.knowledgeFolder;
    }

    public File getTmpFolder() {
        return this.tmpFolder;
    }
}

