/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.tracefiles.D0TraceFile;
import edu.geophys.commons.model.tracefiles.F4TraceFile;
import edu.geophys.commons.model.tracefiles.I2TraceFile;
import edu.geophys.commons.model.tracefiles.I4TraceFile;
import edu.geophys.commons.model.tracefiles.MsTraceFile;
import edu.geophys.commons.model.tracefiles.NativeDataType;
import edu.geophys.commons.model.tracefiles.NxTraceFile;
import edu.geophys.commons.model.tracefiles.PdTraceFile;
import edu.geophys.commons.model.tracefiles.S4TraceFile;
import edu.geophys.commons.model.tracefiles.T4TraceFile;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.TreeSet;

public abstract class AbstractTraceFile
extends TraceFileMetadata
implements Serializable {
    private final TreeSet<CacheEntry> cache = new TreeSet();

    static final AbstractTraceFile createNativeTypeInstance(TraceFileMetadata traceFileMetadata) {
        return switch (traceFileMetadata.getDataType()) {
            case NativeDataType.i2 -> new I2TraceFile(traceFileMetadata);
            case NativeDataType.i4 -> new I4TraceFile(traceFileMetadata);
            case NativeDataType.s4 -> new S4TraceFile(traceFileMetadata);
            case NativeDataType.f4 -> new F4TraceFile(traceFileMetadata);
            case NativeDataType.t4 -> new T4TraceFile(traceFileMetadata);
            case NativeDataType.ms, NativeDataType.m1, NativeDataType.m4, NativeDataType.m5, NativeDataType.ms2, NativeDataType.m12, NativeDataType.m42, NativeDataType.m52, NativeDataType.msl, NativeDataType.m1l, NativeDataType.m4l, NativeDataType.m5l, NativeDataType.ms2l, NativeDataType.m12l, NativeDataType.m42l, NativeDataType.m52l -> new MsTraceFile(traceFileMetadata);
            case NativeDataType.nx -> new NxTraceFile(traceFileMetadata);
            case NativeDataType.pd -> new PdTraceFile(traceFileMetadata);
            case NativeDataType.d0 -> new D0TraceFile(traceFileMetadata);
            default -> throw new UnsupportedOperationException();
        };
    }

    protected AbstractTraceFile(TraceFileMetadata traceFileMetadata) {
        super(traceFileMetadata);
    }

    protected final MappedByteBuffer getMappedByteBuffer(long l, long l2) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(this.getTraceDataFile());
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.getByteOffset() + l, l2);
        fileChannel.close();
        fileInputStream.close();
        LogUtil.debug(this.getClass(), "getMappedByteBuffer() mapped to memory file=" + this.getTraceDataFile() + ", byteOffset=" + (this.getByteOffset() + l) + ", byteSize=" + l2);
        return mappedByteBuffer;
    }

    public void read(FloatBuffer floatBuffer, long l) {
        long l2 = l * (long)this.getDataType().byteSize;
        long l3 = (long)this.getDataType().byteSize * ((long)floatBuffer.remaining() <= (long)this.getLength() - l ? (long)floatBuffer.remaining() : (long)this.getLength() - l);
        try {
            MappedByteBuffer mappedByteBuffer = this.getMappedByteBuffer(l2, l3);
            this.convertToFloat(mappedByteBuffer, floatBuffer);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.error(this.getClass(), "read() could not open file", fileNotFoundException);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            LogUtil.debug(this.getClass(), "closed by interrupt while io happened, re-reading file", closedByInterruptException);
        }
        catch (IOException iOException) {
            LogUtil.warn(this.getClass(), "read() error while io happened", iOException);
        }
    }

    public final synchronized void read(FloatBuffer floatBuffer, double d) {
        long l = (long)StrictMath.floor((d - this.getStartEpochTime()) / this.getSampleIncrement());
        CacheEntry cacheEntry = new CacheEntry(l, new float[0]);
        CacheEntry cacheEntry2 = this.cache.floor(cacheEntry);
        boolean bl = false;
        if (cacheEntry2 != null) {
            long l2 = cacheEntry2.getStartsample();
            long l3 = l - l2;
            long l4 = cacheEntry2.getSamples().length;
            if (l3 >= 0L && l4 >= (long)floatBuffer.remaining() + l3) {
                bl = true;
                int n = floatBuffer.remaining();
                for (long i = 0L; i < (long)n; ++i) {
                    floatBuffer.put(cacheEntry2.getSamples()[(int)(i + l3)]);
                }
            }
        }
        if (!bl) {
            int n = floatBuffer.position();
            this.read(floatBuffer, l);
            int n2 = floatBuffer.position();
            if (n2 > n) {
                float[] fArray = new float[n2 - n];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = floatBuffer.get(i + n);
                }
                this.cache.add(new CacheEntry(l, fArray));
            }
            LogUtil.debug(this.getClass(), "loading of element which is not in cache " + this.cache.size());
        } else {
            LogUtil.debug(this.getClass(), "loading of element which is in cache " + this.cache.size());
        }
    }

    public synchronized void clearCache(long l, long l2) {
        ArrayList<CacheEntry> arrayList = new ArrayList<CacheEntry>();
        for (CacheEntry cacheEntry : this.cache) {
            long l3 = 1000L * (long)(this.getStartEpochTime() + (double)cacheEntry.getStartsample() * this.getSampleIncrement());
            long l4 = l3 + 1000L * (long)((double)cacheEntry.getSamples().length * this.getSampleIncrement());
            if (l3 <= l2 && l4 >= l) continue;
            LogUtil.debug(this.getClass(), "removing the following cache entry: " + DateTimeUtil.formatDateTimeISO(l3) + " " + DateTimeUtil.formatDateTimeISO(l4));
            arrayList.add(cacheEntry);
        }
        this.cache.removeAll(arrayList);
    }

    protected abstract void convertToFloat(ByteBuffer var1, FloatBuffer var2);

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public String toString() {
        String string = "super=" + super.toString();
        return this.getClass().getName() + "[" + string + "]";
    }

    public TreeSet<CacheEntry> getCache() {
        return this.cache;
    }

    class CacheEntry
    implements Comparable<CacheEntry> {
        private long startsample;
        private float[] samples;

        public CacheEntry(long l, float[] fArray) {
            this.startsample = l;
            this.samples = fArray;
        }

        public long getStartsample() {
            return this.startsample;
        }

        public void setStartsample(long l) {
            this.startsample = l;
        }

        public float[] getSamples() {
            return this.samples;
        }

        public void setSamples(float[] fArray) {
            this.samples = fArray;
        }

        @Override
        public int compareTo(CacheEntry cacheEntry) {
            int n = (int)Math.signum(this.getStartsample() - cacheEntry.getStartsample());
            return n;
        }
    }
}

