/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import edu.geophys.commons.util.LogUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class D0TraceFile
extends AbstractTraceFile {
    private static final long serialVersionUID = -3794070053334655320L;

    D0TraceFile(TraceFileMetadata traceFileMetadata) {
        super(traceFileMetadata);
    }

    @Override
    protected final void convertToFloat(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
    }

    @Override
    public void read(FloatBuffer floatBuffer, long l) {
        long l2 = this.getByteOffset() + l * (long)this.getDataType().byteSize;
        long l3 = (long)this.getDataType().byteSize * ((long)floatBuffer.remaining() <= (long)this.getLength() - l ? (long)floatBuffer.remaining() : (long)this.getLength() - l);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getTraceDataFile()));
            float f = this.getCalibration();
            for (long i = 0L; (string = bufferedReader.readLine()) != null && i < l2 + l3; ++i) {
                if (i < l2) continue;
                floatBuffer.put(Float.parseFloat(string) * f);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.error(this.getClass(), "read() could not open file", fileNotFoundException);
        }
        catch (IOException iOException) {
            LogUtil.error(this.getClass(), "read() error while io happened", iOException);
        }
    }
}

