/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import java.nio.FloatBuffer;
import java.util.Comparator;
import java.util.TreeSet;

public class MergingTraceFileDatabase
implements TraceMetadata {
    private static final int NUMBER_IDENTICAL_NAN = 5;
    private TreeSet<TraceFileMetadata> traceFileTree = new TreeSet<TraceFileMetadata>(new Comparator<TraceFileMetadata>(){

        @Override
        public int compare(TraceFileMetadata traceFileMetadata, TraceFileMetadata traceFileMetadata2) {
            int n = 0;
            n = (int)Math.signum(traceFileMetadata.getStartEpochTime() - traceFileMetadata2.getStartEpochTime());
            if (n == 0) {
                n = (int)Math.signum(traceFileMetadata.getEndEpochTime() - traceFileMetadata2.getEndEpochTime());
            }
            return n;
        }
    });

    private static final TraceFileMetadata getComparatorInstance(double d, int n) {
        TraceFileMetadata traceFileMetadata = new TraceFileMetadata();
        traceFileMetadata.setStartEpochTime(d);
        traceFileMetadata.setLength(n);
        return traceFileMetadata;
    }

    public final MergingTraceFileDatabase shallowCopy() {
        MergingTraceFileDatabase mergingTraceFileDatabase = new MergingTraceFileDatabase();
        mergingTraceFileDatabase.traceFileTree = (TreeSet)this.traceFileTree.clone();
        return mergingTraceFileDatabase;
    }

    public void add(AbstractTraceFile abstractTraceFile) {
        this.traceFileTree.add(abstractTraceFile);
    }

    public void remove(AbstractTraceFile abstractTraceFile) {
        if (this.traceFileTree.contains(abstractTraceFile)) {
            this.traceFileTree.remove(abstractTraceFile);
        }
    }

    public boolean isEmpty() {
        return this.traceFileTree.isEmpty();
    }

    public void clear() {
        this.traceFileTree.clear();
    }

    public DefaultTrace getMergedTrace(double d, int n) {
        boolean bl;
        AbstractTraceFile abstractTraceFile;
        TraceFileMetadata traceFileMetadata = MergingTraceFileDatabase.getComparatorInstance(d, n);
        double d2 = d;
        FloatBuffer floatBuffer = FloatBuffer.allocate(n);
        AbstractTraceFile abstractTraceFile2 = abstractTraceFile = (AbstractTraceFile)this.traceFileTree.floor(traceFileMetadata);
        if (abstractTraceFile == null || !abstractTraceFile.contains(d2)) {
            abstractTraceFile = (AbstractTraceFile)this.traceFileTree.ceiling(traceFileMetadata);
            if (abstractTraceFile2 == null) {
                abstractTraceFile2 = abstractTraceFile;
            }
        }
        while (floatBuffer.position() < floatBuffer.capacity()) {
            if (abstractTraceFile == null) {
                floatBuffer.limit(floatBuffer.capacity());
                while (floatBuffer.hasRemaining()) {
                    floatBuffer.put(Float.NaN);
                }
                continue;
            }
            if (d2 < abstractTraceFile.getStartEpochTime()) {
                long l = (int)StrictMath.rint((abstractTraceFile.getStartEpochTime() - d2) / abstractTraceFile.getSampleIncrement());
                if (l + (long)floatBuffer.position() > (long)floatBuffer.capacity()) {
                    l = floatBuffer.capacity() - floatBuffer.position();
                }
                floatBuffer.limit(floatBuffer.position() + (int)l);
                while (floatBuffer.hasRemaining()) {
                    floatBuffer.put(Float.NaN);
                }
                d2 = abstractTraceFile.getStartEpochTime();
                continue;
            }
            if (abstractTraceFile.contains(d2)) {
                floatBuffer.limit(floatBuffer.capacity());
                abstractTraceFile.read(floatBuffer, d2);
                d2 = abstractTraceFile.getEndEpochTime() + abstractTraceFile.getSampleIncrement();
            }
            abstractTraceFile2 = abstractTraceFile;
            abstractTraceFile = (AbstractTraceFile)this.traceFileTree.higher(abstractTraceFile);
        }
        DefaultTrace defaultTrace = new DefaultTrace(abstractTraceFile2);
        defaultTrace.setStartEpochTime(d);
        float[] fArray = floatBuffer.array();
        try {
            bl = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getRepeatingValuesNan();
        }
        catch (Exception exception) {
            LogUtil.warn(this.getClass(), "Could not read from campaign.xml: Don't regard repeating values as NaN");
            bl = false;
        }
        if (bl && fArray.length > 5) {
            float f = fArray[0];
            int n2 = 0;
            for (int i = 1; i < fArray.length; ++i) {
                if (fArray[i] == f) {
                    ++n2;
                    continue;
                }
                if (n2 >= 5) {
                    for (int j = 0; j < n2; ++j) {
                        fArray[i - 1 - j] = Float.NaN;
                    }
                }
                f = fArray[i];
                n2 = 0;
            }
        }
        defaultTrace.setSamples(fArray);
        defaultTrace.setOriginalLength(defaultTrace.getLength());
        return defaultTrace;
    }

    public DefaultTrace getMergedTrace(double d, double d2) {
        long l = (long)Math.rint((d2 - d) / this.getSampleIncrement());
        if (l > Integer.MAX_VALUE) {
            LogUtil.error(this.getClass(), "Requested time range contains more samples than an array could have");
            throw new ArrayIndexOutOfBoundsException("Requested time range contains more samples than an array could have");
        }
        return this.getMergedTrace(d, (int)l);
    }

    @Override
    public String getStationID() {
        return this.traceFileTree.last().getStationID();
    }

    @Override
    public String getStationName() {
        return this.traceFileTree.last().getStationName();
    }

    @Override
    public String getStationChannel() {
        return this.traceFileTree.last().getStationChannel();
    }

    @Override
    public double getStartEpochTime() {
        return this.traceFileTree.first().getStartEpochTime();
    }

    @Override
    public double getEndEpochTime() {
        return this.traceFileTree.last().getEndEpochTime();
    }

    @Override
    public float getSamplerate() {
        return this.traceFileTree.last().getSamplerate();
    }

    @Override
    public float getOriginalSamplerate() {
        return this.getSamplerate();
    }

    @Override
    public int getLength() {
        return (int)StrictMath.round((this.getEndEpochTime() - this.getStartEpochTime()) / (double)this.getSamplerate());
    }

    @Override
    public int getOriginalLength() {
        return this.getLength();
    }

    @Override
    public float getCalibration() {
        return this.traceFileTree.last().getCalibration();
    }

    @Override
    public int getLsbFactor() {
        return this.traceFileTree.last().getLsbFactor();
    }

    @Override
    public final double getSampleIncrement() {
        return 1.0 / (double)this.getSamplerate();
    }

    @Override
    public final boolean contains(double d) {
        return d >= this.getStartEpochTime() && d < this.getEndEpochTime();
    }
}

