/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import java.nio.ByteOrder;

public enum NativeDataType {
    i2(2, ByteOrder.LITTLE_ENDIAN, CompressionFormat.NONE),
    i4(4, ByteOrder.LITTLE_ENDIAN, CompressionFormat.NONE),
    s4(4, ByteOrder.BIG_ENDIAN, CompressionFormat.NONE),
    f4(4, ByteOrder.LITTLE_ENDIAN, CompressionFormat.NONE),
    t4(4, ByteOrder.BIG_ENDIAN, CompressionFormat.NONE),
    ms(512, ByteOrder.BIG_ENDIAN, CompressionFormat.STEIM1),
    m1(1024, ByteOrder.BIG_ENDIAN, CompressionFormat.STEIM1),
    m4(4096, ByteOrder.BIG_ENDIAN, CompressionFormat.STEIM1),
    m5(512, ByteOrder.BIG_ENDIAN, CompressionFormat.STEIM1),
    ms2(512, ByteOrder.BIG_ENDIAN, CompressionFormat.STEIM2),
    m12(1024, ByteOrder.BIG_ENDIAN, CompressionFormat.STEIM2),
    m42(4096, ByteOrder.BIG_ENDIAN, CompressionFormat.STEIM2),
    m52(512, ByteOrder.BIG_ENDIAN, CompressionFormat.STEIM2),
    msl(512, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM1),
    m1l(1024, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM1),
    m4l(4096, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM1),
    m5l(512, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM1),
    ms2l(512, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM2),
    m12l(1024, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM2),
    m42l(4096, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM2),
    m52l(512, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM2),
    nx(4096, ByteOrder.LITTLE_ENDIAN, CompressionFormat.STEIM1),
    pd(2, ByteOrder.LITTLE_ENDIAN, CompressionFormat.UNKNOWN),
    d0(1, ByteOrder.LITTLE_ENDIAN, CompressionFormat.UNKNOWN);

    public final int byteSize;
    public final ByteOrder byteOrder;
    public final CompressionFormat compression;

    private NativeDataType(int n2, ByteOrder byteOrder, CompressionFormat compressionFormat) {
        this.byteSize = n2;
        this.byteOrder = byteOrder;
        this.compression = compressionFormat;
    }

    public static enum CompressionFormat {
        NONE,
        STEIM1,
        STEIM2,
        UNKNOWN;

    }
}

