/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.TraceFileMetadata;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class PdTraceFile
extends AbstractTraceFile {
    private static final long serialVersionUID = 1037937316506453211L;

    PdTraceFile(TraceFileMetadata traceFileMetadata) {
        super(traceFileMetadata);
    }

    @Override
    protected final void convertToFloat(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        float f = this.getCalibration();
        byteBuffer.order(this.getDataType().byteOrder);
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        while (shortBuffer.hasRemaining() && floatBuffer.hasRemaining()) {
            short s = shortBuffer.get();
            int n = s >> 2;
            int n2 = s & 3;
            floatBuffer.put(f * (float)(n << 9 - 3 * n2));
        }
    }
}

