/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.tracefiles.Utility;
import java.util.ArrayList;
import java.util.List;

public class Steim2 {
    public static List<Integer> decode(byte[] byArray, boolean bl, int n) throws Exception {
        if (byArray.length % 64 != 0) {
            throw new Exception("encoded data length is not multiple of 64 bytes (" + byArray.length + ")");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = byArray.length / 64;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            int[] nArray = Steim2.extractSamples(byArray, i * 64, bl);
            n6 = 0;
            if (i == 0) {
                n7 = n;
                n4 = nArray[1];
                n5 = nArray[2];
                n6 = 3;
                if (n == 0) {
                    n7 = n4 - nArray[3];
                }
            }
            for (int j = n6; j < nArray.length; ++j) {
                arrayList.add(n7 += nArray[j]);
                ++n3;
            }
        }
        return arrayList;
    }

    public static List<Integer> decode(byte[] byArray, boolean bl) throws Exception {
        return Steim2.decode(byArray, bl, 0);
    }

    public static byte[] encode(int[] nArray) {
        byte[] byArray = new byte[]{};
        return byArray;
    }

    protected static int[] extractSamples(byte[] byArray, int n, boolean bl) {
        int n2 = Utility.bytesToInt(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], bl);
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[106];
        int n5 = 0;
        block16: for (int i = 0; i < 16; ++i) {
            n3 = n2 >> 30 - i * 2 & 3;
            switch (n3) {
                case 0: {
                    if (n != 0 || i >= 3) continue block16;
                    nArray[n5++] = Utility.bytesToInt(byArray[n + i * 4], byArray[n + i * 4 + 1], byArray[n + i * 4 + 2], byArray[n + i * 4 + 3], bl);
                    continue block16;
                }
                case 1: {
                    nArray[n5++] = Utility.bytesToInt(byArray[n + i * 4]);
                    nArray[n5++] = Utility.bytesToInt(byArray[n + i * 4 + 1]);
                    nArray[n5++] = Utility.bytesToInt(byArray[n + i * 4 + 2]);
                    nArray[n5++] = Utility.bytesToInt(byArray[n + i * 4 + 3]);
                    continue block16;
                }
                case 2: {
                    int n6 = Utility.bytesToInt(byArray[n + i * 4], byArray[n + i * 4 + 1], byArray[n + i * 4 + 2], byArray[n + i * 4 + 3], bl);
                    n4 = n6 >> 30 & 3;
                    switch (n4) {
                        case 1: {
                            nArray[n5++] = n6 << 2 >> 2;
                            continue block16;
                        }
                        case 2: {
                            nArray[n5++] = n6 << 2 >> 17;
                            nArray[n5++] = n6 << 17 >> 17;
                            continue block16;
                        }
                        case 3: {
                            nArray[n5++] = n6 << 2 >> 22;
                            nArray[n5++] = n6 << 12 >> 22;
                            nArray[n5++] = n6 << 22 >> 22;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                case 3: {
                    int n6 = Utility.bytesToInt(byArray[n + i * 4], byArray[n + i * 4 + 1], byArray[n + i * 4 + 2], byArray[n + i * 4 + 3], bl);
                    n4 = n6 >> 30 & 3;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    switch (n4) {
                        case 0: {
                            n9 = 2;
                            n7 = 5;
                            n8 = 6;
                            break;
                        }
                        case 1: {
                            n9 = 2;
                            n7 = 6;
                            n8 = 5;
                            break;
                        }
                        case 2: {
                            n9 = 4;
                            n7 = 7;
                            n8 = 4;
                            break;
                        }
                    }
                    if (n7 <= 0) continue block16;
                    for (int j = 0; j < n7; ++j) {
                        nArray[n5++] = n6 << n9 + j * n8 >> (n7 - 1) * n8 + n9;
                    }
                    continue block16;
                }
            }
        }
        int[] nArray2 = new int[n5];
        System.arraycopy(nArray, 0, nArray2, 0, n5);
        return nArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        byte[] byArray = new byte[64];
        List<Object> list = new ArrayList();
        for (int i = 0; i < 64; ++i) {
            byArray[i] = 0;
        }
        byArray[0] = 1;
        byArray[1] = -80;
        System.out.println(byArray[1]);
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        byArray[11] = 0;
        byArray[12] = 1;
        byArray[13] = 2;
        byArray[14] = 3;
        byArray[15] = 0;
        byArray[16] = 1;
        byArray[17] = 1;
        byArray[18] = 0;
        byArray[19] = 0;
        byArray[20] = 0;
        byArray[21] = 1;
        byArray[22] = 0;
        byArray[23] = 0;
        list = Steim2.decode(byArray, false, 17);
    }
}

