/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles;

import edu.geophys.commons.model.DefaultTraceMetadata;
import edu.geophys.commons.model.TraceMetadata;
import edu.geophys.commons.model.tracefiles.AbstractTraceFile;
import edu.geophys.commons.model.tracefiles.NativeDataType;
import java.io.File;
import java.io.Serializable;
import java.util.zip.DataFormatException;

public class TraceFileMetadata
extends DefaultTraceMetadata
implements Serializable {
    private static final long serialVersionUID = -3488969842223673797L;
    private static final String ERROR_PARSE_NULL_VALUE = "null values cannot be parsed";
    private NativeDataType _nativeDataType;
    private long _byteOffset;
    private File _traceDataFile;
    private DynamicEntryType dynamic = DynamicEntryType.STATIC;

    protected final void shallowCopyFrom(TraceFileMetadata traceFileMetadata) throws IllegalArgumentException {
        if (traceFileMetadata == null) {
            throw new IllegalArgumentException("not possible to copy from null");
        }
        super.shallowCopyFrom(traceFileMetadata);
        this.setDataType(traceFileMetadata.getDataType());
        this.setTraceDataFile(traceFileMetadata.getTraceDataFile());
        this.setByteOffset(traceFileMetadata.getByteOffset());
        this.setDynamic(traceFileMetadata.getDynamic());
    }

    public TraceFileMetadata() {
    }

    public TraceFileMetadata(TraceMetadata traceMetadata) {
        super(traceMetadata);
    }

    public TraceFileMetadata(TraceFileMetadata traceFileMetadata) {
        this.shallowCopyFrom(traceFileMetadata);
    }

    public final NativeDataType getDataType() {
        return this._nativeDataType;
    }

    public final long getByteOffset() {
        return this._byteOffset;
    }

    public final File getTraceDataFile() {
        return this._traceDataFile;
    }

    public final void setDataType(NativeDataType nativeDataType) throws IllegalArgumentException {
        if (nativeDataType == null) {
            throw new IllegalArgumentException("dataType cannot be null");
        }
        this._nativeDataType = nativeDataType;
    }

    public final void setDataType(String string) throws DataFormatException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(ERROR_PARSE_NULL_VALUE);
        }
        try {
            this.setDataType(NativeDataType.valueOf(string.toLowerCase()));
        }
        catch (RuntimeException runtimeException) {
            throw new DataFormatException("could not parse a valid dataType from String argument");
        }
    }

    public final void setByteOffset(long l) {
        this._byteOffset = l;
    }

    public final void setByteOffset(String string) throws DataFormatException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(ERROR_PARSE_NULL_VALUE);
        }
        try {
            this.setByteOffset(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException("could not parse a valid byteOffset from String argument");
        }
    }

    public final void setTraceDataFile(File file) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("traceDataFile cannot be null");
        }
        this._traceDataFile = file;
    }

    public final void setTraceDataFile(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(ERROR_PARSE_NULL_VALUE);
        }
        this.setTraceDataFile(new File(string));
    }

    public final void setTraceDataFile(String string, String string2, String string3) throws IllegalArgumentException, DataFormatException {
        if (string == null) {
            throw new IllegalArgumentException("null values cannot be parsed(parentDirectoryPath)");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null values cannot be parsed(directoryPath)");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("null values cannot be parsed(filePath)");
        }
        if (!string2.startsWith(".\\")) {
            if (string2.startsWith("\\")) {
                throw new DataFormatException("absolute paths not yet implementet, maybe never be implemented");
            }
            throw new DataFormatException("relative to wfpath paths not yet implementet, maybe never be implemented");
        }
        this.setTraceDataFile(string + File.separator + string2.substring(2).replace("\\", File.separator) + File.separator + string3);
    }

    public final void setStartEpochTime(String string) throws DataFormatException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(ERROR_PARSE_NULL_VALUE);
        }
        try {
            this.setStartEpochTime(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException("could not parse a valid startEpochTime from String argument");
        }
    }

    public final void setSamplerate(String string) throws DataFormatException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(ERROR_PARSE_NULL_VALUE);
        }
        try {
            this.setSamplerate(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException("could not parse a valid length from String argument");
        }
    }

    public final void setLength(String string) throws DataFormatException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(ERROR_PARSE_NULL_VALUE);
        }
        try {
            this.setLength(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException("could not parse a valid length from String argument");
        }
    }

    public final void setCalibration(double d, double d2) {
        this.setCalibration(d, d2, 1);
    }

    public final void setCalibration(double d, double d2, int n) {
        this.setCalibration((float)(d * (Math.PI * 2) / d2) * (float)n);
        this.setLsbFactor(n);
    }

    public final void setCalibration(String string, String string2, String string3) throws DataFormatException, IllegalArgumentException {
        float f;
        float f2;
        if (string == null) {
            throw new IllegalArgumentException("null values cannot be parsed (calibm)");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null values cannot be parsed (calper)");
        }
        try {
            f2 = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException("could not parse a valid calibm from String argument");
        }
        try {
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException("could not parse a valid calper from String argument");
        }
        if (string3 != null) {
            int n;
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("could not parse a valid lsbFactor from String argument");
            }
            if (n != 0) {
                this.setCalibration(f2, f, n);
            } else {
                this.setCalibration(f2, f);
            }
        } else {
            this.setCalibration(f2, f);
        }
    }

    public final AbstractTraceFile createNativeFileInstance() {
        return AbstractTraceFile.createNativeTypeInstance(this);
    }

    @Override
    public String toString() {
        String string = "traceDataFile=" + this._traceDataFile + ", dataType=" + this._nativeDataType + ", byteOffset=" + this._byteOffset + ", super=" + super.toString();
        return this.getClass().getName() + "[" + string + "]";
    }

    public DynamicEntryType getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(DynamicEntryType dynamicEntryType) {
        this.dynamic = dynamicEntryType;
    }

    public static enum DynamicEntryType {
        STATIC,
        DAY,
        HOUR;

    }
}

