/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters.m24;

import edu.geophys.commons.model.tracefiles.NativeDataType;
import edu.geophys.commons.model.tracefiles.converters.m24.M24File;
import edu.geophys.commons.model.tracefiles.converters.m24.M24TraceMetaModel;
import edu.geophys.commons.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;

public class M24ToCSS {
    private ArrayList<File> _srcFiles = new ArrayList();
    private ArrayList<M24TraceMetaModel> _srcMetaData = new ArrayList();
    private ArrayList<Integer> _sortedIds = new ArrayList();
    private String[] channels;
    private File header;
    private float calper;
    private float calibm;
    private int lsbFactor;
    private NativeDataType dataType;
    private int snsNumber;

    public final void convert(File file, File file2, float f, float f2, int n, NativeDataType nativeDataType, String[] stringArray, int n2) {
        this.header = file2;
        this.channels = stringArray;
        this.calper = f;
        this.calibm = f2;
        this.lsbFactor = n;
        this.dataType = nativeDataType;
        this.snsNumber = n2;
        if (!file.exists() || !file.isDirectory()) {
            LogUtil.error(this.getClass(), "Directory (" + file.getAbsolutePath() + ") does not exist or is no directory.", true);
            return;
        }
        if (file2.exists()) {
            LogUtil.error(this.getClass(), "Headerfile (" + file2.getAbsolutePath() + ") already exists.", true);
            return;
        }
        LogUtil.info(this.getClass(), "Step 2: Collecting input files:");
        for (File file3 : file.listFiles()) {
            this.addDataFile(file3.getAbsolutePath());
        }
        if (stringArray.length > 0 && this._srcFiles.size() != stringArray.length) {
            LogUtil.error(this.getClass(), "ERROR: Number of input files and channel names differs.", true);
            return;
        }
        LogUtil.info(this.getClass(), "Done.\n");
        LogUtil.info(this.getClass(), "Step 3: Importing input files:");
        for (File file4 : this._srcFiles) {
            M24TraceMetaModel m24TraceMetaModel = this.importFile(file4);
            if (m24TraceMetaModel == null) continue;
            this._srcMetaData.add(m24TraceMetaModel);
        }
        LogUtil.info(this.getClass(), "Done.\n");
        LogUtil.info(this.getClass(), "Step 4: Sorting input files:");
        TreeSet<M24TraceMetaModel> treeSet = new TreeSet<M24TraceMetaModel>(this._srcMetaData);
        Iterator<Object> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            M24TraceMetaModel m24TraceMetaModel = (M24TraceMetaModel)iterator.next();
            this._sortedIds.add(this._srcMetaData.indexOf(m24TraceMetaModel));
        }
        LogUtil.info(this.getClass(), "Done.\n");
        LogUtil.info(this.getClass(), "Step 5: Generating header:");
        for (Integer n3 : this._sortedIds) {
            this.generateHeader(this._srcFiles.get(n3), this._srcMetaData.get(n3), n3);
        }
        LogUtil.info(this.getClass(), "Done.\n");
    }

    private final void addDataFile(String string) {
        File file = new File(string);
        if (!file.exists() || file.isDirectory()) {
            LogUtil.warn(this.getClass(), String.format("File does not exist \"%s\"", file));
            return;
        }
        if (!file.canRead()) {
            LogUtil.warn(this.getClass(), String.format("File is not readable \"%s\"", file));
            return;
        }
        if (this._srcFiles.contains(file)) {
            LogUtil.warn(this.getClass(), String.format("File is a dublicate \"%s\"", file));
            return;
        }
        this._srcFiles.add(file);
    }

    private void generateHeader(File file, M24TraceMetaModel m24TraceMetaModel, Integer n) {
        Object object = "";
        String string = "";
        String string2 = file.getName();
        if (this.channels.length > 0) {
            object = this.channels[n].split("-")[0];
            string = this.channels[n].split("-")[1];
        } else if (string2.endsWith("d1.c0")) {
            object = "S" + this.snsNumber + "C";
            string = "SZ";
        } else if (string2.endsWith("d1.c1")) {
            object = "S" + this.snsNumber + "C";
            string = "SN";
        } else if (string2.endsWith("d1.c2")) {
            object = "S" + this.snsNumber + "C";
            string = "SE";
        } else if (string2.endsWith("d2.c0")) {
            object = "S" + this.snsNumber + "E";
            string = "SZ";
        } else if (string2.endsWith("d2.c1")) {
            object = "S" + this.snsNumber + "N";
            string = "SZ";
        } else if (string2.endsWith("d2.c2")) {
            object = "S" + this.snsNumber + "W";
            string = "SZ";
        } else {
            LogUtil.error(this.getClass(), "ERROR no channel map given and file does not end in M24 scheme (d1c1...) " + string2);
            return;
        }
        String string3 = m24TraceMetaModel.getSHTLine((String)object, string, file.getParent(), file.getName(), this.calibm, this.calper, this.lsbFactor, this.dataType);
        LogUtil.debug(this.getClass(), string3);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.header, true));
            bufferedWriter.append(string3);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private M24TraceMetaModel importFile(File file) {
        File file2 = file;
        M24TraceMetaModel m24TraceMetaModel = null;
        LogUtil.info(this.getClass(), String.format("Generate header part of file \"%s\"", file));
        try {
            M24File m24File = new M24File(file2);
            if (!m24File.isValid()) {
                LogUtil.info(this.getClass(), String.format("File is not valid M24 formated \"%s\"", file2));
                m24File.close();
                return m24TraceMetaModel;
            }
            LogUtil.info(this.getClass(), String.format("Importing: \"%s\"", file2));
            m24TraceMetaModel = m24File.readMetaData();
            LogUtil.debug(this.getClass(), m24TraceMetaModel.getInfo());
            m24File.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.info(this.getClass(), "Ooops this should never happen!");
            fileNotFoundException.printStackTrace();
            System.exit(100);
        }
        catch (IOException iOException) {
            LogUtil.error(this.getClass(), String.format("Unknown error while importing file \"%s\"", file2));
            iOException.printStackTrace();
            return null;
        }
        return m24TraceMetaModel;
    }

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.UK);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        if (stringArray.length != 5) {
            System.out.println("Call by java -jar edu.geophys.commons.model.tracefiles.converters.m24.M24ToCSS FOLDER HEADER_FILENAME CALPER CALIBM SNS_NUMBER");
            System.out.println("Standard calper=1.0 and calibm=0.00185");
        } else {
            new M24ToCSS().convert(new File(stringArray[0]), new File(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]), 0, NativeDataType.i4, new String[0], Integer.parseInt(stringArray[4]));
        }
    }
}

