/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.model.tracefiles.converters.seg2;

import edu.geophys.commons.model.tracefiles.converters.TimeHelper;
import edu.geophys.commons.model.tracefiles.converters.seg2.Seg2MetaModel;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public class Seg2TraceMetaModel {
    private static final String KEY_SAMPLE_INTERVAL = "SAMPLE_INTERVAL";
    private final Seg2MetaModel parent;
    private int _offset;
    private int _length;
    private int _samples;
    private double _samplerate;
    private DataFormatTypes _type;
    private Map<String, String> _traceDescription;

    public Seg2TraceMetaModel(Seg2MetaModel seg2MetaModel) {
        this.parent = seg2MetaModel;
    }

    public final int getLength() {
        return this._length;
    }

    public final void setLength(int n) {
        this._length = n;
    }

    public final int getOffset() {
        return this._offset;
    }

    public final void setOffset(int n) {
        this._offset = n;
    }

    public final int getSamples() {
        return this._samples;
    }

    public final void setSamples(int n) {
        this._samples = n;
    }

    public final DataFormatTypes getType() {
        return this._type;
    }

    public final void setType(DataFormatTypes dataFormatTypes) {
        this._type = dataFormatTypes;
    }

    public final void setDataFormatCode(byte by) {
        this.setType(DataFormatTypes.values()[by - 1]);
    }

    public final Map<String, String> getTraceDescription() {
        return this._traceDescription;
    }

    public final void setTraceDescription(Map<String, String> map) {
        this._traceDescription = map;
        this._samplerate = 1.0 / Double.parseDouble(this._traceDescription.get(KEY_SAMPLE_INTERVAL));
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("   Offset: %d\n", this.getOffset()));
        stringBuffer.append(String.format("   Length: %d\n", this.getLength()));
        stringBuffer.append(String.format("   Samples: %d\n", this.getSamples()));
        stringBuffer.append(String.format("   Data type: %s\n", new Object[]{this.getType()}));
        stringBuffer.append(String.format("   Trace description:\n", new Object[0]));
        for (String string : this.getTraceDescription().keySet()) {
            stringBuffer.append(String.format("     %s: %s\n", string, this.getTraceDescription().get(string)));
        }
        return stringBuffer.toString();
    }

    public String getSHTLine(String string, String string2, String string3, String string4, float f, float f2, int n) {
        Calendar calendar = TimeHelper.epochToCalendar(this.getAcquisitionStart());
        if (n != 0) {
            return String.format(Locale.ENGLISH, "%1$tY%1$tj %2$#f %3$s %4$s %5$d %6$#.1f %7$#f %8$#f %9$s %10$s %11$s %12$d %13$d\n", calendar, this.getAcquisitionStart(), string, string2, this.getSamples(), this.getSampleRate(), Float.valueOf(f), Float.valueOf(f2), this.getType().toString(), string3, string4, this.getOffset(), n);
        }
        return String.format(Locale.ENGLISH, "%1$tY%1$tj %2$#f %3$s %4$s %5$d %6$#.1f %7$#f %8$#f %9$s %10$s %11$s %12$d\n", calendar, this.getAcquisitionStart(), string, string2, this.getSamples(), this.getSampleRate(), Float.valueOf(f), Float.valueOf(f2), this.getType().toString(), string3, string4, this.getOffset());
    }

    public double getAcquisitionStart() {
        return this.parent.getAcquisitionStart();
    }

    public double getSampleRate() {
        return this._samplerate;
    }

    static enum DataFormatTypes {
        i2,
        i4,
        seg20,
        f4,
        f8;

    }
}

