/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.range;

import edu.geophys.commons.range.DefaultRangeMarkerModelChild;
import edu.geophys.commons.range.RangeDataEvent;
import edu.geophys.commons.range.RangeDataListener;
import edu.geophys.commons.range.RangeMarker;
import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.range.RangeMarkerModelChild;
import java.util.EventListener;
import java.util.SortedSet;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;

public abstract class AbstractRangeMarkerModel<E>
implements RangeMarkerModel<E> {
    protected EventListenerList _listenerList = new EventListenerList();
    private boolean _adjusting = false;

    protected void fireMarkerValueChanged(RangeMarker rangeMarker) {
        this.fireMarkerDataEvent(MarkerDataEventType.VALUE_CHANGED, rangeMarker);
    }

    protected void fireMarkerPositionChanged(RangeMarker rangeMarker) {
        this.fireMarkerDataEvent(MarkerDataEventType.POSITION_CHANGED, rangeMarker);
    }

    protected void fireMarkerAdded(RangeMarker rangeMarker) {
        this.fireMarkerDataEvent(MarkerDataEventType.MARKER_ADDED, rangeMarker);
    }

    protected void fireMarkerRemoved(RangeMarker rangeMarker) {
        this.fireMarkerDataEvent(MarkerDataEventType.MARKER_REMOVED, rangeMarker);
    }

    protected void fireAllChanged() {
        this.fireMarkerDataEvent(MarkerDataEventType.ALL_CHANGED, null);
    }

    @Override
    public final SortedSet<RangeMarker<E>> getSortedMarkers(Pattern pattern) {
        SortedSet sortedSet = this.getSortedMarkers();
        for (RangeMarker rangeMarker : sortedSet) {
            if (pattern.matcher(rangeMarker.getID()).matches()) continue;
            sortedSet.remove(rangeMarker);
        }
        return sortedSet;
    }

    @Override
    public final String getMarkerId(RangeMarker<E> rangeMarker) {
        return rangeMarker.getID();
    }

    @Override
    public RangeMarkerModelChild<E> createChild(String string, String string2) {
        if (this.getMarker(string) == null) {
            this.setMarker(string, 0.0, null);
        }
        if (this.getMarker(string2) == null) {
            this.setMarker(string2, 1.0, null);
        }
        return new DefaultRangeMarkerModelChild(this, string, string2);
    }

    @Override
    public void addMarkerDataListener(RangeDataListener rangeDataListener) {
        this._listenerList.add(RangeDataListener.class, rangeDataListener);
    }

    @Override
    public void removeMarkerDataListener(RangeDataListener rangeDataListener) {
        this._listenerList.remove(RangeDataListener.class, rangeDataListener);
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this._listenerList.getListeners(clazz);
    }

    private void fireMarkerDataEvent(MarkerDataEventType markerDataEventType, RangeMarker rangeMarker) {
        if (this.isAdjusting()) {
            return;
        }
        RangeDataEvent rangeDataEvent = new RangeDataEvent(this, markerDataEventType.name(), rangeMarker);
        Object[] objectArray = this._listenerList.getListenerList();
        block7: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RangeDataListener.class) continue;
            switch (markerDataEventType) {
                case VALUE_CHANGED: {
                    ((RangeDataListener)objectArray[i + 1]).valueChanged(rangeDataEvent);
                    continue block7;
                }
                case POSITION_CHANGED: {
                    ((RangeDataListener)objectArray[i + 1]).positionChanged(rangeDataEvent);
                    continue block7;
                }
                case MARKER_ADDED: {
                    ((RangeDataListener)objectArray[i + 1]).markerAdded(rangeDataEvent);
                    continue block7;
                }
                case MARKER_REMOVED: {
                    ((RangeDataListener)objectArray[i + 1]).markerRemoved(rangeDataEvent);
                    continue block7;
                }
                case ALL_CHANGED: {
                    ((RangeDataListener)objectArray[i + 1]).allChanged(rangeDataEvent);
                    continue block7;
                }
            }
        }
    }

    @Override
    public final boolean isAdjusting() {
        return this._adjusting;
    }

    @Override
    public final void setAdjusting(boolean bl) {
        boolean bl2 = this._adjusting;
        this._adjusting = bl;
        if (!this._adjusting || bl2 != this._adjusting) {
            this.fireAllChanged();
        }
    }

    private static enum MarkerDataEventType {
        VALUE_CHANGED,
        POSITION_CHANGED,
        MARKER_ADDED,
        MARKER_REMOVED,
        ALL_CHANGED;

    }
}

