/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.resamplingmodes;

import edu.geophys.commons.resamplingmodes.ResamplingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class DefaultResamplingModes {
    public static final ResamplingMode[] MODES = new ResamplingMode[]{new ResamplingMode("(Sonogram 4 - 200 Hz) for geotechnical engineering", 1000.0f, 125, 11, 7500L), new ResamplingMode("(Sonogram 2 - 100 Hz) for close range seismicity", 500.0f, 125, 11, 15000L), new ResamplingMode("(Sonogram 1 - 50 Hz) for local  seismicity", 250.0f, 125, 11, 30000L), new ResamplingMode("(Sonogram 0.4 - 40 Hz) for local/regional seismicity", 100.0f, 120, 13, 72000L), new ResamplingMode("(Sonogram 6s - 16 Hz) for regional seismicity", 40.0f, 120, 13, 180000L), new ResamplingMode("(Sonogram 12s - 8 Hz) for regional/tele seismicity", 20.0f, 120, 13, 360000L), new ResamplingMode("(Sonogram 24s - 4 Hz) for teleseismicity", 10.0f, 120, 13, 720000L)};

    public static final ResamplingMode getModeByIndex(int n) {
        ResamplingMode resamplingMode = n >= 0 && n < MODES.length ? MODES[n] : MODES[MODES.length / 2];
        return resamplingMode;
    }

    public static final ResamplingMode getModeByFrequency(final float f) {
        List<ResamplingMode> list = Arrays.asList((ResamplingMode[])MODES.clone());
        list.sort(new Comparator<ResamplingMode>(){

            @Override
            public int compare(ResamplingMode resamplingMode, ResamplingMode resamplingMode2) {
                return Float.compare(this.measure(resamplingMode), this.measure(resamplingMode2));
            }

            private float measure(ResamplingMode resamplingMode) {
                return Math.abs(resamplingMode.getMasterSamplingRate() - f) / Math.abs(f);
            }
        });
        return list.get(0);
    }
}

