/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.resources;

import edu.geophys.commons.resources.Colors;
import java.awt.Color;
import java.util.Arrays;

public class ColorRamp {
    private static Color[] BRIGHT_SONO_COLORS = null;

    public static Color getBrightSonogram(double d, double d2, double d3) {
        if (BRIGHT_SONO_COLORS == null) {
            BRIGHT_SONO_COLORS = Arrays.copyOfRange(Colors.SONOGRAM, 2, 8);
        }
        int n = BRIGHT_SONO_COLORS.length - 1;
        if (d3 <= d2) {
            return BRIGHT_SONO_COLORS[n];
        }
        if (d >= d3) {
            return BRIGHT_SONO_COLORS[n];
        }
        if (d <= d2) {
            return BRIGHT_SONO_COLORS[0];
        }
        double d4 = (double)n * (d - d2) / (d3 - d2);
        int n2 = (int)d4;
        Color color = BRIGHT_SONO_COLORS[n2];
        int n3 = n2 + 1;
        Color color2 = BRIGHT_SONO_COLORS[n3];
        double d5 = 1.0 - (d4 - (double)n2);
        double d6 = 1.0 - ((double)n3 - d4);
        return new Color((int)(d5 * (double)color.getRed() + d6 * (double)color2.getRed()), (int)(d5 * (double)color.getGreen() + d6 * (double)color2.getGreen()), (int)(d5 * (double)color.getBlue() + d6 * (double)color2.getBlue()));
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 2;
        System.out.println("nLayers=" + n2);
        for (n = 0; n < n2; ++n) {
            System.out.println("n=" + n + "   " + ColorRamp.getBrightSonogram(n, 0.0, n2 - 1));
        }
        System.out.println("");
        n2 = BRIGHT_SONO_COLORS.length;
        System.out.println("nLayers=" + n2);
        for (n = 0; n < n2; ++n) {
            System.out.println("n=" + n + "   " + ColorRamp.getBrightSonogram(n, 0.0, n2 - 1));
        }
        System.out.println("");
        n2 = BRIGHT_SONO_COLORS.length + 4;
        System.out.println("nLayers=" + n2);
        for (n = 0; n < n2; ++n) {
            System.out.println("n=" + n + "   " + ColorRamp.getBrightSonogram(n, 0.0, n2 - 1));
        }
    }
}

