/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.suite;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.detection.BulletinDetection;
import edu.geophys.commons.detection.DetectionXmlFile;
import edu.geophys.commons.detection.SonoViewDetection;
import edu.geophys.commons.detection.SonoViewPick;
import edu.geophys.commons.detection.TimestringDetection;
import edu.geophys.commons.suite.SuiteManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EventFileManager {
    private static final int FUZZY_VALUE = 5;
    static final String BULLETINS_DIR = "bulletins";
    private List<SonoViewDetection> detections = this.readDetectionXml();
    private List<AbstractDetection> bulletinEvents = this.readBulletinDir();

    public EventFileManager(String string) {
    }

    public EventFileManager() {
        this(SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getAbsolutePath());
    }

    private List<SonoViewDetection> readDetectionXml() {
        ArrayList<SonoViewDetection> arrayList = null;
        try {
            DetectionXmlFile detectionXmlFile = new DetectionXmlFile();
            detectionXmlFile.load();
            arrayList = detectionXmlFile.getDetections();
        }
        catch (Exception exception) {
            arrayList = new ArrayList();
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void writeDetectionXml() {
        DetectionXmlFile detectionXmlFile = new DetectionXmlFile();
        detectionXmlFile.setDetections((ArrayList)this.detections);
        detectionXmlFile.store();
    }

    private List<AbstractDetection> readBulletinDir() {
        ArrayList<AbstractDetection> arrayList = new ArrayList<AbstractDetection>();
        File file = new File(SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getAbsolutePath() + File.separator + BULLETINS_DIR);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                ArrayList<AbstractDetection> arrayList2 = file2.getName().toLowerCase().endsWith("fdsn") ? BulletinDetection.readFromFdsnFile(file2) : TimestringDetection.readFromFile(file2);
                if (arrayList2 == null) continue;
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    public void removeDetection(AbstractDetection abstractDetection) {
        if (this.detections.contains(abstractDetection)) {
            this.detections.remove(abstractDetection);
            SuiteManager.INSTANCE.getGlobalEventWindowModel().firePropertyChange("eventMarkers", true, false);
        }
        this.writeDetectionXml();
    }

    public AbstractDetection getDetectionAt(long l) {
        AbstractDetection abstractDetection = null;
        for (AbstractDetection abstractDetection2 : this.getAllDetectionEntries()) {
            long l2 = abstractDetection2.getStartTimeMs();
            long l3 = abstractDetection2.getEndTimeMs();
            if (l < l2 || l > l3) continue;
            abstractDetection = abstractDetection2;
        }
        return abstractDetection;
    }

    public List<AbstractDetection> getAllDetectionsAt(long l) {
        float f = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
        long l2 = (long)(1280000.0f / f);
        ArrayList<AbstractDetection> arrayList = new ArrayList<AbstractDetection>();
        for (AbstractDetection abstractDetection : this.getAllDetectionEntries()) {
            if (Math.abs(abstractDetection.getIndexTimeMs() - l) >= l2) continue;
            arrayList.add(abstractDetection);
        }
        return arrayList;
    }

    public static boolean checkForArrayId(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public List<AbstractDetection> getAllDetectionEntries() {
        ArrayList<AbstractDetection> arrayList = new ArrayList<AbstractDetection>();
        arrayList.addAll(this.bulletinEvents);
        arrayList.addAll(this.detections);
        return arrayList;
    }

    public List<SonoViewDetection> getSonoViewDetections() {
        return this.detections;
    }

    public List<AbstractDetection> getAllDetectionsInTimeWindow(double d, double d2) {
        ArrayList<AbstractDetection> arrayList = new ArrayList<AbstractDetection>();
        for (AbstractDetection abstractDetection : this.getAllDetectionEntries()) {
            boolean bl = true;
            double d3 = abstractDetection.getIndexTimeMs();
            double d4 = abstractDetection.getEndTimeMs();
            if (d3 > d2 * 1000.0) {
                bl = false;
            }
            if (d4 < d * 1000.0) {
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(abstractDetection);
        }
        return arrayList;
    }

    public List<SonoViewDetection> getPatternDates(List<SonoViewDetection> list, String string, double d, double d2) {
        ArrayList<SonoViewDetection> arrayList = new ArrayList<SonoViewDetection>();
        for (SonoViewDetection sonoViewDetection : list) {
            SonoViewPick sonoViewPick = sonoViewDetection.getPick();
            if (sonoViewPick == null || !((double)sonoViewDetection.getEndTimeMs() > d * 1000.0) || !((double)sonoViewDetection.getStartTimeMs() < d2 * 1000.0) || !EventFileManager.checkForArrayId(sonoViewPick.getTraceIDs(), string)) continue;
            arrayList.add(sonoViewDetection);
        }
        return arrayList;
    }
}

