/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.suite;

import edu.geophys.commons.model.headerfiles.HeaderDatabase;
import edu.geophys.commons.model.knowledgebase.Knowledgebase;
import edu.geophys.commons.suite.DefaultTraceProvider;
import edu.geophys.commons.suite.EventFileManager;
import edu.geophys.commons.suite.EventWindowModel;
import edu.geophys.commons.suite.TraceProvider;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.util.ErrorConsoleUtil;
import edu.geophys.commons.util.ProjectDirectories;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public enum SuiteManager {
    INSTANCE;

    public final String SUITE_GIT_INFO = SuiteManager.getGitInfo();
    public static final boolean LOCAL_FEATURES = false;
    private List<ChangeListener> listenerList;
    private ChangeEvent dataChangeEvent;
    private EventWindowModel globalEventWindowModel = null;
    private BoundedLongRangeModel sonoViewTimeModel = null;
    private TraceProvider traceProvider = null;
    private ProjectDirectories projectDirectories = null;
    private Knowledgebase knowledgebase = null;
    private EventFileManager eventFileManager = null;
    private ErrorConsoleUtil errorConsoleUtil = null;

    public final EventWindowModel getGlobalEventWindowModel() {
        return this.globalEventWindowModel;
    }

    public final File getWorkingFolder() {
        return this.projectDirectories.getWorkingDirectory();
    }

    public final ProjectDirectories getProjectDirectories() {
        return this.projectDirectories;
    }

    public final TraceProvider getTraceProvider() {
        return this.traceProvider;
    }

    public final Knowledgebase getKnowledgebase() {
        return this.knowledgebase;
    }

    public final EventFileManager getEventFileManager() {
        return this.eventFileManager;
    }

    public final void setCurrentData(ProjectDirectories projectDirectories, HeaderDatabase headerDatabase) {
        if (projectDirectories != null) {
            this.listenerList = new ArrayList<ChangeListener>();
            this.dataChangeEvent = new ChangeEvent((Object)this);
            this.globalEventWindowModel = new EventWindowModel();
            this.sonoViewTimeModel = new DefaultBoundedLongRangeModel();
            this.projectDirectories = projectDirectories;
            this.traceProvider = new DefaultTraceProvider(headerDatabase);
            this.knowledgebase = new Knowledgebase(projectDirectories);
            this.eventFileManager = new EventFileManager();
        } else {
            this.globalEventWindowModel = new EventWindowModel();
            this.sonoViewTimeModel = new DefaultBoundedLongRangeModel();
            this.listenerList = new ArrayList<ChangeListener>();
            this.dataChangeEvent = new ChangeEvent((Object)this);
            this.projectDirectories = null;
            this.traceProvider = null;
            this.knowledgebase = null;
            this.eventFileManager = null;
        }
        this.fireDataChangeEvent();
    }

    public void fireDataChangeEvent() {
        for (ChangeListener changeListener : this.listenerList) {
            changeListener.stateChanged(this.dataChangeEvent);
        }
    }

    public void addDataChangeListener(ChangeListener changeListener) {
        this.listenerList.add(changeListener);
    }

    public void removeDataChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(changeListener);
    }

    public ErrorConsoleUtil getErrorConsoleUtil() {
        if (this.errorConsoleUtil == null) {
            this.errorConsoleUtil = new ErrorConsoleUtil();
        }
        return this.errorConsoleUtil;
    }

    public BoundedLongRangeModel getSonoViewTimeModel() {
        return this.sonoViewTimeModel;
    }

    public void setSonoViewTimeModel(BoundedLongRangeModel boundedLongRangeModel) {
        this.sonoViewTimeModel = boundedLongRangeModel;
    }

    private static String getGitInfo() {
        String string = "";
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader("gitinfo.txt"));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string2;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "DEBUGGING";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }
}

