/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.ui.AbstractChangeReportingModel;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;

public class DefaultBoundedLongRangeModel
extends AbstractChangeReportingModel
implements BoundedLongRangeModel {
    private long value = 0L;
    private long extent = 0L;
    private long min = 0L;
    private long max = 100L;
    private long inc = 1L;
    private boolean isAdjusting = false;

    public DefaultBoundedLongRangeModel() {
    }

    public DefaultBoundedLongRangeModel(long l, long l2, long l3, long l4, long l5) {
        if (l + l2 > l4) {
            l = l4 - l2;
            LogUtil.warn(this.getClass(), "value + extent of time model was greater then maximal value, reseting value to max - extent");
        }
        if (l4 < l3 || l < l3 || l + l2 < l || l5 <= 0L) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = l;
        this.extent = l2;
        this.min = l3;
        this.max = l4;
        this.inc = l5;
    }

    public DefaultBoundedLongRangeModel(BoundedLongRangeModel boundedLongRangeModel) {
        this.value = boundedLongRangeModel.getValue();
        this.extent = boundedLongRangeModel.getExtent();
        this.min = boundedLongRangeModel.getMinimum();
        this.max = boundedLongRangeModel.getMaximum();
        this.inc = boundedLongRangeModel.getIncrement();
        this.isAdjusting = boundedLongRangeModel.getValueIsAdjusting();
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public long getExtent() {
        return this.extent;
    }

    @Override
    public long getMinimum() {
        return this.min;
    }

    @Override
    public long getMaximum() {
        return this.max;
    }

    @Override
    public void setValue(long l) {
        long l2 = Math.max(l = Math.min(l, Long.MAX_VALUE - this.extent), this.min);
        if (l2 + this.extent > this.max) {
            l2 = this.max - this.extent;
        }
        this.setRangeProperties(l2, this.extent, this.min, this.max, this.inc, this.isAdjusting);
    }

    @Override
    public void setExtent(long l) {
        long l2 = Math.max(0L, l);
        if (this.value + l2 > this.max) {
            l2 = this.max - this.value;
        }
        this.setRangeProperties(this.value, l2, this.min, this.max, this.inc, this.isAdjusting);
    }

    @Override
    public void setMinimum(long l) {
        long l2 = Math.max(l, this.max);
        long l3 = Math.max(l, this.value);
        long l4 = Math.min(l2 - l3, this.extent);
        this.setRangeProperties(l3, l4, l, l2, this.inc, this.isAdjusting);
    }

    @Override
    public void setMaximum(long l) {
        long l2 = Math.min(l, this.min);
        long l3 = Math.min(l - l2, this.extent);
        long l4 = Math.min(l - l3, this.value);
        this.setRangeProperties(l4, l3, l2, l, this.inc, this.isAdjusting);
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, this.inc, bl);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public long getIncrement() {
        return this.inc;
    }

    @Override
    public void setIncrement(long l) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, l, this.isAdjusting);
    }

    @Override
    public void setRangeProperties(long l, long l2, long l3, long l4, long l5, boolean bl) {
        boolean bl2;
        if (l3 > l4) {
            l3 = l4;
        }
        if (l > l4) {
            l4 = l;
        }
        if (l < l3) {
            l3 = l;
        }
        if (l4 - l2 - l < 0L) {
            l2 = l4 - l;
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l5 < 1L) {
            l5 = 1L;
        } else {
            l = MathUtil.round(l, l5);
            l2 = MathUtil.round(l2, l5);
        }
        boolean bl3 = bl2 = l != this.value || l2 != this.extent || l3 != this.min || l4 != this.max || l5 != this.inc || bl != this.isAdjusting;
        if (bl2) {
            this.value = l;
            this.extent = l2;
            this.min = l3;
            this.max = l4;
            this.isAdjusting = bl;
            this.inc = l5;
            this.fireStateChanged();
        }
    }

    @Override
    public void setRangeProperties(BoundedLongRangeModel boundedLongRangeModel) {
        this.setRangeProperties(boundedLongRangeModel.getValue(), boundedLongRangeModel.getExtent(), boundedLongRangeModel.getMinimum(), boundedLongRangeModel.getMaximum(), boundedLongRangeModel.getIncrement(), boundedLongRangeModel.getValueIsAdjusting());
    }

    public String toString() {
        String string = "value=" + this.getValue() + ", extent=" + this.getExtent() + ", minimum=" + this.getMinimum() + ", maximum=" + this.getMaximum() + ", increment=" + this.getIncrement() + ", adjusting=" + this.getValueIsAdjusting();
        return this.getClass().getName() + "[" + string + "]";
    }
}

