/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class PolyModel {
    private GeneralPath polyPath;
    private Color lineColor = Color.BLACK;
    private Stroke stroke = new BasicStroke(1.0f);
    private Color fillColor = Color.WHITE;
    private boolean polyline = true;
    private boolean polygon = false;
    private String station1;
    private String station2;
    private ValidStatus valid = ValidStatus.NonExistant;
    private PolyType type = PolyType.OTHER;

    public PolyModel(float f, float f2, int n, String string, String string2, PolyType polyType) {
        this(n);
        this.polyPath.moveTo(f, f2);
        this.station1 = string;
        this.station2 = string2;
        this.type = polyType;
    }

    private PolyModel() {
        this(new GeneralPath(0));
    }

    private PolyModel(int n) {
        this(new GeneralPath(0, n));
    }

    private PolyModel(float f, float f2) {
        this(1);
        this.polyPath.moveTo(f, f2);
    }

    private PolyModel(GeneralPath generalPath) {
        this.polyPath = generalPath;
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(Color color) {
        this.lineColor = color;
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(Color color) {
        this.fillColor = color;
    }

    public final boolean isPolygon() {
        return this.polygon;
    }

    public final void setPolyline(boolean bl) {
        this.polyline = bl;
    }

    public final boolean isPolyline() {
        return this.polyline;
    }

    public final void setPolygon(boolean bl) {
        this.polygon = bl;
    }

    public GeneralPath getPath() {
        return this.polyPath;
    }

    public final void moveTo(float f, float f2) {
        this.polyPath.moveTo(f, f2);
    }

    public final void lineTo(float f, float f2) {
        this.polyPath.lineTo(f, f2);
    }

    public final void reset() {
        this.polyPath.reset();
    }

    public final void closePath() {
        this.polyPath.closePath();
    }

    public final Shape createTransformedShape(AffineTransform affineTransform) {
        return this.polyPath.createTransformedShape(affineTransform);
    }

    public final void transform(AffineTransform affineTransform) {
        this.polyPath.transform(affineTransform);
    }

    public String getStation1() {
        return this.station1;
    }

    public void setStation1(String string) {
        this.station1 = string;
    }

    public String getStation2() {
        return this.station2;
    }

    public void setStation2(String string) {
        this.station2 = string;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public ValidStatus getValid() {
        return this.valid;
    }

    public void setValid(ValidStatus validStatus) {
        this.valid = validStatus;
    }

    public PolyType getType() {
        return this.type;
    }

    public void setType(PolyType polyType) {
        this.type = polyType;
    }

    public static enum PolyType {
        PP_HYPERBOLA,
        SP_CIRCLE,
        OTHER;

    }

    public static enum ValidStatus {
        NonExistant,
        Valid,
        Outside,
        Invalid;

    }
}

