/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.resources.Colors;
import edu.geophys.commons.ui.AbstractPaint;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class SingleSonoPaint
extends AbstractPaint {
    private static final long serialVersionUID = 1L;
    private BufferedImage buffer;
    private int[][] values;

    public SingleSonoPaint(int[][] nArray) {
        this.setValues(nArray);
    }

    public SingleSonoPaint(double[][] dArray) {
        this.setValues(dArray);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.buffer != null) {
            int n = this.getBorder().getBorderInsets((Component)this).top;
            int n2 = this.getBorder().getBorderInsets((Component)this).bottom;
            int n3 = this.getBorder().getBorderInsets((Component)this).left;
            int n4 = this.getBorder().getBorderInsets((Component)this).right;
            graphics.drawImage(this.buffer, n3, n, this.getWidth() - n3 - n4, this.getHeight() - n - n2, this);
        }
    }

    public void setValues(double[][] dArray) {
        this.values = new int[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                this.values[i][j] = (int)Math.round(dArray[i][j]);
            }
        }
        this.setValues(this.values);
    }

    public void setValues(int[][] nArray) {
        this.values = nArray;
        this.buffer = new BufferedImage(nArray[0].length, nArray.length, 1);
        this.buffer.createGraphics();
        Graphics graphics = this.buffer.getGraphics();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                graphics.setColor(nArray[i][j] > 11 ? Colors.SONOGRAM[11] : (nArray[i][j] < 0 ? Colors.SONOGRAM[0] : Colors.SONOGRAM[nArray[i][j]]));
                graphics.fillRect(j, i, 1, 1);
            }
        }
        this.repaint();
    }

    public int[][] getValues() {
        return this.values;
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public void setBuffer(BufferedImage bufferedImage) {
        this.buffer = bufferedImage;
    }
}

