/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.map.mapimageloader;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.map.mapimageloader.ImagePointsPickPanel;
import edu.geophys.commons.ui.map.mapimageloader.MapImageCoordinate;
import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.commons.util.LogUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import layout.TableLayout;

public class MapImageLoadingDialog
extends JFrame {
    static final long serialVersionUID = 934037264L;
    protected static final int MARKERSIZE = 20;
    private static MapImageCoordinate[] imageCoordinates = new MapImageCoordinate[2];
    private static File imageFile;
    private static BufferedImage imageToPrepare;
    private static boolean imageLoaded;
    private static JPanel coordinateDefinePanel;
    private static JTextField latitudeInputField;
    private static JTextField longitudeInputField;
    private static JScrollPane coordinateScrollPane;
    private static int clickXcoordinate;
    private static int clickYcoordinate;
    private static JButton setUpperLeftCoordinatesButton;
    private static JButton setLowerRightCoordinatesButton;
    private static JLabel errorOutputLabel;
    private static MapImageLoadingDialog mainframe;

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MapImageLoadingDialog.this.setVisible(false);
                MapImageLoadingDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        coordinateDefinePanel = new ImagePointsPickPanel();
        coordinateDefinePanel.setBackground(new Color(255, 255, 255));
        coordinateDefinePanel.setSize(new Dimension(300, 200));
        coordinateDefinePanel.setEnabled(false);
        coordinateDefinePanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (imageLoaded) {
                    clickXcoordinate = mouseEvent.getX();
                    clickYcoordinate = mouseEvent.getY();
                    MapImageLoadingDialog.this.drawMarkers();
                }
            }
        });
        coordinateDefinePanel.validate();
        coordinateScrollPane = new JScrollPane(coordinateDefinePanel);
        JButton jButton = new JButton("Load new image file");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapImageLoadingDialog.this.loadFile();
            }
        };
        jButton.addActionListener(actionListener);
        JLabel jLabel = new JLabel("Latitude of selected point:");
        latitudeInputField = new JTextField();
        JLabel jLabel2 = new JLabel("Longitude of selected point:");
        longitudeInputField = new JTextField();
        JButton jButton2 = new JButton("Set first reference point");
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MapImageLoadingDialog.imageCoordinates[0] = new MapImageCoordinate(clickXcoordinate, clickYcoordinate, Double.parseDouble(latitudeInputField.getText()), Double.parseDouble(longitudeInputField.getText()));
                    MapImageLoadingDialog.this.drawMarkers();
                    LogUtil.info(this.getClass(), "Reference point one set");
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), "Error creating reference point one");
                }
            }
        };
        jButton2.addActionListener(actionListener2);
        JButton jButton3 = new JButton("Set second reference point");
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MapImageLoadingDialog.imageCoordinates[1] = new MapImageCoordinate(clickXcoordinate, clickYcoordinate, Double.parseDouble(latitudeInputField.getText()), Double.parseDouble(longitudeInputField.getText()));
                    MapImageLoadingDialog.this.drawMarkers();
                    LogUtil.info(this.getClass(), "Reference point two set");
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), "Error creating reference point two");
                }
            }
        };
        jButton3.addActionListener(actionListener3);
        errorOutputLabel = new JLabel();
        JButton jButton4 = new JButton("Import loaded image into knowbase");
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapImageLoadingDialog.this.importImage();
            }
        };
        jButton4.addActionListener(actionListener4);
        JButton jButton5 = new JButton("Cancel");
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mainframe.dispose();
            }
        };
        jButton5.addActionListener(actionListener5);
        setUpperLeftCoordinatesButton = new JButton("set refpoint 1 to upper left corner");
        ActionListener actionListener6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (imageLoaded) {
                        MapImageLoadingDialog.imageCoordinates[0] = new MapImageCoordinate(1L, 1L, Double.parseDouble(latitudeInputField.getText()), Double.parseDouble(longitudeInputField.getText()));
                        MapImageLoadingDialog.this.drawMarkers();
                        LogUtil.info(this.getClass(), "Reference point one set");
                        errorOutputLabel.setText("Reference point 1 set to upper left corner with given coordinates");
                    } else {
                        errorOutputLabel.setText("No image loaded. Don't fool me");
                    }
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), "Error creating reference point one");
                }
            }
        };
        setUpperLeftCoordinatesButton.addActionListener(actionListener6);
        setLowerRightCoordinatesButton = new JButton("set refpoint 2 to lower right corner");
        ActionListener actionListener7 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (imageLoaded) {
                        MapImageLoadingDialog.imageCoordinates[1] = new MapImageCoordinate(imageToPrepare.getWidth() - 1, imageToPrepare.getHeight() - 1, Double.parseDouble(latitudeInputField.getText()), Double.parseDouble(longitudeInputField.getText()));
                        MapImageLoadingDialog.this.drawMarkers();
                        LogUtil.info(this.getClass(), "Reference point one set");
                        errorOutputLabel.setText("Reference point 2 set to lower right corner with given coordinates");
                    } else {
                        errorOutputLabel.setText("No image loaded. Don't fool me");
                    }
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), "Error creating reference point two");
                }
            }
        };
        setLowerRightCoordinatesButton.addActionListener(actionListener7);
        TableLayout tableLayout = new TableLayout();
        tableLayout.insertColumn(0, -3.0);
        tableLayout.insertRow(0, -3.0);
        tableLayout.insertRow(1, -3.0);
        tableLayout.insertRow(2, -3.0);
        tableLayout.insertRow(3, -3.0);
        tableLayout.insertRow(4, -3.0);
        tableLayout.insertRow(5, -3.0);
        tableLayout.insertRow(6, -3.0);
        tableLayout.insertRow(7, -3.0);
        tableLayout.insertRow(8, -3.0);
        tableLayout.insertRow(9, -3.0);
        tableLayout.insertRow(10, -3.0);
        tableLayout.insertRow(11, -3.0);
        JPanel jPanel2 = new JPanel((LayoutManager)tableLayout);
        jPanel2.add((Component)jButton, "0, 0");
        jPanel2.add((Component)jLabel, "0, 1");
        jPanel2.add((Component)latitudeInputField, "0, 2");
        jPanel2.add((Component)jLabel2, "0, 3");
        jPanel2.add((Component)longitudeInputField, "0, 4");
        jPanel2.add((Component)jButton2, "0, 5");
        jPanel2.add((Component)jButton3, "0, 6");
        jPanel2.add((Component)jButton4, "0, 7");
        jPanel2.add((Component)setUpperLeftCoordinatesButton, "0, 8");
        jPanel2.add((Component)setLowerRightCoordinatesButton, "0, 9");
        jPanel2.add((Component)errorOutputLabel, "0, 10");
        jPanel2.add((Component)jButton5, "0, 11");
        TableLayout tableLayout2 = new TableLayout();
        tableLayout2.insertRow(0, -1.0);
        tableLayout2.insertColumn(0, -3.0);
        tableLayout2.insertColumn(1, -1.0);
        jPanel.setLayout((LayoutManager)tableLayout2);
        jPanel.add((Component)jPanel2, "0, 0");
        jPanel.add((Component)coordinateScrollPane, "1, 0");
        jPanel.setVisible(true);
        this.add(jPanel);
        this.validate();
        this.pack();
    }

    private void loadFile() {
        block5: {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Select the image to load");
            jFileChooser.setApproveButtonText("Open File");
            jFileChooser.showOpenDialog(null);
            File file = jFileChooser.getSelectedFile();
            try {
                imageToPrepare = ImageIO.read(file);
                imageFile = file;
                imageLoaded = true;
                coordinateDefinePanel.setSize(imageToPrepare.getWidth(), imageToPrepare.getHeight());
                coordinateDefinePanel.setEnabled(true);
                if (file.getName().endsWith(".geotiff") || file.getName().endsWith(".Geotiff")) {
                    // empty if block
                }
                errorOutputLabel.setText("");
                this.drawMarkers();
            }
            catch (Exception exception) {
                LogUtil.error(this.getClass(), "Error loading image");
                LogUtil.error(this.getClass(), "Error loading image");
                if (!imageLoaded) break block5;
                try {
                    imageToPrepare = ImageIO.read(imageFile);
                }
                catch (Exception exception2) {
                    LogUtil.error(this.getClass(), "Error loading previously used image. File moved/deleted?");
                }
            }
        }
    }

    private void drawMarkers() {
        if (!coordinateDefinePanel.isEnabled() || !imageLoaded) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(imageToPrepare.getWidth(this), imageToPrepare.getHeight(this), 5);
        bufferedImage.createGraphics();
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(imageToPrepare, 0, 0, imageToPrepare.getWidth(this), imageToPrepare.getHeight(this), 0, 0, imageToPrepare.getWidth(this), imageToPrepare.getHeight(this), this);
        if (clickXcoordinate >= 0 && clickYcoordinate >= 0) {
            graphics.setColor(new Color(255, 0, 0));
            graphics.drawArc(clickXcoordinate - 10, clickYcoordinate - 10, 20, 20, 0, 360);
            graphics.drawLine(clickXcoordinate - 10, clickYcoordinate, clickXcoordinate + 10, clickYcoordinate);
            graphics.drawLine(clickXcoordinate, clickYcoordinate - 10, clickXcoordinate, clickYcoordinate + 10);
        }
        for (int i = 0; i < imageCoordinates.length; ++i) {
            if (imageCoordinates[i] == null) continue;
            graphics.setColor(new Color(50 * i, 50 * (imageCoordinates.length - i), 255 - 50 * i));
            graphics.drawArc((int)imageCoordinates[i].getXcoordinate() - 10, (int)imageCoordinates[i].getYcoordinate() - 10, 20, 20, 0, 360);
            graphics.drawLine((int)imageCoordinates[i].getXcoordinate() - 10, (int)imageCoordinates[i].getYcoordinate(), (int)imageCoordinates[i].getXcoordinate() + 10, (int)imageCoordinates[i].getYcoordinate());
            graphics.drawLine((int)imageCoordinates[i].getXcoordinate(), (int)imageCoordinates[i].getYcoordinate() - 10, (int)imageCoordinates[i].getXcoordinate(), (int)imageCoordinates[i].getYcoordinate() + 10);
            graphics.drawBytes(Integer.toString(i + 1).getBytes(), 0, 1, (int)imageCoordinates[i].getXcoordinate() + 10, (int)imageCoordinates[i].getYcoordinate() + 10);
        }
        Graphics graphics2 = coordinateDefinePanel.getGraphics();
        graphics2.drawImage(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), this);
        coordinateDefinePanel.paintComponents(graphics2);
        coordinateScrollPane.repaint();
    }

    private void importImage() {
        if (imageLoaded) {
            for (int i = 0; i < imageCoordinates.length; ++i) {
                if (imageCoordinates[i] != null && imageCoordinates[i].isInitialized()) continue;
                LogUtil.error(this.getClass(), "Not enough reference coordinates given", true);
                errorOutputLabel.setText("not enough coordinates given");
                return;
            }
            if (imageCoordinates[0].getLatitude() == imageCoordinates[1].getLatitude() || imageCoordinates[0].getLongitude() == imageCoordinates[1].getLongitude()) {
                errorOutputLabel.setText("<html>Identical longitude or latitude of both reference points. <br> Reset one reference point </html>");
            } else {
                String string = SuiteManager.INSTANCE.getKnowledgebase().getKnowledgeFolder().getAbsolutePath();
                CoordinateUtil.RelativeResult relativeResult = CoordinateUtil.convertAbsoluteToRelative(imageCoordinates[0].getLatitude(), imageCoordinates[0].getLongitude(), imageCoordinates[1].getLatitude(), imageCoordinates[1].getLongitude());
                double d = Math.abs(relativeResult.xOffset);
                double d2 = Math.abs(relativeResult.yOffset);
                long l = Math.abs(imageCoordinates[1].getXcoordinate() - imageCoordinates[0].getXcoordinate());
                long l2 = Math.abs(imageCoordinates[1].getYcoordinate() - imageCoordinates[0].getYcoordinate());
                double d3 = d / (double)l;
                double d4 = d2 / (double)l2;
                CoordinateUtil.AbsoluteResult absoluteResult = CoordinateUtil.convertRelativeToAbsolute(imageCoordinates[0].getLatitude(), imageCoordinates[0].getLongitude(), -((double)imageCoordinates[0].getXcoordinate()) * d3, (double)imageCoordinates[0].getYcoordinate() * d4);
                d3 *= 1000.0;
                d4 *= 1000.0;
                try {
                    ImageIO.write((RenderedImage)imageToPrepare, "jpg", new File(string + File.separator + "map.jpg"));
                }
                catch (IOException iOException) {
                    LogUtil.error(this.getClass(), "error saving image file");
                    iOException.printStackTrace();
                }
                try {
                    File file = new File(string + File.separator + "map.jgw");
                    FileWriter fileWriter = new FileWriter(file);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(d3 + "\n");
                    bufferedWriter.write("0\n");
                    bufferedWriter.write("0\n");
                    bufferedWriter.write("-" + d4 + "\n");
                    bufferedWriter.write(absoluteResult.longitude + "\n");
                    bufferedWriter.write(absoluteResult.latitude + "\n");
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), "Error while saving map.jgw in " + string);
                    exception.printStackTrace();
                }
            }
        } else {
            LogUtil.error(this.getClass(), "No image opened. Can not create anything.", true);
            return;
        }
        LogUtil.info(this.getClass(), "Image sucessfully loaded");
        this.dispose();
    }

    public MapImageLoadingDialog() {
        mainframe = this;
        this.initialize();
    }

    static {
        imageLoaded = false;
        clickXcoordinate = -1;
        clickYcoordinate = -1;
    }
}

