/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.range;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.range.TimeAxisEventMarkers;
import edu.geophys.commons.ui.time.JTimeAxis;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

public class JTimeRangeSelection
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTimeAxis timeAxis;
    private TimeAxisEventMarkers timeAxisEventMarkers;
    private double minThreshold = 0.1;
    private double maxThreshold = 0.9;

    public JTimeRangeSelection() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.getTimeAxisEventMarkers(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.getTimeAxis(), gridBagConstraints);
        this.setOpaque(true);
        this.setModel(this.getModel());
    }

    public BoundedLongRangeModel getModel() {
        return this.getTimeAxis().getModel();
    }

    public void setModel(BoundedLongRangeModel boundedLongRangeModel) {
        this.getTimeAxis().setModel(boundedLongRangeModel);
        this.getTimeAxisEventMarkers().setModel(boundedLongRangeModel);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.getTimeAxisEventMarkers().setBackground(color);
        this.getTimeAxis().setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.getTimeAxisEventMarkers().setForeground(color);
        this.getTimeAxis().setForeground(color);
    }

    public final Color getSelectionBackground() {
        return this.getTimeAxisEventMarkers().getSelectionBackground();
    }

    public final Color getSelectionForeground() {
        return this.getTimeAxisEventMarkers().getSelectionForeground();
    }

    public final void setSelectionBackground(Color color) {
        this.getTimeAxisEventMarkers().setSelectionBackground(color);
    }

    public final void setSelectionForeground(Color color) {
        this.getTimeAxisEventMarkers().setSelectionForeground(color);
    }

    public final void setShowEventMarkers(boolean bl) {
        this.getTimeAxisEventMarkers().setShowEventMarkers(bl);
    }

    protected final TimeAxisEventMarkers getTimeAxisEventMarkers() {
        if (this.timeAxisEventMarkers == null) {
            this.timeAxisEventMarkers = new TimeAxisEventMarkers();
        }
        return this.timeAxisEventMarkers;
    }

    protected final JTimeAxis getTimeAxis() {
        if (this.timeAxis == null) {
            this.timeAxis = new JTimeAxis();
        }
        return this.timeAxis;
    }

    public final double getMinThreshold() {
        return this.minThreshold;
    }

    public final void setMinThreshold(double d) {
        this.minThreshold = d;
    }

    public final double getMaxThreshold() {
        return this.maxThreshold;
    }

    public final void setMaxThreshold(double d) {
        this.maxThreshold = d;
    }
}

