/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.sonogram;

import edu.geophys.commons.resources.Colors;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.DefaultBoundedLongRangeModel;
import edu.geophys.commons.ui.sonogram.DelimiterSelectionRenderer;
import edu.geophys.commons.ui.sonogram.SelectionRenderer;
import edu.geophys.commons.ui.sonogram.SonogramColorModel;
import edu.geophys.commons.ui.sonogram.SonogramModel;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.SwingUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

abstract class AbstractSonogramComponent
extends JComponent {
    private static final long serialVersionUID = 5816387128830357260L;
    public static final String PROPERTY_COLOR_MODEL = "colorModel";
    public static final String PROPERTY_CURSOR_COLOR = "cursorColor";
    public static final String PROPERTY_RENDERED_SONOGRAM = "renderedSonogramModel";
    public static final String PROPERTY_SELECTION_COLOR = "selectionColor";
    public static final String PROPERTY_SELECTION_LINE_WIDTH = "selectionLineWidth";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    private AlphaComposite cursorComposite = AlphaComposite.getInstance(3, 0.8f);
    private boolean scalingEnabled = false;
    private SonogramColorModel sonogramColorModel = Colors.SONOGRAM_COLOR_MODEL;
    private Color cursorColor = Color.BLACK;
    private Color selectionColor = Color.BLACK;
    private int selectionLineWidth = 2;
    private SelectionRenderer selectionRenderer;
    private final Rectangle2D sonogramBounds = new Rectangle2D.Double();
    private boolean cursorEnabled = true;
    private boolean selectionEnabled = true;
    protected RenderedSonogramModel renderedSonogram = null;
    private BoundedLongRangeModel selectionModel = new DefaultBoundedLongRangeModel();
    private BoundedLongRangeModel cursorModel = new DefaultBoundedLongRangeModel();
    private int cursorPartition = -1;
    private final ChangeListener selectionModelChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AbstractSonogramComponent.this.repaint();
        }
    };
    private final ChangeListener cursorModelChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AbstractSonogramComponent.this.updateCursorPartition(AbstractSonogramComponent.this.getTimePartition(AbstractSonogramComponent.this.getCursorModel()));
        }
    };
    private double tileHeight = 1.0;
    private double tileWidth = 1.0;

    public AbstractSonogramComponent() {
        this.setSelectionRenderer(this.newDefaultSelectionRenderer());
        this.createListeners();
    }

    protected DelimiterSelectionRenderer newDefaultSelectionRenderer() {
        return new DelimiterSelectionRenderer();
    }

    public SelectionRenderer getSelectionRenderer() {
        return this.selectionRenderer;
    }

    public void setSelectionRenderer(SelectionRenderer selectionRenderer) {
        this.selectionRenderer = selectionRenderer;
        this.selectionRenderer.setParent(this);
        this.selectionRenderer.setColor(this.getSelectionColor());
        this.selectionRenderer.setSelection(this.getSelectionModel());
        this.selectionRenderer.setSonogram(this.renderedSonogram);
        this.repaint();
    }

    protected MouseAdapter newDefaultMouseMotionAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                AbstractSonogramComponent.this.updateCursorPartition(-1);
                AbstractSonogramComponent.this.cursorModel.setExtent(0L);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = AbstractSonogramComponent.this.getTimePartition(mouseEvent.getPoint());
                if (!AbstractSonogramComponent.this.hasValidData() || n < 0) {
                    return;
                }
                AbstractSonogramComponent.this.cursorModel.setRangeProperties(AbstractSonogramComponent.this.renderedSonogram.getStartTime() + (long)n * AbstractSonogramComponent.this.renderedSonogram.getTimeIncrement(), AbstractSonogramComponent.this.renderedSonogram.getTimeIncrement(), AbstractSonogramComponent.this.renderedSonogram.getStartTime(), AbstractSonogramComponent.this.renderedSonogram.getEndTime(), 1L, false);
            }
        };
    }

    protected MouseAdapter newDefaultMouseClickAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = AbstractSonogramComponent.this.getTimePartition(mouseEvent.getPoint());
                if (!AbstractSonogramComponent.this.hasValidData() || n < 0 || mouseEvent.isShiftDown()) {
                    return;
                }
                AbstractSonogramComponent.this.cursorModel.setRangeProperties(AbstractSonogramComponent.this.renderedSonogram.getStartTime() + (long)n * AbstractSonogramComponent.this.renderedSonogram.getTimeIncrement(), AbstractSonogramComponent.this.renderedSonogram.getTimeIncrement(), AbstractSonogramComponent.this.renderedSonogram.getStartTime(), AbstractSonogramComponent.this.renderedSonogram.getEndTime(), 1L, false);
                if (mouseEvent.getButton() == 1) {
                    AbstractSonogramComponent.this.selectionModel.setValue(AbstractSonogramComponent.this.cursorModel.getValue());
                }
            }
        };
    }

    private void createListeners() {
        MouseAdapter mouseAdapter = this.newDefaultMouseMotionAdapter();
        MouseAdapter mouseAdapter2 = this.newDefaultMouseClickAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter2);
        this.getCursorModel().addChangeListener(this.cursorModelChangeListener);
        this.getSelectionModel().addChangeListener(this.selectionModelChangeListener);
    }

    private void drawCursor(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.cursorPartition < 0) {
            return;
        }
        Rectangle2D rectangle2D2 = this.getAreaInSonogram(this.cursorPartition, -1);
        if (rectangle2D.getMinX() > rectangle2D2.getMaxX() || rectangle2D.getMaxX() < rectangle2D2.getMinX()) {
            return;
        }
        Color color = graphics2D.getColor();
        Composite composite = graphics2D.getComposite();
        graphics2D.setColor(this.cursorColor);
        graphics2D.setComposite(this.cursorComposite);
        graphics2D.fill(rectangle2D2);
        graphics2D.setComposite(composite);
        graphics2D.setColor(color);
    }

    private void drawExactSonogram(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (!rectangle2D.contains(rectangle2D2.getMinX(), rectangle2D.getMinY())) {
            return;
        }
        int n = (int)Math.max(rectangle2D.getMinX(), rectangle2D2.getMinX());
        int n2 = (int)Math.min(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
        int n3 = (int)Math.max(rectangle2D.getMinY(), rectangle2D2.getMinY());
        int n4 = (int)Math.min(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
        this.updateSonogramBounds(rectangle2D.getMinX(), rectangle2D.getMinY(), this.renderedSonogram.getImageWidth(), this.renderedSonogram.getImageHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.drawImage(this.renderedSonogram.getImage(), n, n3, n2, n4, n, n3, n2, n4, null);
    }

    private void drawScaledSonogram(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        int n = (int)rectangle2D.getMinX();
        int n2 = (int)rectangle2D.getMinY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        this.updateSonogramBounds(n, n2, n3, n4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.drawImage(this.renderedSonogram.getImage(), n, n2, n3, n4, null);
    }

    private void drawToSmallIndicator(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Stroke stroke = graphics2D.getStroke();
        Path2D.Double double_ = new Path2D.Double();
        double_.moveTo(rectangle2D.getMinX(), rectangle2D.getMinY());
        double_.lineTo(rectangle2D.getMaxX(), rectangle2D.getCenterY());
        double_.lineTo(rectangle2D.getMinX(), rectangle2D.getMaxY());
        double_.lineTo(rectangle2D.getMinX() + (rectangle2D.getMaxX() - rectangle2D.getMinX()) * 1.0 / 3.0, rectangle2D.getCenterY());
        double_.closePath();
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.fill(double_);
        graphics2D.setStroke(stroke);
    }

    private final void updateCursorPartition(int n) {
        if (this.cursorPartition != n) {
            int n2 = this.cursorPartition;
            this.cursorPartition = n;
            this.repaint(this.getAreaInSonogram(n2, -1).getBounds());
            this.repaint(this.getAreaInSonogram(this.cursorPartition, -1).getBounds());
        }
    }

    public Rectangle2D getAreaInSonogram(BoundedLongRangeModel boundedLongRangeModel) {
        int n = this.getTimePartition(boundedLongRangeModel, false);
        int n2 = this.getTimePartition(boundedLongRangeModel, true);
        if (n >= 0 && n < this.renderedSonogram.getTimeWidth() || n2 >= 0 && n2 < this.renderedSonogram.getTimeWidth() || boundedLongRangeModel.getValue() <= this.renderedSonogram.startEpochTimeMs && boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent() >= this.renderedSonogram.endEpochTimeMs) {
            if (n < 0) {
                n = 0;
            }
            if (n2 >= this.renderedSonogram.getTimeWidth()) {
                n2 = this.renderedSonogram.getTimeWidth() - 1;
            }
            Rectangle2D rectangle2D = this.getAreaInSonogram(n, -1);
            Rectangle2D rectangle2D2 = this.getAreaInSonogram(n2, -1);
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D2.getX() - rectangle2D.getX() + rectangle2D2.getWidth(), rectangle2D.getHeight());
            return rectangle2D;
        }
        return null;
    }

    public boolean[] isAreaInSonogramCropped(BoundedLongRangeModel boundedLongRangeModel) {
        int n = this.getTimePartition(boundedLongRangeModel, false);
        int n2 = this.getTimePartition(boundedLongRangeModel, true);
        if (n >= 0 && n < this.renderedSonogram.getTimeWidth() || n2 >= 0 && n2 < this.renderedSonogram.getTimeWidth() || boundedLongRangeModel.getValue() <= this.renderedSonogram.startEpochTimeMs && boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent() >= this.renderedSonogram.endEpochTimeMs) {
            boolean[] blArray = new boolean[]{false, false};
            if (n < 0) {
                blArray[0] = true;
            }
            if (n2 >= this.renderedSonogram.getTimeWidth() || n2 == -1) {
                blArray[1] = true;
            }
            return blArray;
        }
        return null;
    }

    protected final Rectangle2D getAreaInSonogram(int n, int n2) {
        double d = this.sonogramBounds.getX();
        double d2 = this.sonogramBounds.getY();
        double d3 = this.sonogramBounds.getWidth();
        double d4 = this.sonogramBounds.getHeight();
        if (n > -1 && n < this.renderedSonogram.getTimeWidth()) {
            d += (double)n * this.tileWidth;
            d3 = this.tileWidth;
        }
        if (n2 > -1 && n2 < this.renderedSonogram.getFrequencyWidth()) {
            d2 += (double)n2 * this.tileHeight;
            d4 = this.tileHeight;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    protected final Rectangle2D getExtendedAreaInSonogram(int n, int n2) {
        double d = this.sonogramBounds.getX();
        double d2 = this.sonogramBounds.getY();
        double d3 = this.sonogramBounds.getWidth();
        double d4 = this.sonogramBounds.getHeight();
        if (n > -1 && n < this.renderedSonogram.getTimeWidth()) {
            d += (double)n * this.tileWidth;
            d3 = (double)n2 * this.tileWidth;
        }
        LogUtil.info(this.getClass(), n2 + "::" + d3, false);
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    protected final int getFrequencyPartition(Point2D point2D) {
        return (int)(this.sonogramBounds.contains(point2D) ? (point2D.getY() - this.sonogramBounds.getY()) / this.tileWidth : -1.0);
    }

    public RenderedSonogramModel getRenderedSonogramModel() {
        return this.renderedSonogram;
    }

    protected final int getRGBForValue(int n) {
        return this.sonogramColorModel.getRGBForValue(n);
    }

    protected final Rectangle2D getSonogramBounds() {
        return this.sonogramBounds;
    }

    protected final int getTimePartition(Point2D point2D) {
        return (int)(this.sonogramBounds.contains(point2D) ? (point2D.getX() - this.sonogramBounds.getX()) / this.tileWidth : -1.0);
    }

    protected final int getTimePartition(BoundedLongRangeModel boundedLongRangeModel) {
        return this.getTimePartition(boundedLongRangeModel, false);
    }

    protected final int getTimePartition(BoundedLongRangeModel boundedLongRangeModel, boolean bl) {
        int n = -1;
        if (boundedLongRangeModel.getExtent() > 0L) {
            n = (int)Math.round(MathUtil.convertFromTo(bl ? (double)(boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent()) : (double)boundedLongRangeModel.getValue(), this.renderedSonogram.getStartTime(), this.renderedSonogram.getEndTime(), 0.0, this.renderedSonogram.getTimeWidth()));
        }
        return n < this.renderedSonogram.getTimeWidth() ? n : -1;
    }

    protected final int getRelativeExtensionTimePartition(long l) {
        int n = -1;
        if (l > 0L) {
            n = (int)Math.round(MathUtil.convertFromTo(this.renderedSonogram.getStartTime() + l, this.renderedSonogram.getStartTime(), this.renderedSonogram.getEndTime(), 0.0, this.renderedSonogram.getTimeWidth()));
        }
        return n < this.renderedSonogram.getTimeWidth() ? n : -1;
    }

    protected final boolean hasValidData() {
        return this.renderedSonogram != null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle2D rectangle2D = SwingUtil.componentDrawingArea(this);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.hasValidData()) {
            if (this.isScalingEnabled()) {
                this.drawScaledSonogram(graphics2D, rectangle2D);
            } else {
                this.drawExactSonogram(graphics2D, rectangle2D, rectangle);
            }
            if ((int)rectangle2D.getWidth() < this.renderedSonogram.getImage().getWidth()) {
                graphics2D.setColor(Color.RED);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + Math.max(0.0, rectangle2D.getWidth() - 12.0), rectangle2D.getY(), 10.0, rectangle2D.getHeight());
                this.drawToSmallIndicator(graphics2D, double_);
            }
            if (this.isCursorEnabled()) {
                this.drawCursor(graphics2D, rectangle);
            }
            if (this.isSelectionEnabled()) {
                this.selectionRenderer.paint(graphics2D);
            }
        }
        graphics2D.dispose();
    }

    protected final void setRenderedSonogramModel(RenderedSonogramModel renderedSonogramModel) {
        RenderedSonogramModel renderedSonogramModel2 = this.renderedSonogram;
        this.renderedSonogram = renderedSonogramModel;
        if (this.renderedSonogram != null) {
            this.cursorModel.setRangeProperties(this.renderedSonogram.getStartTime(), 0L, this.renderedSonogram.getStartTime(), this.renderedSonogram.getEndTime(), 1L, false);
        }
        this.selectionRenderer.setSonogram(this.renderedSonogram);
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTY_RENDERED_SONOGRAM, renderedSonogramModel2, this.renderedSonogram);
    }

    protected final void updateSonogramBounds(double d, double d2, double d3, double d4) {
        this.sonogramBounds.setRect(d, d2, d3, d4);
        this.tileWidth = d3 / (double)this.renderedSonogram.getTimeWidth();
        this.tileHeight = d4 / (double)this.renderedSonogram.getFrequencyWidth();
    }

    public final BoundedLongRangeModel getCursorModel() {
        return this.cursorModel;
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final BoundedLongRangeModel getSelectionModel() {
        return this.selectionModel;
    }

    public final SonogramColorModel getSonogramColorModel() {
        return this.sonogramColorModel;
    }

    public final boolean isCursorEnabled() {
        return this.cursorEnabled;
    }

    public final boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public final boolean isScalingEnabled() {
        return this.scalingEnabled;
    }

    public final void setCursorEnabled(boolean bl) {
        if (this.cursorEnabled != bl) {
            this.cursorEnabled = bl;
            this.repaint();
        }
    }

    public final void setSelectionEnabled(boolean bl) {
        if (this.selectionEnabled != bl) {
            this.selectionEnabled = bl;
            this.repaint();
        }
    }

    public final void setCursorModel(BoundedLongRangeModel boundedLongRangeModel) {
        BoundedLongRangeModel boundedLongRangeModel2 = this.cursorModel;
        BoundedLongRangeModel boundedLongRangeModel3 = boundedLongRangeModel != null ? boundedLongRangeModel : new DefaultBoundedLongRangeModel();
        boundedLongRangeModel2.removeChangeListener(this.cursorModelChangeListener);
        this.cursorModel = boundedLongRangeModel3;
        this.cursorModel.addChangeListener(this.cursorModelChangeListener);
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTION_MODEL, boundedLongRangeModel2, this.selectionModel);
    }

    public final void setScalingEnabled(boolean bl) {
        this.scalingEnabled = bl;
    }

    public final void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.selectionRenderer.setColor(this.selectionColor);
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTION_COLOR, color2, this.selectionColor);
    }

    public final void setSelectionAlpha(float f) {
        this.cursorComposite = AlphaComposite.getInstance(3, f);
        this.repaint();
    }

    public AlphaComposite getSelectionAlphaComposite() {
        return this.cursorComposite;
    }

    public final void setSelectionLineWidth(int n) {
        int n2 = this.selectionLineWidth;
        this.selectionLineWidth = n;
        this.selectionRenderer.setSelectionLineWidth(this.selectionLineWidth);
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTION_LINE_WIDTH, n2, this.selectionLineWidth);
    }

    public final void setCursorColor(Color color) {
        Color color2 = this.cursorColor;
        this.cursorColor = color;
        this.repaint();
        this.firePropertyChange(PROPERTY_CURSOR_COLOR, color2, this.selectionColor);
    }

    public final void setSelectionModel(BoundedLongRangeModel boundedLongRangeModel) {
        BoundedLongRangeModel boundedLongRangeModel2 = this.selectionModel;
        BoundedLongRangeModel boundedLongRangeModel3 = boundedLongRangeModel != null ? boundedLongRangeModel : new DefaultBoundedLongRangeModel();
        boundedLongRangeModel2.removeChangeListener(this.selectionModelChangeListener);
        this.selectionModel = boundedLongRangeModel3;
        this.selectionModel.addChangeListener(this.selectionModelChangeListener);
        this.selectionRenderer.setSelection(this.selectionModel);
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTION_MODEL, boundedLongRangeModel2, this.selectionModel);
    }

    public final void setSonogramColorModel(SonogramColorModel sonogramColorModel) {
        this.sonogramColorModel = sonogramColorModel;
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        if (this.renderedSonogram != null) {
            dimension.width += this.renderedSonogram.getImageWidth();
            dimension.height += this.renderedSonogram.getImageHeight();
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public class RenderedSonogramModel {
        private final long endEpochTimeMs;
        private final int frequencyWidth;
        private final BufferedImage image;
        private final long startEpochTimeMs;
        private final long incrementEpochTimeMs;
        private final int timeWidth;

        public RenderedSonogramModel(SonogramModel sonogramModel, BufferedImage bufferedImage) {
            this.startEpochTimeMs = DateTimeUtil.convertDoubleSToLongMs(sonogramModel.getStartEpochTime());
            this.endEpochTimeMs = DateTimeUtil.convertDoubleSToLongMs(sonogramModel.getEndEpochTime());
            this.incrementEpochTimeMs = DateTimeUtil.convertDoubleSToLongMs(sonogramModel.getEpochTimeIncrement());
            this.timeWidth = sonogramModel.getTimeWidth();
            this.frequencyWidth = sonogramModel.getFrequencyWidth();
            this.image = bufferedImage;
        }

        public final long getEndTime() {
            return this.endEpochTimeMs;
        }

        public final int getFrequencyWidth() {
            return this.frequencyWidth;
        }

        public final BufferedImage getImage() {
            return this.image;
        }

        public final int getImageHeight() {
            return this.image.getHeight();
        }

        public final int getImageWidth() {
            return this.image.getWidth();
        }

        public final long getStartTime() {
            return this.startEpochTimeMs;
        }

        public final long getTimeIncrement() {
            return this.incrementEpochTimeMs;
        }

        public final int getTimeWidth() {
            return this.timeWidth;
        }
    }
}

