/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.sonogram;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.sonogram.AbstractSonogramComponent;
import edu.geophys.commons.ui.sonogram.SelectionRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class BoxSelectionRenderer
implements SelectionRenderer {
    private static final AlphaComposite SELECTION_COMPOSITE = AlphaComposite.getInstance(3, 0.25f);
    private AbstractSonogramComponent parent = null;
    private AbstractSonogramComponent.RenderedSonogramModel sonogram = null;
    private BoundedLongRangeModel selection = null;
    private Color color = null;

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(SELECTION_COMPOSITE);
        graphics2D.setColor(this.parent.getSelectionColor());
        Rectangle2D rectangle2D = this.parent.getAreaInSonogram(this.selection);
        if (rectangle2D != null) {
            graphics2D.fill(rectangle2D);
        }
        graphics2D.dispose();
    }

    @Override
    public void setSelection(BoundedLongRangeModel boundedLongRangeModel) {
        this.selection = boundedLongRangeModel;
    }

    @Override
    public void setSonogram(AbstractSonogramComponent.RenderedSonogramModel renderedSonogramModel) {
        this.sonogram = renderedSonogramModel;
    }

    @Override
    public final void setParent(AbstractSonogramComponent abstractSonogramComponent) {
        this.parent = abstractSonogramComponent;
    }

    @Override
    public AbstractSonogramComponent getParent() {
        return this.parent;
    }

    @Override
    public BoundedLongRangeModel getSelection() {
        return this.selection;
    }

    @Override
    public Color getSelectionColor() {
        return this.color;
    }

    @Override
    public AbstractSonogramComponent.RenderedSonogramModel getSonogram() {
        return this.sonogram;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public int getSelectionLineWidth() {
        return 0;
    }

    @Override
    public void setSelectionLineWidth(int n) {
    }
}

