/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.sonogram;

import edu.geophys.commons.ui.sonogram.SonogramModel;

public class DefaultSonogramModel
implements SonogramModel {
    private final int[][] rawSonogram;
    private final int[] npsdf;
    private final int[] nsigf;
    private final int[] ndminf;
    private final int[] ndmaxf;
    private final int timeWidth;
    private final int frequencyWidth;
    private final double startEpochTime;
    private final double endEpochTime;
    private final double epochTimeIncrement;
    private final String stationID;
    private final boolean healthy;

    public DefaultSonogramModel(String string, double d, double d2, int[][] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        this.stationID = string;
        this.startEpochTime = d;
        this.endEpochTime = d2;
        this.rawSonogram = nArray;
        this.npsdf = nArray2;
        this.nsigf = nArray3;
        this.ndminf = nArray4;
        this.ndmaxf = nArray5;
        if (nArray != null) {
            this.healthy = true;
            this.frequencyWidth = nArray.length;
            this.timeWidth = nArray[0].length;
            this.epochTimeIncrement = (d2 - d) / (double)this.timeWidth;
        } else {
            this.healthy = false;
            this.frequencyWidth = 0;
            this.timeWidth = 0;
            this.epochTimeIncrement = 0.0;
        }
    }

    @Override
    public String getStationID() {
        return this.stationID;
    }

    @Override
    public double getStartEpochTime() {
        return this.startEpochTime;
    }

    @Override
    public double getEndEpochTime() {
        return this.endEpochTime;
    }

    @Override
    public int getFrequencyWidth() {
        return this.frequencyWidth;
    }

    @Override
    public int getTimeWidth() {
        return this.timeWidth;
    }

    @Override
    public final int getValue(int n, int n2) {
        return this.rawSonogram == null ? -1 : this.rawSonogram[n2][n];
    }

    @Override
    public final double getEpochTimeIncrement() {
        return this.epochTimeIncrement;
    }

    @Override
    public boolean isHealthy() {
        return this.healthy;
    }

    public String toString() {
        String string = "stationID=" + this.stationID + ", startEpochTime=" + this.startEpochTime + ", endEpochTime=" + this.endEpochTime + ", epochTimeIncrement=" + this.epochTimeIncrement + ", healthy=" + this.healthy + ", timeWidth=" + this.timeWidth + ", frequencyWidth=" + this.frequencyWidth + ", rawSonogram=" + this.rawSonogram + ", super=" + super.toString();
        return this.getClass().getName() + "[" + string + "]";
    }

    @Override
    public int[][] getRawSonogram() {
        return this.rawSonogram;
    }

    @Override
    public int[] getNpsdf() {
        return this.npsdf;
    }

    @Override
    public int[] getNsigf() {
        return this.nsigf;
    }

    @Override
    public int[] getNdmaxf() {
        return this.ndmaxf;
    }

    @Override
    public int[] getNdminf() {
        return this.ndminf;
    }
}

