/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.sonogram;

import edu.geophys.commons.ui.sonogram.AbstractSonogramComponent;
import edu.geophys.commons.ui.sonogram.SonogramModel;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class JDetailSonogram
extends AbstractSonogramComponent {
    private static final long serialVersionUID = -5822343731073264163L;
    private SonogramModel sonogramModel;
    private int cellWidth = 1;
    private int cellHeight = 1;

    public JDetailSonogram(Dimension dimension) {
        this.cellWidth = dimension.width;
        this.cellHeight = dimension.height;
    }

    public boolean isValidSonogram() {
        if (this.getModel() == null) {
            return false;
        }
        return this.getModel().getTimeWidth() > 21;
    }

    public final SonogramModel getModel() {
        return this.sonogramModel;
    }

    public final void setModel(SonogramModel sonogramModel) {
        this.sonogramModel = sonogramModel;
        this.setRenderedSonogramModel(new AbstractSonogramComponent.RenderedSonogramModel(this.sonogramModel, this.renderSonogram()));
        this.revalidate();
        this.repaint();
    }

    private final BufferedImage renderSonogram() {
        BufferedImage bufferedImage = new BufferedImage(this.sonogramModel.getTimeWidth() * this.cellWidth, this.sonogramModel.getFrequencyWidth() * this.cellHeight, 1);
        for (int i = 0; i < this.sonogramModel.getTimeWidth(); ++i) {
            for (int j = 0; j < this.sonogramModel.getFrequencyWidth(); ++j) {
                for (int k = 0; k < this.cellHeight; ++k) {
                    for (int i2 = 0; i2 < this.cellWidth; ++i2) {
                        bufferedImage.setRGB(i * this.cellWidth + i2, j * this.cellHeight + k, this.getRGBForValue(this.sonogramModel.getValue(i, j)));
                    }
                }
            }
        }
        return bufferedImage;
    }

    public void setDimension(Dimension dimension) {
        this.cellWidth = dimension.width;
        this.cellHeight = dimension.height;
        this.revalidate();
        this.repaint();
    }
}

